package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

/**
 * 客户分类
 * 
 * @author guoming
 *
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
@Controller
@RequestMapping("/supplier/category/")
public class SupplierCategoryController implements Serializable {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final long serialVersionUID = 1L;
	private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
	
	@Autowired
	private ISupplierCategoryService supplierCategoryService;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IBillCodeApi billCodeApi;

	/** bip 同步相关参数 */
	@Value("${juli.bip.pkOrg:0001A11000000000NKRQ}")
	private String juliBipPkOrg;
	private static final String SYNC_SUPPLY_TYPE_URL = "nccloud/api/uapbd/supplierclassmanage/supplierclass/supplierclassquery";
	@Autowired
	private IJuliApi juliApi;

	/**
	 * 新增或者修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		if(supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0) {
			SupplierCategoryEntity uniqueBean = supplierCategoryService.queryDetail(supplierCategoryVo.getId());
			uniqueBean.setCode(supplierCategoryVo.getCode());
			uniqueBean.setName(supplierCategoryVo.getName());
			uniqueBean.setSequence(supplierCategoryVo.getSequence());
			uniqueBean.setDescription(supplierCategoryVo.getDescription());
			supplierCategoryService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		} else {

			BillCodeParam billCodeParam = BillCodeParam.build(SUPPLIER_CATEGORY_BILL_CODE , InvocationInfoProxy.getTenantid(), supplierCategoryVo);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if(billCode.isSuccess()) {
				supplierCategoryVo.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			SupplierCategoryEntity supplierCategoryEntity = BeanMapper.map(supplierCategoryVo, SupplierCategoryEntity.class);
			supplierCategoryEntity.setId(IdWorker.getId());
			if(supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0) {
				SupplierCategoryEntity uniqueBean = supplierCategoryService.queryDetail(supplierCategoryEntity.getParentId());
				supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
			} else {
				supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
			}
			supplierCategoryService.saveOrUpdate(supplierCategoryEntity, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 根据主键ID查询供方分类详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
		SupplierCategoryEntity entity = supplierCategoryService.queryDetail(id);
		if(entity != null) {
			return CommonResponse.success(BeanMapper.map(entity, SupplierCategoryVO.class));
		}else{
			return CommonResponse.error("查询失败，参数错误！");
		}
	}
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		//先查询该分类下有没有子节点
		List<SupplierCategoryVO> children = supplierCategoryService.queryListByPid(id);
		if(children != null && children.size() > 0) {
			return CommonResponse.error("该分类有子节点不允许删除");
		}else{
			//查询该分类下有没有客户信息
			List<SupplierVO> supplierList = supplierService.queryListByCategoryId(id);
			if(supplierList != null && supplierList.size() > 0) {
				return CommonResponse.error("该分类下已有供方信息，不允许删除");
			}else{
				supplierCategoryService.delete(id);
				return CommonResponse.success("删除成功");
			}
		}
	}
	
	/**
	 * 查询供方分类分页列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.getOrderMap().put("sequence", "asc");
		List<SupplierCategoryEntity> dataList = supplierCategoryService.queryList(queryParam, false);

		List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 供方分类树
	 * 
	 * @param searchText
	 * @return
	 */
	@RequestMapping(value = "/querySupplierRefTree", method = RequestMethod.GET)
	@ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required = false) String searchText) {
        try {
    		QueryParam queryParam = new QueryParam();
    		if(StringUtils.isNotBlank(searchText)) {
    			queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
    		}
    		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    		queryParam.getOrderMap().put("sequence", "asc");
    		List<SupplierCategoryEntity> dataList = supplierCategoryService.queryList(queryParam, false);
    		
    		List<Map> resultMapList = new ArrayList<Map>();
        	Map map = null;
        	for(SupplierCategoryEntity entity: dataList) {
        		map = new HashMap<>();
        		map.put("id", entity.getId());
        		map.put("key", entity.getId());
        		map.put("name", entity.getName());
        		map.put("title", entity.getName());
        		map.put("parentId", entity.getParentId());
        		resultMapList.add(map);
        	}
        	List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        	return result;
        } catch (Exception e) {
            return null;
        }
    }


	@GetMapping("syncSupplierCategory")
	@ResponseBody
	public CommonResponse<String> syncSupplierCategory(){
		JSONObject param = new JSONObject();
		JSONObject postData = new JSONObject();
		JSONObject ufinterface = new JSONObject();

		ufinterface.put("sender","pm");
		JSONObject data = new JSONObject();
		JSONArray pk_org = new JSONArray();
		pk_org.add(juliBipPkOrg);
		data.put("pk_org",pk_org);
		ufinterface.put("data",data);
		postData.put("ufinterface",ufinterface);
		param.put("url",SYNC_SUPPLY_TYPE_URL);
		param.put("postData",postData.toJSONString());
		CommonResponse<String> res = juliApi.getDataFromBip(param);
		logger.info("同步供应商分类：请求地址：{}，请求参数：{}，响应：{}",SYNC_SUPPLY_TYPE_URL,postData.toJSONString(),JSONObject.toJSONString(res.getData()));
		if(res.isSuccess()){
			JSONObject supplierTypeResp = JSONObject.parseObject(res.getData());
			if(supplierTypeResp.getBoolean("success")){
				JSONArray supplierTypeList = supplierTypeResp.getJSONArray("data");
				if(supplierTypeList != null && !supplierTypeList.isEmpty()){
					for (Object o : supplierTypeList) {
						JSONObject supplierObject = (JSONObject) o;
						String pk = supplierObject.getString("pk_supplierclass");
						QueryParam param1 = QueryParam.getInstance();
						param1.getParams().put("sourceId",new Parameter(QueryParam.EQ,pk));
						List<SupplierCategoryEntity> supplierCategoryList = supplierCategoryService.queryList(param1,false);
						SupplierCategoryEntity supplierCategoryEntity;
						if(ListUtil.isEmpty(supplierCategoryList)){
							supplierCategoryEntity = new SupplierCategoryEntity();
							Long id = IdWorker.getId();
							supplierCategoryEntity.setId(id);
							supplierCategoryEntity.setInnerCode(id.toString());
							supplierCategoryEntity.setSourceId(pk);
							supplierCategoryEntity.setDescription("bip数据同步生成！"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date()));
							supplierCategoryEntity.setTenantId(999999L);
						}else {
							supplierCategoryEntity = supplierCategoryList.get(0);
						}
						supplierCategoryEntity.setCode(supplierObject.getString("code"));
						supplierCategoryEntity.setName(supplierObject.getString("name"));
						supplierCategoryService.saveOrUpdate(supplierCategoryEntity);
					}
				}
			}else {
				return CommonResponse.error("同步供应商分类失败！"+supplierTypeResp.getString("message"));
			}
		}
		return CommonResponse.success("同步供应商分类成功！");
	}
}
