package com.ejianc.foundation.share.service;

import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface ICustomerCategoryService extends IBaseService<CustomerCategoryEntity> {

	/**
	 * 根据Id查询客户分类详情
	 * 
	 * @param id
	 * @return
	 */
	CustomerCategoryEntity queryDetail(Long id);

	/**
	 * 根据父Id查询子节点列表
	 * 
	 * @param id
	 * @return
	 */
	List<CustomerCategoryVO> queryListByPid(Long id);

	/**
	 * 根据主键删除数据
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据客户分类编号查询实体
	 * 
	 * @param code
	 * @return
	 */
	CustomerCategoryVO queryByCode(String code);

}
