/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.customer.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.customer.bean.AreaClassEntity;
import com.ejianc.foundation.customer.service.IAreaClassService;
import com.ejianc.foundation.customer.vo.AreaClassVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"areaClass"})
public class AreaClassController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IAreaClassService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AreaClassVO> saveOrUpdate(@RequestBody AreaClassVO areaClassVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (areaClassVO.getId() != null && areaClassVO.getId() > 0L) {
            AreaClassEntity uniqueBean = this.service.queryDetail(areaClassVO.getId());
            uniqueBean.setCode(areaClassVO.getCode());
            uniqueBean.setName(areaClassVO.getName());
            uniqueBean.setSequence(areaClassVO.getSequence());
            this.service.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        AreaClassEntity areaClassEntity = (AreaClassEntity)((Object)BeanMapper.map((Object)areaClassVO, AreaClassEntity.class));
        areaClassEntity.setId(IdWorker.getId());
        if (areaClassEntity.getParentId() != null && areaClassEntity.getParentId() > 0L) {
            AreaClassEntity uniqueBean = this.service.queryDetail(areaClassEntity.getParentId());
            areaClassEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + areaClassEntity.getId());
        } else {
            areaClassEntity.setInnerCode(areaClassEntity.getId().toString());
        }
        this.service.saveOrUpdate((Object)areaClassEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AreaClassVO> queryDetail(Long id) {
        AreaClassEntity entity = (AreaClassEntity)((Object)this.service.selectById(id));
        AreaClassVO vo = (AreaClassVO)BeanMapper.map((Object)((Object)entity), AreaClassVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AreaClassVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AreaClassVO areaClassVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("sequence", "asc");
        param.getParams().put("name", new Parameter("like", (Object)param.getSearchText()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List dataList = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AreaClass-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAreaClassData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refAreaClassData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enablestate", new Parameter("eq", (Object)2));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        List areaClassEntities = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (AreaClassEntity entity : areaClassEntities) {
            String name = entity.getName();
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

