package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.util.ExcelReader;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户controller
 * 
 * @author guoming
 */
@Controller
@RequestMapping("/customer/")
public class CustomerController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private static final String CUSTOMER_BILL_CODE = "SUPPORT_CUSTOMER";
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ICustomerService customerService;
	@Autowired
	private ICustomerCategoryService customerCategoryService;

	//巨力改造：获取客户类型信息
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private ICustomerLinkerService customerLinkerService;

	/**
	 * 新增或者修改
	 * 
	 * @param CustomerVO
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody CustomerVO customerVo) {
		CommonResponse<String> response = customerService.saveOrUpdate(customerVo);
		return response;
	}
	
	/**
	 * 根据主键ID查询客户详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CustomerVO> queryDetail(@RequestParam Long id) {
		CustomerVO customerVo = customerService.queryDetail(id);
		JSONObject parent = new JSONObject();
		CustomerCategoryEntity e = customerCategoryService.selectById(customerVo.getCategoryId());
		parent.put("id",e.getId());
		parent.put("code",e.getCode());
		parent.put("name",e.getName());
		customerVo.setParent(parent);
		return CommonResponse.success(customerVo);
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		if(ListUtil.isNotEmpty(ids)){
			for (Long id : ids) {
				CommonResponse<String> response = billTypeApi.checkQuote("BT200422000000027",id);
				if(!response.isSuccess()){
					return CommonResponse.error("删除失败："+response.getMsg());
				}
			}
		}else {
			return CommonResponse.error("删除失败：主键为空!");
		}
		customerService.deleteCustomer(ids);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 查询客户分页列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		IPage<CustomerVO> pageData = customerService.queryPageList(queryParam);
		
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 导入模板下载
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download")
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response){
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "customer-import.xlsx", "客户导入模板");
	}
	
	/**
	 * excel导入
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelImport", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> excelImport(HttpServletRequest request, HttpServletResponse response) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
        	extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
            	isFailed = true;
            	break;
            }
        }
		
		if(isFailed) {
			return CommonResponse.error("文件格式不合法");
		}else{
			List<List<String>> result = ExcelReader.readExcel(mf);
			List<String> errorList = new ArrayList<String>();
			if(result != null && result.size() > 0) {

				//todo: 巨力改造：获取客户类型信息
				CommonResponse<List<DefdocDetailVO>> defDocDetailListResp = defdocApi.getDefDocByDefCode("customer_type");
				Map<String, DefdocDetailVO> defDocDetailMap = new HashMap<>();
				if(defDocDetailListResp.isSuccess()) {
					List<DefdocDetailVO> defDocDetailList = defDocDetailListResp.getData();
					if (CollectionUtils.isNotEmpty(defDocDetailList)){
						defDocDetailMap = defDocDetailList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
					}
				}else{
					throw new BusinessException("获取客户类型自定义档案信息失败！");
				}


				for(int i=0;i<result.size();i++) {
					List<String> datas = result.get(i);
					CustomerVO customerVo = null;
					CustomerCategoryVO customerCategoryVo = customerCategoryService.queryByCode(String.valueOf(datas.get(0)));
					if(customerCategoryVo != null) {
						if(StringUtils.isEmpty(datas.get(3))) {
							errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：统一社会信用代码不能为空！");
							continue;
						}else{
							customerVo = customerService.queryDetailBySocialCode(String.valueOf(datas.get(3)));
							if(customerVo != null) {
								errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：存在相同统一社会信用代码的客户！");
								continue;
							}
							customerVo = new CustomerVO();
						}
						if(StringUtils.isEmpty(datas.get(1))) {


							BillCodeParam billCodeParam = BillCodeParam.build(CUSTOMER_BILL_CODE , InvocationInfoProxy.getTenantid(), customerVo);
							CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
							if(billCode.isSuccess()) {
								customerVo.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
							}else{
								throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
							}


						}else {
							customerVo.setCode(datas.get(1));
						}
						if(StringUtils.isEmpty(datas.get(2))) {
							errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：客户名称不能为空！");
							continue;
						}
						customerVo.setName(String.valueOf(datas.get(2)));
						customerVo.setCategoryId(customerCategoryVo.getId());
						customerVo.setSocialCreditCode(String.valueOf(datas.get(3)));
						customerVo.setLegal(datas.get(4));
//						if(StringUtils.isNotEmpty(datas.get(5))) {
//							DefdocDetailVO taxPayerTypeVo = defdocDetailService.queryDetailByName(String.valueOf(datas.get(5)));
//							if(taxPayerTypeVo != null) {
//								customerVo.setTaxPayerType(taxPayerTypeVo.getId());
//							}
//						}
//						if(StringUtils.isNotEmpty(datas.get(6))) {
//							DefdocDetailVO customerTypeVo = defdocDetailService.queryDetailByName(String.valueOf(datas.get(6)));
//							if(customerTypeVo != null) {
//								customerVo.setCustomerType(customerTypeVo.getId());
//							}
//						}

						//巨力改造：存入客户类型信息
						if(StringUtils.isNotEmpty(datas.get(6))) {
							if (defDocDetailMap.containsKey(datas.get(6))){
								customerVo.setCustomerType(defDocDetailMap.get(datas.get(6)).getId());
							}
						}
						customerVo.setTelephone(datas.get(7));
						customerVo.setAreaStr(datas.get(8));
						customerVo.setBankName(datas.get(9));
						customerVo.setBankAccount(datas.get(10));
						customerVo.setBankCode(datas.get(11));
						customerVo.setAddressAndPhone(datas.get(12));
						//客户方联系人
						if(StringUtils.isNotEmpty(datas.get(13))) {
							List<CustomerLinkerVO> gridheaders = new ArrayList<CustomerLinkerVO>();
							
							String linkman = String.valueOf(datas.get(13));
							CustomerLinkerVO customerLinkerVo = customerLinkerService.queryByCustomerIdAndLinkman(customerVo.getId(), linkman);
							if(customerLinkerVo == null) {
								customerLinkerVo = new CustomerLinkerVO();
								customerLinkerVo.setRowState("add");
							}else{
								customerLinkerVo.setRowState("edit");
							}
							customerLinkerVo.setCustomerId(customerVo.getId());
							customerLinkerVo.setLinkman(datas.get(13));
							customerLinkerVo.setCellphone(datas.get(14));
							gridheaders.add(customerLinkerVo);
							customerVo.setGridheaders(gridheaders);
						}
						customerService.saveOrUpdate(customerVo);
					}else{
						errorList.add("第"+(i+1)+"行数据：" + datas.toString()+"导入失败，原因：客户分类编号不正确！");
						continue;
					}
				}
			}
			if(errorList.size() > 0) {
				
				errorList.add("导入成功："+(result.size() - errorList.size() )+"条, 失败：" +errorList.size()+"条");
				return CommonResponse.error("导入失败", errorList);
			}else{
				return CommonResponse.success("导入成功");
			}
		}
	}
	
	/**
	 * excel导出
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
		List<CustomerVO> customerVos = new ArrayList<>();
//		if(queryParam.getParams().get("categoryId")!=null){
//			if(StringUtils.isNotBlank(queryParam.getParams().get("categoryId").getValue().toString())){
				queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				customerVos = customerService.queryExportList(queryParam);
//			}
//		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", customerVos);
		ExcelExport.getInstance().export("customer-export.xlsx", beans, response);
	}


	/**
	 * @Author mrsir_wxp
	 * @Date 2020/5/22  客户参照
	 * @Description refer
	 * @Param [pageNumber, pageSize, searchText]
	 * @Return com.alibaba.fastjson.JSONObject
	 */
	@RequestMapping(value = "/refer", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<CustomerVO>> refer(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                   @RequestParam(defaultValue = "10") Integer pageSize,
                                                   @RequestParam(required=false) String relyCondition,
                                                   @RequestParam(required=false) String searchText,
                                                   @RequestParam(required=false) String condition) {
		QueryParam queryParam = new QueryParam();
		if(StringUtils.isNotBlank(relyCondition)) {
			Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
			queryParam.getParams().put("categoryId",new Parameter(QueryParam.EQ,categoryId));
		}

		if (StringUtils.isNotBlank(condition)) {
			JSONObject jsonObject = JSON.parseObject(condition);
			//带此标识insideFlag只查询内部客户
			if (jsonObject.containsKey("insideFlag")) {
				LambdaUpdateWrapper<CustomerCategoryEntity> wrapper = new LambdaUpdateWrapper<>();
				wrapper.eq(CustomerCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
				wrapper.eq(CustomerCategoryEntity::getName, "内部客户");
				List<CustomerCategoryEntity> list = customerCategoryService.list(wrapper);
				if (CollectionUtils.isNotEmpty(list)) {
					queryParam.getParams().put("categoryId", new Parameter(QueryParam.EQ, list.get(0).getId()));
				}
			}
		}

		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);

		queryParam.getFuzzyFields().add("code");
		queryParam.getFuzzyFields().add("name");
		queryParam.getFuzzyFields().add("socialCreditCode");
		IPage<CustomerVO> pageData = customerService.queryPageList(queryParam);
		return CommonResponse.success("查询数表参照成功", pageData);
	}

}
