package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.vo.StandardProcessVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.StandardProcessMapper;
import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.service.IStandardProcessService;

import java.util.List;
import java.util.Map;

/**
 * 标准工序档案表
 * 
 * @author generator
 * 
 */
@Service("standardProcessService")
public class StandardProcessServiceImpl extends BaseServiceImpl<StandardProcessMapper, StandardProcessEntity> implements IStandardProcessService{
    @Autowired
    private StandardProcessMapper standardProcessMapper;
    @Override
    public List<StandardProcessEntity> queryListByCategoryId(Long categoryId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter(QueryParam.EQ, categoryId));
        List<StandardProcessEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return entityList;
        }
        return null;
    }

    @Override
    public void updateStateByCategoryId(List<Long> categoryIds, Integer enabled) {
        UpdateWrapper<StandardProcessEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("category_id", categoryIds);
        updateWrapper.set("enabled", enabled);
        super.update(updateWrapper);
    }

    @Override
    public IPage<StandardProcessVO> queryRefStandardProcessPage(Map<String, Object> params) {
        List<StandardProcessEntity> dataList = standardProcessMapper.queryRefStandardProcessList(params);
        Long dataCount = standardProcessMapper.queryRefStandardProcessCount(params);


        List<StandardProcessVO> materialVOS = BeanMapper.mapList(dataList, StandardProcessVO.class);
        IPage<StandardProcessVO> page = new Page<>();
        page.setRecords(materialVOS);

        page.setTotal(dataCount);
        return page;
    }

    @Override
    public List<StandardProcessEntity> queryByCode(String code, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        if (null != id){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<StandardProcessEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return entityList;
        }
        return null;
    }
}
