package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.StandardProcessCategoryMapper;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;


import com.ejianc.foundation.share.bean.StandardProcessCategoryEntity;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标准工序档案分类表
 * 
 * @author generator
 * 
 */
@Service("standardProcessCategoryService")
public class StandardProcessCategoryServiceImpl extends BaseServiceImpl<StandardProcessCategoryMapper, StandardProcessCategoryEntity> implements IStandardProcessCategoryService{

    @Autowired
    private StandardProcessCategoryMapper standardProcessCategoryMapper;
    @Autowired
    private IStandardProcessService standardProcessService;

    @Override
    public List<StandardProcessCategoryVO> queryListByPid(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parent_id", new Parameter(QueryParam.EQ, id));
        List<StandardProcessCategoryEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return BeanMapper.mapList(entityList, StandardProcessCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<StandardProcessCategoryEntity> queryByCode(String code, Long id) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, code));
        if (null != id){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<StandardProcessCategoryEntity> entityList = super.queryList(queryParam);
        if(entityList != null) {
            return entityList;
        }
        return null;
    }

    @Override
    public void updateEnabled(Integer enabled, String innerCode) {
        standardProcessCategoryMapper.updateEnabled(enabled, innerCode);
    }

    @Override
    public void changeCategoryEnableState(Long id, Integer enabled) {
        //1、查询出该分类
        StandardProcessCategoryEntity entity = super.selectById(id);
        if (entity == null) {
            throw new BusinessException("该分类不存在！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        List<StandardProcessCategoryEntity> categoryEntities = super.queryList(queryParam);
        List<Long> categoryIds = categoryEntities.stream().map(StandardProcessCategoryEntity::getId).collect(Collectors.toList());
        standardProcessCategoryMapper.updateEnabled(enabled, entity.getInnerCode());
        standardProcessService.updateStateByCategoryId(categoryIds, enabled);
    }

    @Override
    public List<StandardProcessCategoryEntity> queryListEntityTree(Map<String, Object> params) {
        return standardProcessCategoryMapper.queryListEntityTree(params);
    }

    @Override
    public List<StandardProcessCategoryEntity> queryProcessCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<String, Object>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<StandardProcessCategoryEntity> resultList = standardProcessCategoryMapper.queryProcessCategoryList(condition);
        return resultList;
    }
}
