package com.ejianc;

import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableEurekaClient
@EnableFeignClients
@SpringBootApplication
@ConfigurationProperties
@EnableScheduling
@ComponentScan
public class ShareServerApp {
	
	public static void main(String[] args) {
        Resource bannerResource = new ClassPathResource("banner.txt");
        Banner banner = new ResourceBanner(bannerResource);

        new SpringApplicationBuilder(ShareServerApp.class).banner(banner).run(args);
    }

}
