package com.ejianc.business.signaturemanage.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.signaturemanage.bean.SignMgrSignatoryEntity;
import com.ejianc.business.signaturemanage.vo.SignatureCenterVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
@Mapper
public interface SignMgrSignatoryMapper extends BaseCrudMapper<SignMgrSignatoryEntity> {

	/**
	 * 签章中心分页查询
	 *
	 * @param tenantId         租户ID
	 * @param signatureContact 签署人手机号
	 * @param jobStatus        签章状态
	 *
	 * @return 签章中心分页
	 */
	IPage<SignatureCenterVO> querySignCenterPage(Page<SignatureCenterVO> page,
	                                             @Param("tenantId") Long tenantId,
	                                             @Param("signatureContact") String signatureContact,
	                                             @Param("jobStatus") Integer jobStatus,
	                                             @Param("billName") String billName,
	                                             @Param("billCode") String billCode,
	                                             @Param("contractName") String contractName,
	                                             @Param("projectName") String projectName,
	                                             @Param("useSealType") String useSealType,
	                                             @Param("sortField") String sortField);

	/**
	 * 根据契约锁合同文件Id查询当前签署方第一个非个人印章的契约锁单面名称
	 *
	 * @param contractId
	 * @return
	 */
	List<String> getFirstNoPsSealSourceCompanyName(@Param("contractId") Long contractId);
}
