package com.ejianc.framework.skeleton.template.es;

/**  
 * Title: EsCudService
 *   
 * Description: es增删该操作
 * 
 * @author guominga  
 * 
 * @date 2020年2月15日  
 */
public interface IBaseEsCudDao {

	/**
	 * 新增和修改操作
	 * 
	 * @param index: 对应的索引库 
	 * @param entity：索引实体
	 */
	public void insertOrUpdateOne(String index, EsEntity entity);
	
	/**
	 * 批量插入或修改
	 * 
	 * @param index: 索引库 
	 * @param entity：索引实体
	 */
	public void insertOrUpdateBatch(String index, EsEntity entity);
	
	
	/**
	 * 批量删除
	 * 
	 * @param index:索引库 
	 * @param entity：索引实体
	 */
	public void deleteBatch(String index, EsEntity entity);
	
	/**
	 * 根据主键ID删除
	 * 
	 * @param index：索引库 
	 * @param entity：索引实体
	 */
	public void deleteById(String index, EsEntity entity);
}
