package com.ejianc.framework.skeleton.billState.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;

public interface ICommonBusinessService {

	/**
	 * 加载流程变量
	 *
	 * @param billId
	 * @param billTypeCode
	 * @return
	 */
	public default CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	public default CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	public default CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	public default CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	public default CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public default CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @param other	其他参数（为了预防后面添加参数）
	 * @return
	 */
	public default CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		return CommonResponse.success();
	};

	/**
	 * 审批--新的审批人员时回调
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 *
	 * -------当前节点-------
	 * @param taskKey 审批节点key
	 * @param taskName 审批节点名称
	 * @param sign 节点标志
	 *
	 * --------当前审批人的节点---------/*****
	 * @param approveUserList 审批人
				 * taskKey    审批节点key
				 * taskName   审批节点名称
				 * sign       节点标志
				 * approveUserList  审批人员(List<String>)
	 * @return
	 */
	public default CommonResponse<String> approveUserList(CommonBusinessParam businessParam){
		return CommonResponse.success();
	}
}
