package com.ejianc.framework.skeleton.billTenant.mapper;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**  
  * Title: CommonMapper  
  * Description: 
  * @author guominga  
  * @date 2020年2月17日  
  */
@Mapper
public interface BillTenantMapper {

	@Select("SELECT s.tenant_id statisticTenantId ,count(*) billSumCount from ${tableName} s WHERE s.dr = 0 GROUP BY s.tenant_id ORDER  BY billSumCount DESC")
	List<JSONObject> queryTenantTotalBill(@Param("tableName") String tableName);

	@Select("SELECT count(*) billSumCount from ${tableName} s WHERE s.dr = 0 AND s.tenant_id = #{tenantId} AND s.create_time BETWEEN #{startDate} AND #{endDate} ")
	int queryTenantTodayBill(@Param("tableName") String tableName,@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("tenantId") String tenantId);

}
