package com.ejianc.framework.skeleton.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CheckValidKey {

    /**
     * 校验SqlKey是否非法
     * \\b  表示 限定单词边界
     * 比如  select 不通过   1select则是可以的
     */
    private static String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(from|concat|updatexml|select|update|union|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|drop|execute)\\b)";
    private static Pattern sqlPattern = Pattern.compile(reg, Pattern.CASE_INSENSITIVE);

    //关键字校验
    public static boolean isValidKey(String value) {
        /*
        select|update|and|or|delete|insert|truncate|char|into|substr|ascii|declare|exec|count|master|into|drop|
                        execute|table|char|declare|sitename|xp_cmdshell|like|from|grant|use|group_concat|column_name|
                        information_schema.columns|table_schema|union|where|order|by|
        \\*|\\;|\\-|\\--|\\+|\\,|\\//|\\/|\\%|\\#
        -------忽略的字符：
        and|or|substr|count|like|where|order|by|\\*|\\;|\\-|\\--|\\+|\\,|\\//|\\/|\\%|\\#
         */
        List<String> keys = Arrays.asList("select", "update", "delete", "insert", "truncate", "char", "into", "ascii", "declare",
                "exec", "master", "drop", "execute", "table", "sitename", "xp_cmdshell", "from", "grant", "use", "group_concat",
                "column_name", "information_schema.columns", "table_schema", "union");
        if (StringUtils.isNotBlank(value)) {
            String[] words = value.split(";");//按;分割值
            Map<String, String> keyWords = new HashMap<>();
            for (String word : words) {
                String[] words1 = word.split("\\s+");//按空格分割值
                for (String w : words1) {
                    keyWords.put(w, w);
                }
            }
            for(String key : keys){
                if(keyWords.get(key)!=null){
                    return false;
                }
            }
        }
        //校验通过
        return true;
    }
}
