package com.ejianc.framework.skeleton.commonQuery.service.impl;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.commonQuery.mapper.CommonQueryMapper;
import com.ejianc.framework.skeleton.commonQuery.service.ICommonQueryService;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("commonQueryService")
public class CommonQueryServiceImpl implements ICommonQueryService {

    @Autowired
    private CommonQueryMapper commonQueryMapper;

    @Override
    public CommonResponse<Integer> queryNumberBySql(Map<String, String> queryMap) {
        Integer number = null;
        String sql = queryMap.get("sql");
        if(StringUtils.isNotBlank(sql)){
            sql = sql.replaceAll("\\#\\{tenantId\\}", InvocationInfoProxy.getTenantid().toString()).replaceAll("\\$\\{tenantId\\}", InvocationInfoProxy.getTenantid().toString());
            sql = sql.replaceAll("\\#\\{orgId\\}", InvocationInfoProxy.getOrgId().toString()).replaceAll("\\$\\{orgId\\}", InvocationInfoProxy.getOrgId().toString());
            sql = sql.replaceAll("\\#\\{userId\\}", InvocationInfoProxy.getUserid().toString()).replaceAll("\\$\\{userId\\}", InvocationInfoProxy.getUserid().toString());
            sql = sql.replaceAll("\\#\\{employeeId\\}", InvocationInfoProxy.getEmployeeId().toString()).replaceAll("\\$\\{employeeId\\}", InvocationInfoProxy.getEmployeeId().toString());
            sql = sql.replaceAll("\\#\\{userCode\\}", InvocationInfoProxy.getUsercode()).replaceAll("\\$\\{userCode\\}", InvocationInfoProxy.getUsercode());
        }
        number = commonQueryMapper.queryNumberBySql(sql);
        return CommonResponse.success(number);
    }
}
