package com.ejianc.framework.skeleton.dataPush;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.RequestMethod;

import java.io.InputStream;
import java.util.Map;


public interface ISystemDataPushService {

	/**
	 *
	 * 数据流向  公有云平台====调用=>>>>私有化平台
	 *
	 * @param systemId        第三方系统id，来源公有云企业档案id或者数据中的systemId 必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @return
	 */
	CommonResponse<String> exchangeDataWithThirdSystem(
			String url,
			RequestMethod method,
			String postData,
			String systemId
	);
	/**
	 *
	 * 数据流向  公有云平台====调用=>>>>私有化平台 包含文件传输 POST方式
	 *
	 * @param systemId        第三方系统id，来源公有云企业档案id或者数据中的systemId  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,以/开头 必填
	 * @param params          参数
	 * @param files           文件列表
	 * @return
	 */
	CommonResponse<String> exchangeDataAndFilesWithThirdSystem(
			String url,
			Map<String, String> params,
			String systemId,
			Map<String, Map<String, InputStream>> files
	);


	/**
	 *
	 * 数据流向  私有化平台====调用=>>>>公有云平台
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @param supplierId      数据中的供应商ID ，必填
	 * @return
	 */
	CommonResponse<String> exchangeDataWithEachLinkSystem(
			String url,
			RequestMethod method,
			String postData,
			String supplierId
	);

	/**
	 *
	 * 数据流向  私有化平台====调用=>>>>公有云平台 包含文件传输 POST方式
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx，以/开头 注意，工程路径后面需要加上openapi，否则无法调通， 必填
	 * @param supplierId      数据中的供应商ID ，必填
	 * @param params          参数
	 * @param files           文件列表
	 * @return
	 */
	CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(
			String url,
			Map<String, String> params,
			String supplierId,
			Map<String, Map<String, InputStream>> files
	);

	/**
	 *
	 * 通用接口
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx?xxx=xxx&xxx=xxx,注意get方式参数拼接在这个参数后面，以/开头  注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param method          RequestMethod.POST  或者 RequestMethod.GET  必填
	 * @param postData        post方式请求的数据  post方式必填
	 * @param appId           私有化平台(益企联)注册的AppID ，必填
	 * @param appSecret       私有化平台(益企联)注册的secret ，必填
	 * @param appHost         私有化平台(益企联)注册的请求地址，实例：http://testpm.ynsbj.com 以/结尾，必填
	 * @return
	 */
	CommonResponse<String> exchangeDataWithUniversal(
			String url,
			RequestMethod method,
			String postData,
			String appId,
			String appSecret,
			String appHost
	);

	/**
	 *
	 * 通用接口 携带文件
	 *
	 * @param url             接口后端地址，例如 /ejc-xxx-web/openapi/xxx/xxx,注意，工程路径后面需要加上openapi，否则无法调通，必填
	 * @param appId           私有化平台(益企联)注册的AppID ，必填
	 * @param appSecret       私有化平台(益企联)注册的secret ，必填
	 * @param appHost         私有化平台(益企联)注册的请求地址，实例：http://testpm.ynsbj.com 以/结尾，必填
	 * @param params          参数
	 * @param files           文件列表
	 * @return
	 */
	CommonResponse<String> exchangeDataAndFilesWithUniversal(
			String url,
			Map<String, String> params,
			Map<String, Map<String, InputStream>> files,
			String appId,
			String appSecret,
			String appHost
	);

	CommonResponse<JSONObject> getAuthInfoBySupplierId(String supplierId);
}
