package com.ejianc.framework.skeleton.refer.common.controller;

import java.util.Map;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.common.service.CommonReferService;

/**  
  * refer服务公共
  * 
  * @author guominga  
  * @date 2020年2月13日  
  */
@Controller
@RequestMapping(value = "commonrefer")
public class CommonReferController {
	private static final String REFER_CACHE_KEY = "refer_cache_key:";
	@Autowired
	RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private CommonReferService commonReferService;

	@RequestMapping(value = "getrefervalue")
	@ResponseBody
	public JSONArray getCommonReferData(@RequestParam Map<String,Object> refMapList) {		
		return commonReferService.getReferEntity(refMapList);
	}
	
	@RequestMapping(value = "getAuditInfo")
	@ResponseBody
	public JSONObject getAuditInfo(@RequestParam Map<String,Object> refMapList) {
		return commonReferService.getAuditInfoEntity(refMapList);
	}

	/** 删除某个参照缓存数据 */
	@GetMapping(value = "remCache")
	@ResponseBody
	public CommonResponse<String> remCache(@RequestParam("referCode") String referCode, @RequestParam(value = "value",required = false) String value) {
		String cacheKey = REFER_CACHE_KEY + referCode;
		if(StringUtils.isNotEmpty(value)){
			cacheKey = REFER_CACHE_KEY + referCode + ":" + value;
		}
		if("support-defdoc".equals(referCode)){
			//自定义档案需要添加租户作为唯一性key
			cacheKey = REFER_CACHE_KEY + "-" + InvocationInfoProxy.getTenantid() + referCode;
			if(StringUtils.isNotEmpty(value)){
				cacheKey = REFER_CACHE_KEY + "-" + InvocationInfoProxy.getTenantid() + referCode + ":" + value;
			}
		}
		redisTemplate.delete(cacheKey);
		return CommonResponse.success("操作成功！");
	}

}
