package com.ejianc.business.store.api;

import com.ejianc.business.store.hystrix.StoreFlowHystrix;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.InOutVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 出入库管理api
 * @date 2022/1/17
 */
@FeignClient(name = "ejc-store-web", url = "${common.env.feign-client-url}", path = "ejc-store-web", fallback = StoreFlowHystrix.class)
public interface IStoreFlowApi {


    /**
     * @param queryParam
     * @description: 查询流水
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/9
     */
    @RequestMapping(value = "/api/storeFlow/getFlowList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowList(@RequestBody QueryParam queryParam);

    /**
     * @param queryParam
     * @description: 查询出入库关系
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.InOutVO>
     * @author 姜轶凯
     * @date: 2022/3/9
     */
    @RequestMapping(value = "/api/storeFlow/getInOutVOList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<InOutVO>> getInOutVOList(@RequestBody QueryParam queryParam);


}
