package com.ejianc.business.store.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 仓库出入库关系表
 *
 * @author generator
 */
@ApiModel("仓库出入库关系表")
public class InOutVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("项目ID")
    private Long inProjectId;
    @ApiModelProperty("项目名称")
    private String inProjectName;
    @ApiModelProperty("仓库")
    private Long inStoreId;
    @ApiModelProperty("仓库名称")
    private String inStoreName;
    @ApiModelProperty("材料类型编码")
    private String materialType;
    @ApiModelProperty("材料类型名称")
    private String materialTypeName;
    @ApiModelProperty("项目ID")
    private Long outProjectId;
    @ApiModelProperty("项目名称")
    private String outProjectName;
    @ApiModelProperty("仓库")
    private Long outStoreId;
    @ApiModelProperty("仓库名称")
    private String outStoreName;
    @ApiModelProperty("出库日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;
    @ApiModelProperty("出入库类型:收料入库等")
    private Integer inOutType;
    @ApiModelProperty("出入库类型名称")
    private String inOutTypeName;
    @ApiModelProperty("入库单据id")
    private Long inBillId;
    @ApiModelProperty("入库单据编码")
    private String inBillCode;
    @ApiModelProperty("出库单据id")
    private Long outBillId;
    @ApiModelProperty("出库单据编码")
    private String outBillCode;
    @ApiModelProperty("物资分类id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额含税")
    private BigDecimal taxMny;
    @ApiModelProperty("金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("领料单位id")
    private Long pickUnitId;
    @ApiModelProperty("领料单位")
    private String pickUnitName;
    @ApiModelProperty("领料合同id")
    private Long pickContractId;
    @ApiModelProperty("领料合同")
    private String pickContractName;
    @ApiModelProperty("出库数量")
    private BigDecimal outNum;
    @ApiModelProperty("出库占用数量")
    private BigDecimal outLockNum;
    @ApiModelProperty("退库数量")
    private BigDecimal returnStoreNum;
    @ApiModelProperty("生效时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    @ApiModelProperty("生效状态0自由1已生效")
    private Integer effectiveState;
    @ApiModelProperty("针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成")
    private Integer outUseFlag;
    @ApiModelProperty("入库流水ID")
    private Long inFlowId;
    @ApiModelProperty("出库流水ID")
    private Long outFlowId;
    @ApiModelProperty("入库单据明细id")
    private Long inBillDetailId;
    @ApiModelProperty("出库单据明细id")
    private Long outBillDetailId;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;


    @ApiModelProperty("剩余可退数量")
    private BigDecimal surplusReturnStoreNum;


    @ApiModelProperty("出库净值(无税)")
    private BigDecimal outNetMny;
    @ApiModelProperty("出库净值")
    private BigDecimal outNetTaxMny;
    @ApiModelProperty("消耗材使用用途主键")
    private Long materialUseId;
    @ApiModelProperty("消耗材使用用途名称")
    private String materialUseName;
    @ApiModelProperty("成本科目主键")
    private Long subjectId;
    @ApiModelProperty("成本科目编码")
    private String subjectCode;
    @ApiModelProperty("成本科目名称")
    private String subjectName;


    //不存库, 周转材先进先出返回
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal purchasePrice;
    @ApiModelProperty("原值单价")
    private BigDecimal purchaseTaxPrice;

    @ApiModelProperty("原值金额(无税)")
    private BigDecimal purchaseMny;
    @ApiModelProperty("原值金额")
    private BigDecimal purchaseTaxMny;

    @ApiModelProperty("仓库属性")
    private String storeType;

    @ApiModelProperty("仓库属性名称")
    private String storeTypeName;

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public BigDecimal getPurchaseTaxPrice() {
        return purchaseTaxPrice;
    }

    public void setPurchaseTaxPrice(BigDecimal purchaseTaxPrice) {
        this.purchaseTaxPrice = purchaseTaxPrice;
    }

    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }

    public BigDecimal getPurchaseTaxMny() {
        return purchaseTaxMny;
    }

    public void setPurchaseTaxMny(BigDecimal purchaseTaxMny) {
        this.purchaseTaxMny = purchaseTaxMny;
    }

    public BigDecimal getOutNetMny() {
        return outNetMny;
    }

    public void setOutNetMny(BigDecimal outNetMny) {
        this.outNetMny = outNetMny;
    }

    public BigDecimal getOutNetTaxMny() {
        return outNetTaxMny;
    }

    public void setOutNetTaxMny(BigDecimal outNetTaxMny) {
        this.outNetTaxMny = outNetTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }


    /**
     * 项目ID
     */
    public Long getInProjectId() {
        return inProjectId;
    }

    /**
     * 项目ID
     */
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }

    /**
     * 项目名称
     */
    public String getInProjectName() {
        return inProjectName;
    }

    /**
     * 项目名称
     */
    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    /**
     * 仓库
     */
    public Long getInStoreId() {
        return inStoreId;
    }

    /**
     * 仓库
     */
    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    /**
     * 仓库名称
     */
    public String getInStoreName() {
        return inStoreName;
    }

    /**
     * 仓库名称
     */
    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    /**
     * 材料类型编码
     */
    public String getMaterialType() {
        return materialType;
    }

    /**
     * 材料类型编码
     */
    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    /**
     * 材料类型名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料类型名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    /**
     * 项目ID
     */
    public Long getOutProjectId() {
        return outProjectId;
    }

    /**
     * 项目ID
     */
    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }

    /**
     * 项目名称
     */
    public String getOutProjectName() {
        return outProjectName;
    }

    /**
     * 项目名称
     */
    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }

    /**
     * 仓库
     */
    public Long getOutStoreId() {
        return outStoreId;
    }

    /**
     * 仓库
     */
    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }

    /**
     * 仓库名称
     */
    public String getOutStoreName() {
        return outStoreName;
    }

    /**
     * 仓库名称
     */
    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }

    /**
     * 出库日期
     */
    public Date getOutDate() {
        return outDate;
    }

    /**
     * 出库日期
     */
    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    /**
     * 出入库类型:收料入库等
     */
    public Integer getInOutType() {
        return inOutType;
    }

    /**
     * 出入库类型:收料入库等
     */
    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }

    /**
     * 出入库类型名称
     */
    public String getInOutTypeName() {
        return inOutTypeName;
    }

    /**
     * 出入库类型名称
     */
    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }

    /**
     * 入库单据id
     */
    public Long getInBillId() {
        return inBillId;
    }

    /**
     * 入库单据id
     */
    public void setInBillId(Long inBillId) {
        this.inBillId = inBillId;
    }

    /**
     * 入库单据编码
     */
    public String getInBillCode() {
        return inBillCode;
    }

    /**
     * 入库单据编码
     */
    public void setInBillCode(String inBillCode) {
        this.inBillCode = inBillCode;
    }

    /**
     * 出库单据id
     */
    public Long getOutBillId() {
        return outBillId;
    }

    /**
     * 出库单据id
     */
    public void setOutBillId(Long outBillId) {
        this.outBillId = outBillId;
    }

    /**
     * 出库单据编码
     */
    public String getOutBillCode() {
        return outBillCode;
    }

    /**
     * 出库单据编码
     */
    public void setOutBillCode(String outBillCode) {
        this.outBillCode = outBillCode;
    }

    /**
     * 物资分类id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    /**
     * 物资分类编码
     */
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    /**
     * 物资分类编码
     */
    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * 规格型号
     */
    public String getMaterialSpec() {
        return materialSpec;
    }

    /**
     * 规格型号
     */
    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    /**
     * 计量单位id
     */
    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    /**
     * 计量单位id
     */
    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }

    /**
     * 计量单位
     */
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    /**
     * 计量单位
     */
    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }

    /**
     * 单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    /**
     * 单价
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }

    /**
     * 金额含税
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 金额含税
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 金额(无税)
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额(无税)
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    /**
     * 领料单位id
     */
    public Long getPickUnitId() {
        return pickUnitId;
    }

    /**
     * 领料单位id
     */
    public void setPickUnitId(Long pickUnitId) {
        this.pickUnitId = pickUnitId;
    }

    /**
     * 领料单位
     */
    public String getPickUnitName() {
        return pickUnitName;
    }

    /**
     * 领料单位
     */
    public void setPickUnitName(String pickUnitName) {
        this.pickUnitName = pickUnitName;
    }

    /**
     * 领料合同id
     */
    public Long getPickContractId() {
        return pickContractId;
    }

    /**
     * 领料合同id
     */
    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }

    /**
     * 领料合同
     */
    public String getPickContractName() {
        return pickContractName;
    }

    /**
     * 领料合同
     */
    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }

    /**
     * 出库数量
     */
    public BigDecimal getOutNum() {
        return outNum;
    }

    /**
     * 出库数量
     */
    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }

    /**
     * 出库占用数量
     */
    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    /**
     * 出库占用数量
     */
    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }

    /**
     * 退库数量
     */
    public BigDecimal getReturnStoreNum() {
        return returnStoreNum;
    }

    /**
     * 退库数量
     */
    public void setReturnStoreNum(BigDecimal returnStoreNum) {
        this.returnStoreNum = returnStoreNum;
    }

    /**
     * 生效时间
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效时间
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * 生效状态0自由1已生效
     */
    public Integer getEffectiveState() {
        return effectiveState;
    }

    /**
     * 生效状态0自由1已生效
     */
    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }

    /**
     * 针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成
     */
    public Integer getOutUseFlag() {
        return outUseFlag;
    }

    /**
     * 针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成
     */
    public void setOutUseFlag(Integer outUseFlag) {
        this.outUseFlag = outUseFlag;
    }

    /**
     * 入库流水ID
     */
    public Long getInFlowId() {
        return inFlowId;
    }

    /**
     * 入库流水ID
     */
    public void setInFlowId(Long inFlowId) {
        this.inFlowId = inFlowId;
    }

    /**
     * 出库流水ID
     */
    public Long getOutFlowId() {
        return outFlowId;
    }

    /**
     * 出库流水ID
     */
    public void setOutFlowId(Long outFlowId) {
        this.outFlowId = outFlowId;
    }

    /**
     * 入库单据明细id
     */
    public Long getInBillDetailId() {
        return inBillDetailId;
    }

    /**
     * 入库单据明细id
     */
    public void setInBillDetailId(Long inBillDetailId) {
        this.inBillDetailId = inBillDetailId;
    }

    /**
     * 出库单据明细id
     */
    public Long getOutBillDetailId() {
        return outBillDetailId;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    /**
     * 出库单据明细id
     */
    public void setOutBillDetailId(Long outBillDetailId) {
        this.outBillDetailId = outBillDetailId;
    }

    public BigDecimal getSurplusReturnStoreNum() {
        return surplusReturnStoreNum;
    }

    public void setSurplusReturnStoreNum(BigDecimal surplusReturnStoreNum) {
        this.surplusReturnStoreNum = surplusReturnStoreNum;
    }

    public Long getMaterialUseId() {
        return materialUseId;
    }

    public void setMaterialUseId(Long materialUseId) {
        this.materialUseId = materialUseId;
    }

    public String getMaterialUseName() {
        return materialUseName;
    }

    public void setMaterialUseName(String materialUseName) {
        this.materialUseName = materialUseName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
}
