package com.ejianc.business.store.api;

import com.ejianc.business.store.hystrix.StoreManageHystrix;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.OutFlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.StoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 出入库管理api
 * @date 2022/1/17
 */
@FeignClient(name = "ejc-store-web", url = "${common.env.feign-client-url}", path = "ejc-store-web", fallback = StoreManageHystrix.class)
public interface IStoreManageApi {


    /**
     * @param storeManageVO 数据
     * @description: 出入库操作
     * 1 收料入库/调拨入库/调拨入库/领料出库
     * 入参 :
     * storeId  仓库id
     * inOutTypeEnum 出入库类型
     * flowVOList  入库/出库流水
     * outEffectiveON 出库单生效状态 出库审批通过/弃审放true, 保存修改/删除放false
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/17
     */
    @RequestMapping(value = "/api/storeManage/inOutStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStore(@RequestBody StoreManageVO storeManageVO);

    /**
     * @param storeManageVO 数据
     * @description: 出入库逆向操作
     * 1 收料入库/调拨入库/调拨入库/领料出库
     * 入参 :
     * sourceIdsForRollBack  来源单据ids
     * inOutTypeEnum 出入库类型
     * outEffectiveON 出库单生效状态 出库审批通过/弃审放true, 保存修改/删除放false
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/17
     */
    @RequestMapping(value = "/api/storeManage/inOutStoreRollback", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> inOutStoreRollback(@RequestBody StoreManageVO storeManageVO);


    /**
     * @param storeManageVO
     * @description: 查询物资库存现存量库存均价
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/9
     */
    @RequestMapping(value = "/api/storeManage/surplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> surplusMaterialPrice(@RequestBody StoreManageVO storeManageVO);


    /**
     * @param storeManageVO
     * @description: 更新摊销金额
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/2
     */
    @RequestMapping(value = "/api/storeManage/updateShareMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> updateShareMny(@RequestBody StoreManageVO storeManageVO);


    /**
     * @param storeManageVO
     * @description: 周转材库存现存量库存均价
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/3
     */
    @RequestMapping(value = "/api/storeManage/turnSurplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> turnSurplusMaterialPrice(@RequestBody StoreManageVO storeManageVO);


    /**
     * @param
     * @description: 根据合同id 出入库类型 查询明细
     * @author 姜轶凯
     * @date: 2022/3/4
     */
    @PostMapping(value = "/api/storeManage/getFlowListByContractId")
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowListByContractId(@RequestBody OutFlowVO outFlowVO);

    /**
     * @param
     * @description: 根据采购合同id 出入库类型 查询 入库金额
     * @author 姜轶凯
     * @date: 2022/5/28
     */
    @PostMapping(value = "/api/storeManage/queryInstoreTaxMnyByPurchaseContractId")
    @ResponseBody
    CommonResponse<BigDecimal> queryInstoreTaxMnyByPurchaseContractId(@RequestBody OutFlowVO outFlowVO);


    /**
     * 查询或创建指定仓库
     *
     * @param storeVO
     * @return
     */
    @PostMapping(value = "/api/storeManage/autoByProjectId")
    @ResponseBody
    CommonResponse<StoreVO> autoByProjectId(@RequestBody StoreVO storeVO);
}