package com.ejianc.business.store.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.store.vo.SettleDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 废旧物资对账结算
 * 
 * @author generator
 * 
 */
public class SettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long orgId; // 所属组织
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long supplierId; // 乙方单位id
    private String supplierName; // 乙方单位name
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date settleDate; // 对账日期
    private Long contractId; // 合同名称id
    private String contractName; // 合同名称name
    private String contractCode; // 合同编码
    private BigDecimal currentSettleMny; // 本期对账金额
    private BigDecimal sumSettleMny; // 累计对账金额(含本期)
    private BigDecimal lastSumSettleMny; // 上期累计对账金额
    private List<Long> disposeIds; //
    private Long twoOrgId; //二级组织id
    private BigDecimal weight; //占比

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    private List<SettleDetailVO> settleDetailList = new ArrayList<>(); // 废旧物资对账结算-子表

    public BigDecimal getLastSumSettleMny() {
        return lastSumSettleMny;
    }

    public void setLastSumSettleMny(BigDecimal lastSumSettleMny) {
        this.lastSumSettleMny = lastSumSettleMny;
    }

    public List<Long> getDisposeIds() {
        return disposeIds;
    }

    public void setDisposeIds(List<Long> disposeIds) {
        this.disposeIds = disposeIds;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    @ReferSerialTransfer(referCode="other-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getCurrentSettleMny() {
        return currentSettleMny;
    }

    public void setCurrentSettleMny(BigDecimal currentSettleMny) {
        this.currentSettleMny = currentSettleMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    
     public List<SettleDetailVO> getSettleDetailList() {
        return settleDetailList;
     }

     public void setSettleDetailList(List<SettleDetailVO> settleDetailList) {
        this.settleDetailList = settleDetailList;
     }
}
