package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.StoreMapper;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.service.IStoreService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 仓库表
 * 
 * @author generator
 * 
 */
@Service("storeService")
public class StoreServiceImpl extends BaseServiceImpl<StoreMapper, StoreEntity> implements IStoreService{


    @Autowired
    private StoreMapper storeMapper;

    @Autowired
    private ISurplusService surplusService;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.eq("s.dr", StoreCommonConsts.NO);
        wrapper.groupBy("s.id");
        return storeMapper.queryStoreList(wrapper);
    }

    /***
     *  设置仓库属性
     * @param storeManageVO
     * @return
     */
    @Override
    public StoreManageVO  setStoreAttr(StoreManageVO storeManageVO) {
        String storeType;
        String storeTypeName;
        Long storeId = storeManageVO.getStoreId();

        StoreEntity storeEntity = storeMapper.selectById(storeId);
        if (StoreAttrEnum.SELFPURCHASE.getCode().equals(storeEntity.getAttrFlag().toString())){
            storeType=StoreAttrEnum.SELFPURCHASE.getCode();
            storeTypeName=StoreAttrEnum.SELFPURCHASE.getDescription();
        }else {
            storeType=StoreAttrEnum.ASUPPLY.getCode();
            storeTypeName=StoreAttrEnum.ASUPPLY.getDescription();
        }
        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty(flowVOList)){
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
            }
        }
        storeManageVO.setFlowVOList(flowVOList);

        //直入直出时，出库流水也需要初始化仓库材料属性
        List<FlowVO> straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty(straightOutFlowVOList)){
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
            }
        }
        return storeManageVO;
    }

    /**
     * 校验仓库能否删除
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id",id);
        queryWrapper.gt("surplus_num",0);
        List<SurplusEntity> list = surplusService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list) && list.size()>0){
            return CommonResponse.error("当前仓库有物资");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}
