/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.StoreMapper;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeService")
public class StoreServiceImpl
extends BaseServiceImpl<StoreMapper, StoreEntity>
implements IStoreService {
    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    private ISurplusService surplusService;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = StoreServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"s.dr", (Object)StoreCommonConsts.NO);
        wrapper.groupBy(new Object[]{"s.id"});
        return this.storeMapper.queryStoreList(wrapper);
    }

    @Override
    public StoreManageVO setStoreAttr(StoreManageVO storeManageVO) {
        String storeTypeName;
        String storeType;
        Long storeId = storeManageVO.getStoreId();
        StoreEntity storeEntity = (StoreEntity)((Object)this.storeMapper.selectById(storeId));
        if (StoreAttrEnum.SELFPURCHASE.getCode().equals(storeEntity.getAttrFlag().toString())) {
            storeType = StoreAttrEnum.SELFPURCHASE.getCode();
            storeTypeName = StoreAttrEnum.SELFPURCHASE.getDescription();
        } else {
            storeType = StoreAttrEnum.ASUPPLY.getCode();
            storeTypeName = StoreAttrEnum.ASUPPLY.getDescription();
        }
        List flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
            }
        }
        storeManageVO.setFlowVOList(flowVOList);
        List straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)straightOutFlowVOList)) {
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
            }
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)id);
        queryWrapper.gt((Object)"surplus_num", (Object)0);
        List list = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed3\u5e93\u6709\u7269\u8d44");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

