package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.bean.HandleDetailEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.HandleDetailMapper;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.*;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.HandleMapper;
import com.ejianc.business.store.bean.HandleEntity;
import com.ejianc.business.store.service.IHandleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 仓库材料处置表
 *
 * @author generator
 *
 */
@Service("handleService")
public class HandleServiceImpl extends BaseServiceImpl<HandleMapper, HandleEntity> implements IHandleService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private HandleDetailMapper handleDetailMapper;

    @Autowired
    private StoreManageService storeManageService;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse saveCheckHandle(HandleEntity entity) {
        //更新子表信息
        if(null != entity.getId()) {
            handleDetailMapper.delByHandleId(entity.getId());
        }

        List<HandleDetailEntity> subList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        // 设置主表分类名称
        String names = "";
        for (HandleDetailEntity detailEntity:handleSubList
        ) {
            if(detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                subList.add(detailEntity);
            }
            names = names+detailEntity.getMaterialCategoryName()+",";
        }
        if(handleSubList.size() > 0){
            names = names.substring(0,names.length()-1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate(entity, false);

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.材料处置,0);
                flowVO.setSourceBillTypeName("处置出库");
                flowVO.setSourceBillTypeCode("BT220125000000010");
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(item.getHandleNum());
                flowVO.setTaxPrice(item.getHandlePrice());
                flowVO.setTaxMny(item.getHandleMny());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = handleInOut(ids,false);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids,Boolean outEffectiveON){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            HandleEntity entity = super.selectById(item);
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t:handleSubList
            ) {
                if(t.getHandleNum().compareTo(BigDecimal.ZERO) > 0){
                    checkFlag = true;
                    break;
                }
            }
            if(checkFlag){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                storeManageVO.setOutEffectiveON(outEffectiveON);
                CommonResponse<StoreManageVO> commonResponse;
                if(outEffectiveON){
                    commonResponse = storeManageService.inOutStore(storeManageVO);
                }else{
                    commonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                }
                if(!commonResponse.isSuccess()){
                    return commonResponse;
                }
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO handleVO) {
        HandleEntity handleEntity = baseMapper.selectById(handleVO.getId());
        if (CollectionUtils.isNotEmpty(handleVO.getHandleSubList())) {
            List<HandleDetailEntity> handleDetailEntities = BeanMapper.mapList(handleVO.getHandleSubList(), HandleDetailEntity.class);
            handleEntity.setHandleSubList(handleDetailEntities);
        }
        super.saveOrUpdate(handleEntity, false);
        //推送数据
        this.costPush(handleEntity);
        return CommonResponse.success(BeanMapper.map(handleEntity, HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity handleEntity) {
        logger.info("开始costPush");
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            for (HandleDetailEntity entity : handleSubList) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(handleSubList)) {
            newRelationFlag = "0";
        }

        //更新是否关联
        LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(HandleEntity::getId, handleEntity.getId());
        updateWrapper.set(HandleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = handleEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(handleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-材料处置Id---{}",handleEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(handleEntity.getId());
                logger.info("结果"+ JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(handleEntity);
            }
        }
    }
    private void saveCost(HandleEntity handleEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<HandleDetailEntity> handleSubList = handleEntity.getHandleSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleSubList)) {
            //根据物资id查询物资编码
            List<Long> materialIds = handleSubList.stream().map(HandleDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));
            for (HandleDetailEntity entity : handleSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleSubTaxMny());
                costDetailVO.setHappenMny(entity.getHandleSubMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_HANDLE");
                costDetailVO.setSourceTabType("STORE_HANDLE_SUB");
                //新加的
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.材料处置单.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/storeHandle/card?id="+handleEntity.getId());
                costDetailVO.setProjectId(handleEntity.getProjectId());
                //2022-8-16新增传输字段
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    ;
}
