/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.PickReturnDetailEntity;
import com.ejianc.business.store.bean.PickReturnEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.mapper.PickReturnMapper;
import com.ejianc.business.store.service.IPickReturnService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.PickReturnVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pickReturnService")
public class PickReturnServiceImpl
extends BaseServiceImpl<PickReturnMapper, PickReturnEntity>
implements IPickReturnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {
        this.removeByIds(ids, true);
    }

    @Override
    public CommonResponse<PickReturnVO> pushCost(PickReturnVO pickReturnVO) {
        PickReturnEntity pickReturnEntity = (PickReturnEntity)((Object)((PickReturnMapper)this.baseMapper).selectById(pickReturnVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)pickReturnVO.getPickReturnDetailList())) {
            List pickReturnDetailEntities = BeanMapper.mapList((Iterable)pickReturnVO.getPickReturnDetailList(), PickReturnDetailEntity.class);
            pickReturnEntity.setPickReturnDetailList(pickReturnDetailEntities);
        }
        super.saveOrUpdate((Object)pickReturnEntity, false);
        this.costPush(pickReturnEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)pickReturnEntity), PickReturnVO.class));
    }

    @Override
    public void costPush(PickReturnEntity pickReturnEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(pickReturnDetailList)) {
            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(pickReturnDetailList)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{pickReturnEntity.getId()});
        updateWrapper.set(PickReturnEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = pickReturnEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(pickReturnEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u4ed3\u5e93\u76d8\u70b9Id---{}", (Object)pickReturnEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(pickReturnEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(pickReturnEntity);
        }
    }

    private void saveCost(PickReturnEntity pickReturnEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        if (CollectionUtils.isNotEmpty(pickReturnDetailList)) {
            List materialIds = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                if (!StoreAttrEnum.SELFPURCHASE.getCode().equals(String.valueOf(entity.getAttrFlag()))) continue;
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getInstoreId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getTaxMny()));
                costDetailVO.setHappenMny(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getMny()));
                costDetailVO.setNum(ComputeUtil.convertToMinusNumber((BigDecimal)entity.getReturnNum()));
                costDetailVO.setHappenDate(pickReturnEntity.getInstoreDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_PICKRETURN");
                costDetailVO.setSourceTabType("STORE_PICKRETURN_SUB");
                costDetailVO.setProjectId(pickReturnEntity.getProjectId());
                costDetailVO.setSourceBillCode(pickReturnEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6750\u6599\u9000\u5e93.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/pickReturn/card?id=" + pickReturnEntity.getId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getMaterialUnitId());
                costDetailVO.setUnit(entity.getMaterialUnitName());
                costDetailVO.setSpec(entity.getMaterialSpec());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

