package com.ejianc.business.store.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 材料统计
 *
 * @author generator
 */
@Controller
@RequestMapping("statisics")
@Api(value = "仓库流水表", tags = {"仓库流水表"})
public class StatisicsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IFlowService service;

    @Autowired
    private SessionManager sessionManager;


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        Object inOutFlag = param.getParams().get("inOutFlag").getValue();
        //出入库标识不为空
        if (inOutFlag != null) {
            //入库模糊查询
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.ONE) {
                fuzzyFields.add("purchaseContractName");
                fuzzyFields.add("supplierName");
            }
            //出库模糊查询
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.TWO) {
                fuzzyFields.add("pickContractName");
                fuzzyFields.add("pickUnitName");
            }
        }

        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(null == param.getParams().get("turnFlag")) {
            param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            if (param.getParams().containsKey("parentOrgId")) {
                Object parentOrgId = param.getParams().get("parentOrgId").getValue();
                String parentOrgIdStr = String.valueOf(parentOrgId);
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(parentOrgIdStr)), true, "查询失败，获取当前本下组织信息失败。");
                param.getParams().remove("parentOrgId");
            } else {
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<FlowEntity> page = new Page<>();
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        /** contractFlag是否有合同字段，vo实体都没有，临时字段记录是否有合同，根据合同id是否为空判断，最后将contractFlag返回前端回显筛选条件 */
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = param.getParams().get("contractFlag").getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.EQ, null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.NE, null));
            }
            param.getParams().remove("contractFlag");
            page = service.queryPage(param, false);
            param.getParams().put("contractFlag", new Parameter(QueryParam.EQ, contractFlag));
        } else {
            page = service.queryPage(param, false);
        }


        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));
        pageData.getRecords().forEach(item -> {
            if (item.getPurchaseContractId() != null && !"".equals(item.getPurchaseContractName())) {
                item.setContractFlagStr("有");
            } else {
                item.setContractFlagStr("无");
            }
        });
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("材料进场统计报表导出")
    @RequestMapping(value = "/inExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void inExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("purchaseContractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = null;
        if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = param.getParams().get("parentOrgId").getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(parentOrgIdStr)), true, "查询失败，获取当前本下组织信息失败。");
            param.getParams().remove("parentOrgId");
        } else {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }

        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }


        List<FlowEntity> list = new ArrayList<>();
        /** contractFlag是否有合同字段，vo实体都没有，临时字段记录是否有合同，根据合同id是否为空判断，最后将contractFlag返回前端回显筛选条件 */
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = param.getParams().get("contractFlag").getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.EQ, null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.NE, null));
            }
            param.getParams().remove("contractFlag");
            list = service.queryList(param);
            param.getParams().put("contractFlag", new Parameter(QueryParam.EQ, contractFlag));
        } else {
            list = service.queryList(param);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<FlowVO> dataList = new ArrayList<>();
        list.forEach(item -> {
            FlowVO vo = BeanMapper.map(item, FlowVO.class);
            if (vo.getPurchaseContractId() != null && !"".equals(vo.getPurchaseContractName())) {
                vo.setContractFlagStr("有");
            } else {
                vo.setContractFlagStr("无");
            }
            if (vo.getSourceType() != null && vo.getSourceType() == 0) {
                vo.setSourceTypeStr("自制");
            } else {
                vo.setSourceTypeStr("订单");
            }
            dataList.add(vo);
        });

        beans.put("records", dataList);
        ExcelExport.getInstance().export("statisics-inList-export.xlsx", beans, response);
    }

    @ApiOperation("材料出库统计报表导出")
    @RequestMapping(value = "/outExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void outExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        Object inOutFlag = param.getParams().get("inOutFlag").getValue();
        //出入库标识不为空
        if (inOutFlag != null) {
            //入库模糊查询
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.ONE) {
                fuzzyFields.add("purchaseContractName");
                fuzzyFields.add("supplierName");
            }
            //出库模糊查询
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.TWO) {
                fuzzyFields.add("pickContractName");
                fuzzyFields.add("pickUnitName");
            }
        }

        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            if (param.getParams().containsKey("parentOrgId")) {
                Object parentOrgId = param.getParams().get("parentOrgId").getValue();
                String parentOrgIdStr = String.valueOf(parentOrgId);
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(parentOrgIdStr)), true, "查询失败，获取当前本下组织信息失败。");
                param.getParams().remove("parentOrgId");
            } else {
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<FlowEntity> page = new Page<>();
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        /** contractFlag是否有合同字段，vo实体都没有，临时字段记录是否有合同，根据合同id是否为空判断，最后将contractFlag返回前端回显筛选条件 */
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = param.getParams().get("contractFlag").getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.EQ, null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.NE, null));
            }
            param.getParams().remove("contractFlag");
            page = service.queryPage(param, false);
            param.getParams().put("contractFlag", new Parameter(QueryParam.EQ, contractFlag));
        } else {
            page = service.queryPage(param, false);
        }


        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));
        pageData.getRecords().forEach(item -> {
            if (item.getPurchaseContractId() != null && !"".equals(item.getPurchaseContractName())) {
                item.setContractFlagStr("有");
            } else {
                item.setContractFlagStr("无");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("statisics-outList-export.xlsx", beans, response);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/sendReceiveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> sendReceiveList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));

        //根据分类查询所有下级数据
        Parameter materialCategoryId = param.getParams().get("materialCategoryId");
        if(null!=materialCategoryId&&null!=materialCategoryId.getValue()){
            param.getParams().remove("materialCategoryId");
            CommonResponse<List<MaterialCategoryVO>> res  = shareMaterialApi.queryCategoryAllListByPid(Long.valueOf(materialCategoryId.getValue().toString()));
            List<Long> MaterialCategoryIds = res.getData().stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
            param.getParams().put("materialCategoryId", new Parameter(QueryParam.IN,MaterialCategoryIds));
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            if (param.getParams().containsKey("parentOrgId")) {
                Object parentOrgId = param.getParams().get("parentOrgId").getValue();
                String parentOrgIdStr = String.valueOf(parentOrgId);
                param.getParams().remove("parentOrgId");
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(parentOrgIdStr)), true, "查询失败，获取当前本下组织信息失败。");
            } else {
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        Page<FlowVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("store_id", "material_id");
        wrapper.eq("dr", StoreCommonConsts.NO);
        List<FlowVO> list = service.getSendReceiveList(page, wrapper);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/sendReceiveDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<FlowVO>> sendReceiveDetailList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));

        Object inOutFlagVal = param.getParams().get("inOutFlag").getValue();
        Integer inOutFlag = Integer.valueOf(inOutFlagVal.toString());

        param.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, inOutFlag));

        if (StoreCommonConsts.IN_OUT_TYPE_IN.equals(inOutFlag)) {
            param.getParams().put("inOutType", new Parameter(QueryParam.NE, InOutTypeEnum.材料退货.getInOutType()));
        } else {
            param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, StoreCommonConsts.YES));
            param.getParams().put("inOutType", new Parameter(QueryParam.NE, InOutTypeEnum.领料退库.getInOutType()));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.orderByDesc("source_bill_date");
        List<FlowEntity> list = service.list(wrapper);
        List<FlowVO> flowVOS = BeanMapper.mapList(list, FlowVO.class);
        return CommonResponse.success("查询列表数据成功！", flowVOS);
    }

    @ApiOperation("仓库收发导出")
    @RequestMapping(value = "/sendReceiveExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void sendReceiveExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter(QueryParam.EQ, StoreCommonConsts.NO));

        param.setPageIndex(1);
        param.setPageSize(10000);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            if (param.getParams().containsKey("parentOrgId")) {
                Object parentOrgId = param.getParams().get("parentOrgId").getValue();
                String parentOrgIdStr = String.valueOf(parentOrgId);
                param.getParams().remove("parentOrgId");
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong(parentOrgIdStr)), true, "查询失败，获取当前本下组织信息失败。");
            } else {
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        Page<FlowVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("store_id", "material_id");
        List<FlowVO> list = service.getSendReceiveList(page, wrapper);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("statisics-sendReceiveList-export.xlsx", beans, response);
    }
}
