package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.StoreMapper;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 仓库表
 * 
 * @author generator
 * 
 */
@Service("storeService")
public class StoreServiceImpl extends BaseServiceImpl<StoreMapper, StoreEntity> implements IStoreService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISurplusService surplusService;

    @Autowired
    private IProjectApi projectApi;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.eq("s.dr", StoreCommonConsts.NO);
        wrapper.groupBy("s.id");
        return storeMapper.queryStoreList(wrapper);
    }

    /***
     *  设置仓库属性
     * @param storeManageVO
     * @return
     */
    @Override
    public StoreManageVO  setStoreAttr(StoreManageVO storeManageVO) {
        String storeType;
        String storeTypeName;
        Long storeId = storeManageVO.getStoreId();

        StoreEntity storeEntity = storeMapper.selectById(storeId);
        if (StoreAttrEnum.SELFPURCHASE.getCode().equals(storeEntity.getAttrFlag().toString())){
            storeType=StoreAttrEnum.SELFPURCHASE.getCode();
            storeTypeName=StoreAttrEnum.SELFPURCHASE.getDescription();
        }else {
            storeType=StoreAttrEnum.ASUPPLY.getCode();
            storeTypeName=StoreAttrEnum.ASUPPLY.getDescription();
        }
        //查询到对象 低值易耗品仓库
        StoreEntity consumableStore = new StoreEntity();
        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        List<FlowVO> consumableList = flowVOList.stream().filter(e -> null != e.getConsumableFlag() && "1".equals(e.getConsumableFlag())).collect(Collectors.toList());
        if (!consumableList.isEmpty()){
            Long projectId = consumableList.get(0).getProjectId();
            if (null!=projectId){
                //没有新增返回对应的 低值易耗品仓库
                consumableStore = autoByProjectId(projectId, 3);
            }
        }
        if (CollectionUtils.isNotEmpty(flowVOList)){
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
                if (null!=flowVO.getConsumableFlag()&&"1".equals(flowVO.getConsumableFlag())){
                    if (null!=consumableStore){
                        flowVO.setStoreId(consumableStore.getId());
                        flowVO.setStoreType(StoreAttrEnum.CONSUMABLE.getCode());
                        flowVO.setStoreType(StoreAttrEnum.CONSUMABLE.getDescription());

                    }
                }
            }
        }
        storeManageVO.setFlowVOList(flowVOList);

        //直入直出时，出库流水也需要初始化仓库材料属性
        List<FlowVO> straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty(straightOutFlowVOList)){
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
                if (null!=straightOut.getConsumableFlag()&&"1".equals(straightOut.getConsumableFlag())){
                    if (null!=consumableStore){
                        straightOut.setStoreId(consumableStore.getId());
                        straightOut.setStoreType(StoreAttrEnum.CONSUMABLE.getCode());
                        straightOut.setStoreType(StoreAttrEnum.CONSUMABLE.getDescription());
                    }
                }
            }
        }
        return storeManageVO;
    }

    /**
     * 校验仓库能否删除
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id",id);
        queryWrapper.gt("surplus_num",0);
        List<SurplusEntity> list = surplusService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list) && list.size()>0){
            return CommonResponse.error("当前仓库有物资");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    /**
     *  1 新增仓库属性 attrFlag = 3 低值易耗品仓库 前端修改类型不能修改不能删除 或者后端接口控制
     *      2 出接口跟据项目id 插入一条 低值易耗品仓库
     *      3 参照改造 condition 放入属性 attrFlagThree 是否查询 低值易耗品仓库
     *      4 根据项目id查询是否存在类型为 低值易耗品仓库 的厂库
     *      5 入库单明细新增默认字段 是否低值易耗品 默认为否 推送逻辑优化 进入低值易耗品库房？？
     *      是只进入低值易耗品库房 还是 为是的数据 同时 进入普通仓库和低值易耗品仓库 因为不确定是那个地方入库 无法确定代码
     */
    @Override
    public StoreEntity autoByProjectId(Long projectId ,Integer attrFlag){
        StoreEntity storeEntity = new StoreEntity();

        QueryWrapper<StoreEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("attr_flag",attrFlag);
        queryWrapper.eq("dr",StoreCommonConsts.NO);
        if (StoreCommonConsts.ONE.equals(attrFlag)){
            queryWrapper.eq("state",StoreCommonConsts.YES);
        }
        int count = this.count(queryWrapper);
        if (count==0){
            //
            CommonResponse<ProjectSetVO> projectResponse = projectApi.queryProjectDetail(projectId);
            if (!projectResponse.isSuccess()){
                logger.error("获取项目信息失败, {}", projectResponse.getMsg());
                throw new BusinessException("获取项目信息失败 请联系管理员");
            }
            ProjectSetVO project = projectResponse.getData();
            storeEntity.setId(IdWorker.getId());
            storeEntity.setProjectId(project.getId());
            storeEntity.setProjectName(project.getName());
            storeEntity.setProjectCode(project.getCode());
            storeEntity.setOrgId(project.getProjectDepartmentId());
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(project.getProjectDepartmentId());
            if (!orgResponse.isSuccess()){
                logger.error("获取组织信息失败, {}", orgResponse.getMsg());
                throw new BusinessException("获取组织信息失败 请联系管理员");
            }
            OrgVO orgVO = orgResponse.getData();
            storeEntity.setOrgName(orgVO.getName());
            storeEntity.setOrgCode(orgVO.getCode());
            storeEntity.setParentOrgId(orgVO.getParentId());
            storeEntity.setParentOrgName(orgVO.getpFName());
            storeEntity.setParentOrgCode(orgVO.getpCode());
            storeEntity.setProjectType(StoreCommonConsts.YES);
            storeEntity.setState(StoreCommonConsts.YES);
            storeEntity.setName(project.getName());
            storeEntity.setAttrFlag(attrFlag);
            //如果是 自购材 则为默认
            if (StoreCommonConsts.ONE.equals(attrFlag)){
                storeEntity.setDefaultFlag(StoreCommonConsts.YES);
            }else {
                storeEntity.setDefaultFlag(StoreCommonConsts.NO);
            }
            storeEntity.setTotalMny(BigDecimal.ZERO);
            storeEntity.setMemo("自增");
            this.saveOrUpdate(storeEntity);

        }else {
            List<StoreEntity> storeEntities = this.list(queryWrapper);
            if (!storeEntities.isEmpty()){
                storeEntity = storeEntities.get(0);
            }
        }
        return storeEntity;
    }
}
