package com.ejianc.business.store.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.ComputeStoreVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.SurplusVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @author songlx
 * @version 1.0
 * @description: 仓库管理公共服务controller
 * @date 2022/2/9
 */
@Api(value = "库存公共接口", tags = {"库存公共接口"})
@Controller
@RequestMapping("storeManage")
public class StoreManageController implements Serializable {

    @Autowired
    StoreManageService storeManageService;


    @Autowired
    IFlowService flowService;

    /**
     * @param storeManageVO
     * @description: 查询物资库存现存量库存均价
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/9
     */
    @RequestMapping(value = "/surplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreManageVO> surplusMaterialPrice(@RequestBody StoreManageVO storeManageVO) {
        return storeManageService.surplusMaterialPrice(storeManageVO);
    }

    /**
     * @param computeStoreVO
     * @description: 重新计算仓库物资余量和金额
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/18
     */
    @ApiOperation("重新计算仓库物资余量和金额")
    @RequestMapping(value = "/computeStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<ComputeStoreVO> computeStore(@RequestBody ComputeStoreVO computeStoreVO) {
        List<SurplusVO> list = flowService.computeStore(computeStoreVO);
        computeStoreVO.setSurplusList(list);
        return CommonResponse.success("重新计算成功！", computeStoreVO);
    }


    /**
     * @param param
     * @description: 根据流水计算出来仓库应该有的库存
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/2/18
     */
    @ApiOperation("流水计算仓库列表")
    @RequestMapping(value = "/computeStoreList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<IPage<SurplusVO>> computeStoreList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        QueryWrapper wrapper = changeToQueryWrapper(param);

        Page<SurplusVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SurplusVO> list = flowService.computeStoreList(page, wrapper);
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", page);
    }

}
