/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.StoreExportVO;
import com.ejianc.business.store.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"store"})
public class StoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStoreService service;
    @Autowired
    private ISurplusService surplusService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO saveOrUpdateVO) {
        StoreEntity one;
        QueryWrapper queryWrapper;
        StoreEntity entity = (StoreEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StoreEntity.class));
        if (entity.getId() == null) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.eq((Object)"name", (Object)entity.getName());
            one = (StoreEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
            if (one != null) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u5f53\u524d\u4ed3\u5e93\u540d\u79f0\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
        }
        if (entity.getState() == 0 && entity.getDefaultFlag() == 1) {
            return CommonResponse.error((String)"\u8be5\u4ed3\u5e93\u662f\u9ed8\u8ba4\u4ed3\u5e93\uff01");
        }
        if (entity.getDefaultFlag() == 1) {
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.eq((Object)"default_flag", (Object)"1");
            one = (StoreEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
            if (one != null) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)one.getId());
                updateWrapper.set((Object)"default_flag", (Object)"0");
                this.service.update((Wrapper)updateWrapper);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        StoreVO vo = (StoreVO)BeanMapper.map((Object)((Object)entity), StoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryDetail(Long id) {
        StoreEntity entity = (StoreEntity)((Object)this.service.selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(surplus_tax_mny), 0) as surplusTaxMny"});
        queryWrapper.eq((Object)"store_id", (Object)id);
        List list = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity.setTotalMny(((SurplusEntity)((Object)list.get(0))).getSurplusTaxMny());
        }
        StoreVO vo = (StoreVO)BeanMapper.map((Object)((Object)entity), StoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StoreVO vo : vos) {
                CommonResponse<String> resp = this.service.checkStoreMaterialList(vo.getId());
                if (!resp.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
                }
                if (!vo.getAttrFlag().equals(StoreCommonConsts.THREE)) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25!" + vo.getName() + "\u662f\u4f4e\u503c\u6613\u8017\u54c1\u4ed3\u5e93 \u65e0\u6cd5\u5220\u9664"));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(item -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"IFNULL(sum(surplus_tax_mny), 0) as surplusTaxMny"});
            queryWrapper.eq((Object)"store_id", (Object)item.getId());
            List list = this.surplusService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                item.setTotalMny(((SurplusEntity)((Object)((Object)list.get(0)))).getSurplusTaxMny());
            }
        });
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        param.getParams().put("s.tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("s.orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<StoreEntity> list = this.service.queryStoreList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            StoreExportVO exportVO = (StoreExportVO)BeanMapper.map((Object)vo, StoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
            if (vo.getAttrFlag() == 1) {
                exportVO.setAttrFlagName("\u81ea\u8d2d\u6750");
            }
            if (vo.getAttrFlag() == 2) {
                exportVO.setAttrFlagName("\u7532\u4f9b\u6750");
            }
            if (vo.getAttrFlag() == 3) {
                exportVO.setAttrFlagName("\u4f4e\u503c\u6613\u8017\u54c1\u4ed3\u5e93");
            }
            if (StoreCommonConsts.YES.equals(vo.getState())) {
                exportVO.setStateName("\u542f\u7528");
            }
            if (StoreCommonConsts.NO.equals(vo.getState())) {
                exportVO.setStateName("\u505c\u7528");
            }
            if (StoreCommonConsts.YES.equals(vo.getDefaultFlag())) {
                exportVO.setDefaultFlagName("\u662f");
            }
            if (StoreCommonConsts.NO.equals(vo.getDefaultFlag())) {
                exportVO.setDefaultFlagName("\u5426");
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("storeListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryStoreByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryStoreByProjectId(Long projectId) {
        StoreVO vo = new StoreVO();
        if (projectId != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            queryWrapper.eq((Object)"default_flag", (Object)StoreCommonConsts.YES);
            StoreEntity entity = (StoreEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
            if (entity != null) {
                vo = (StoreVO)BeanMapper.map((Object)((Object)entity), StoreVO.class);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refStoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> refStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)StoreCommonConsts.YES));
        Long orgId = InvocationInfoProxy.getOrgId();
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (null != _con.get((Object)"projectId")) {
                projectId = Long.valueOf(_con.get((Object)"projectId").toString());
            }
            if (null != _con.get((Object)"orgId")) {
                orgId = Long.valueOf(String.valueOf(_con.get((Object)"orgId")));
            }
            if (null != _con.get((Object)"attrFlag")) {
                param.getParams().put("attrFlag", new Parameter("ne", (Object)String.valueOf(_con.get((Object)"attrFlag"))));
            }
        }
        if (null != projectId) {
            param.getParams().put("projectId", new Parameter("eq", projectId));
            this.service.autoByProjectId(projectId, 3);
            this.service.autoByProjectId(projectId, 1);
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

