package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.PickReturnDetailEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.PickReturnVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.PickReturnMapper;
import com.ejianc.business.store.bean.PickReturnEntity;
import com.ejianc.business.store.service.IPickReturnService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
@Service("pickReturnService")
public class PickReturnServiceImpl extends BaseServiceImpl<PickReturnMapper, PickReturnEntity> implements IPickReturnService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PickReturnMapper pickReturnMapper;

    @Autowired
    private StoreManageService storeManageService;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity entity = pickReturnMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }

    @Override
    public CommonResponse<PickReturnVO> pushCost(PickReturnVO pickReturnVO) {
        PickReturnEntity pickReturnEntity = baseMapper.selectById(pickReturnVO.getId());
        if(CollectionUtils.isNotEmpty(pickReturnVO.getPickReturnDetailList())){
            List<PickReturnDetailEntity> pickReturnDetailEntities = BeanMapper.mapList(pickReturnVO.getPickReturnDetailList(), PickReturnDetailEntity.class);
            pickReturnEntity.setPickReturnDetailList(pickReturnDetailEntities);
        }
        super.saveOrUpdate(pickReturnEntity, false);
        //推送数据
        this.costPush(pickReturnEntity);
        return CommonResponse.success(BeanMapper.map(pickReturnEntity,PickReturnVO.class));
    }

    @Override
    public void costPush(PickReturnEntity pickReturnEntity) {
        logger.info("开始costPush");
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        String newRelationFlag = "1";
        if(CollectionUtils.isNotEmpty(pickReturnDetailList)){
            for (PickReturnDetailEntity entity : pickReturnDetailList){
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(pickReturnDetailList)) {
            newRelationFlag = "0";
        }

        //更新是否关联
        LambdaUpdateWrapper<PickReturnEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PickReturnEntity::getId,pickReturnEntity.getId());
        updateWrapper.set(PickReturnEntity::getRelationFlag, newRelationFlag);
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = pickReturnEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(pickReturnEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-仓库盘点Id---{}",pickReturnEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(pickReturnEntity.getId());
                logger.info("结果"+ JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(pickReturnEntity);
            }
        }
    }

    private void saveCost(PickReturnEntity pickReturnEntity){
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        if(CollectionUtils.isNotEmpty(pickReturnDetailList)){
            //根据物资id查询物资编码
            List<Long> materialIds = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));

            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                //推送成本 过滤掉甲供材
                if(StoreAttrEnum.SELFPURCHASE.getCode().equals(String.valueOf(entity.getAttrFlag()))){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(entity.getSubjectId());
                    costDetailVO.setSubjectCode(entity.getSubjectCode());
                    costDetailVO.setSubjectName(entity.getSubjectName());
                    costDetailVO.setWbsId(entity.getWbsId());
                    costDetailVO.setWbsCode(entity.getWbsCode());
                    costDetailVO.setWbsName(entity.getWbsName());
                    costDetailVO.setSourceId(entity.getInstoreId());
                    costDetailVO.setSourceDetailId(entity.getId());
                    costDetailVO.setHappenTaxMny(ComputeUtil.convertToMinusNumber(entity.getTaxMny()));
                    costDetailVO.setHappenMny(ComputeUtil.convertToMinusNumber(entity.getMny()));
                    costDetailVO.setNum(ComputeUtil.convertToMinusNumber(entity.getReturnNum()));//退库数量
                    costDetailVO.setHappenDate(pickReturnEntity.getInstoreDate());
                    costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                    costDetailVO.setSourceType("STORE_PICKRETURN");
                    costDetailVO.setSourceTabType("STORE_PICKRETURN_SUB");
                    costDetailVO.setProjectId(pickReturnEntity.getProjectId());
                    costDetailVO.setSourceBillCode(pickReturnEntity.getBillCode()); //填充自己的单据编号
                    costDetailVO.setSourceBillName(SourceTypeEnum.材料退库.getTypeName());//填充枚举里  自己的单据名称
                    costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/pickReturn/card?id="+pickReturnEntity.getId());//需要跳转路径与参数组成的全路径
                    //2022-8-16新增传输字段
                    costDetailVO.setMaterialId(entity.getMaterialId());
                    costDetailVO.setMaterialName(entity.getMaterialName());
                    costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                    costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                    costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                    costDetailVO.setUnitId(entity.getMaterialUnitId());
                    costDetailVO.setUnit(entity.getMaterialUnitName());
                    costDetailVO.setSpec(entity.getMaterialSpec());
                    costDetailVOList.add(costDetailVO);
                }
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
                //推送前汇总子表自购材物资的含税无税金额到主表
                /*BigDecimal totalSelfTaxMny = pickReturnDetailList.stream().map(PickReturnDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalSelfMny = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                UpdateWrapper<PickReturnEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("total_self_tax_mny",totalSelfTaxMny);
                wrapper.set("total_self_mny",totalSelfMny);
                wrapper.eq("id",pickReturnEntity.getId());
                this.update(wrapper);*/
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }


    }


}
