/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.controller.FlowController;
import com.ejianc.business.store.mapper.CheckDetailMapper;
import com.ejianc.business.store.mapper.CheckMapper;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.CheckVO;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CheckDetailMapper checkDetailMapper;
    @Autowired
    private CheckMapper checkMapper;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private FlowController flowHandle;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse saveCheckStore(CheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"store_id", (Object)storeId);
        wrapper.eq((Object)"bill_state", (Object)StoreCommonConsts.ZERO);
        List list = super.list((Wrapper)wrapper);
        Integer checkCount = list.size();
        if (null == entity.getId() ? checkCount > 0 : checkCount > 1) {
            return CommonResponse.error((String)"\u8be5\u4ed3\u5e93\u5df2\u4e0b\u5b58\u5728\u81ea\u7531\u6001\u76d8\u70b9\u5355\uff01");
        }
        if (null != entity.getId()) {
            this.checkDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                subList.add(item);
            }
        });
        HashMap checkMap = new HashMap();
        String materialIds = "[";
        for (CheckDetailEntity item2 : subList) {
            materialIds = materialIds + item2.getMaterialId() + ",";
        }
        materialIds = materialIds.substring(0, materialIds.length() - 1) + "]";
        String condition = "{projectId:" + entity.getProjectId() + ",storeId:" + entity.getStoreId() + ",materialIds:" + materialIds + "}";
        if (subList.size() > 0) {
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = this.flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if (!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6700\u65b0\u6570\u91cf\u5931\u8d25\uff01");
            }
            List records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(item -> checkMap.put(item.getMaterialId(), item));
            for (CheckDetailEntity item3 : subList) {
                FlowVO flowVO = (FlowVO)checkMap.get(item3.getMaterialId());
                if (null == flowVO) {
                    return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
                }
                if (item3.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) >= 0) continue;
                return CommonResponse.error((String)("\u3010" + item3.getMaterialName() + "_" + item3.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355\uff1b  \u4e0d\u53ef\u4fdd\u5b58"));
            }
        }
        if (subList.size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            subList.forEach(item -> {
                if (item.getInventory() == null) {
                    item.setInventory(BigDecimal.ZERO);
                }
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93, (Integer)0);
                flowVO.setSourceBillTypeName("\u76d8\u70b9\u51fa\u5e93");
                flowVO.setSourceBillTypeCode("BT220125000000009");
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
                if (null != item.getPrice()) {
                    flowVO.setTaxPrice(item.getPrice());
                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
                }
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = this.storeManageService.surplusMaterialPrice(storeManageVO);
            if (!commonResponse.isSuccess()) {
                return commonResponse;
            }
            List useMaterialPriceVOList = new ArrayList();
            if (null != commonResponse.getData()) {
                useMaterialPriceVOList = ((StoreManageVO)commonResponse.getData()).getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k));
            if (null != entity.getId()) {
                this.checkDetailMapper.delByCheckId(entity.getId());
            }
            BigDecimal costMny = BigDecimal.ZERO;
            BigDecimal costTaxMny = BigDecimal.ZERO;
            entity.getCheckSubList().forEach(item -> {
                if (null != priceMap.get(item.getMaterialId())) {
                    item.setPrice(ComputeUtil.scaleTwo((BigDecimal)((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo((BigDecimal)((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxPrice()));
                    BigDecimal taxMny = ComputeUtil.scaleTwo((BigDecimal)BigDecimal.ZERO.subtract(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxMny()));
                    BigDecimal mny = ComputeUtil.scaleTwo((BigDecimal)BigDecimal.ZERO.subtract(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getMny()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(taxMny));
                    item.setCostMny(BigDecimal.ZERO.subtract(mny));
                }
            });
            for (CheckDetailEntity item4 : entity.getCheckSubList()) {
                if (item4.getCostMny() != null) {
                    costMny = costMny.add(item4.getCostMny());
                }
                if (item4.getCostTaxMny() == null) continue;
                costTaxMny = costTaxMny.add(item4.getCostTaxMny());
            }
            entity.setCostMny(costMny);
            entity.setCostTaxMny(costTaxMny);
            super.saveOrUpdate((Object)entity, false);
            checkSubList = entity.getCheckSubList();
            subList.clear();
            checkSubList.forEach(item -> {
                if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                    subList.add(item);
                }
            });
            flowVOS.forEach(item -> {
                item.setTaxPrice(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxPrice());
                item.setTaxMny(((UseMaterialPriceVO)priceMap.get(item.getMaterialId())).getTaxMny());
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success((Object)((Object)entity));
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.checkRollback(ids);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse checkRollback(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (CheckDetailEntity t : checkSubList) {
                if (t.getInventory().compareTo(BigDecimal.ZERO) >= 0) continue;
                checkFalg = true;
                break;
            }
            if (!checkFalg.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkOut(List<Long> ids) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)item));
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> rollbackCommonResponse = this.storeManageService.inOutStore(storeManageVO);
            if (rollbackCommonResponse.isSuccess()) continue;
            return rollbackCommonResponse;
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<CheckEntity> checkEntities = this.checkMapper.queryByDate(storeId, checkDate);
        if (checkEntities.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(checkVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)checkVO.getCheckSubList())) {
            List checkDetailEntities = BeanMapper.mapList((Iterable)checkVO.getCheckSubList(), CheckDetailEntity.class);
            checkEntity.setCheckSubList(checkDetailEntities);
        }
        super.saveOrUpdate((Object)checkEntity, false);
        this.costPush(checkEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<CheckDetailEntity> checkDetailEntities = checkEntity.getCheckSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailEntities)) {
            for (CheckDetailEntity entity : checkDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(checkDetailEntities)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = checkEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(checkEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u4ed3\u5e93\u76d8\u70b9Id---{}", (Object)checkEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(checkEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(checkEntity);
        }
    }

    private void saveCost(CheckEntity checkEntity) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<CheckDetailEntity> checkSubList = checkEntity.getCheckSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkSubList)) {
            List materialIds = checkSubList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.shareMaterialApi.queryMaterialByIds(materialIds);
            List voList = new ArrayList();
            if (listCommonResponse.isSuccess()) {
                voList = (List)listCommonResponse.getData();
            }
            HashMap materialMap = new HashMap();
            voList.forEach(item -> materialMap.put(item.getId(), item.getCode()));
            for (CheckDetailEntity entity : checkSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getCheckId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getCostTaxMny());
                costDetailVO.setHappenMny(entity.getCostMny());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_CHECK");
                costDetailVO.setSourceTabType("STORE_CHECK_SUB");
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u4ed3\u5e93\u76d8\u70b9.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/storeCheck/card?id=" + checkEntity.getId());
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode((String)materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

