package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.controller.FlowController;
import com.ejianc.business.store.mapper.CheckDetailMapper;
import com.ejianc.business.store.mapper.CheckMapper;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 仓库盘点表
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CheckDetailMapper checkDetailMapper;

    @Autowired
    private CheckMapper checkMapper;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private FlowController flowHandle;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse saveCheckStore(CheckEntity entity) {
        Long projectId = entity.getProjectId();
        Long storeId = entity.getStoreId();

        QueryWrapper<CheckEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("store_id",storeId);
        wrapper.eq("bill_state",StoreCommonConsts.ZERO);
        List<CheckEntity> list = super.list(wrapper);
        Integer checkCount = list.size();
        if(null == entity.getId()){
            if(checkCount > 0) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }else{
            if(checkCount > 1) {
                return CommonResponse.error("该仓库已下存在自由态盘点单！");
            }
        }
        //更新子表信息
        if(null != entity.getId()) {
            checkDetailMapper.delByCheckId(entity.getId());
        }
        super.saveOrUpdate(entity, false);
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        List<CheckDetailEntity> subList = new ArrayList<>();
        checkSubList.forEach(item->{
            if(item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0){
                subList.add(item);
            }
        });

        // 校验提交时数量是否足够
        Map<Long,FlowVO> checkMap = new HashMap<>();
        String materialIds = "[";
        for (CheckDetailEntity item:subList
             ) {
            materialIds = materialIds + item.getMaterialId()+",";
        }
        materialIds = materialIds.substring(0,materialIds.length()-1)+"]";
        String condition = "{projectId:"+entity.getProjectId()+",storeId:"+entity.getStoreId()+",materialIds:"+materialIds+"}";
        // 本次盘点包含出库单时进行校验。
        if(subList.size() > 0){
            CommonResponse<IPage<FlowVO>> iPageCommonResponse = flowHandle.refInstoreFlowData(1, 1000, condition, "", "");
            if(!iPageCommonResponse.isSuccess() || null == iPageCommonResponse.getData()){
                return CommonResponse.error("获取最新数量失败！");
            }
            List<FlowVO> records = iPageCommonResponse.getData().getRecords();
            records.forEach(item->{
                checkMap.put(item.getMaterialId(),item);
            });
            for (CheckDetailEntity item:subList
                 ) {
                FlowVO flowVO = checkMap.get(item.getMaterialId());
                // 库存可用为0时
                if(null == flowVO){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
                // 校验库存是否足够出库单使用
                if(item.getInventory().add(flowVO.getSurplusNum()).compareTo(BigDecimal.ZERO) < 0){
                    return CommonResponse.error("【"+item.getMaterialName()+"_"+item.getSpec()+"】库存可用数量不足，无法形成盘亏出库单；  不可保存");
                }
            }
        }

        if(subList.size() > 0){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            subList.forEach(item->{
                if(item.getInventory() == null) item.setInventory(BigDecimal.ZERO);
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.盘亏出库,0);
                flowVO.setSourceBillTypeName("盘点出库");
                flowVO.setSourceBillTypeCode("BT220125000000009");
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialSpec(item.getSpec());
                flowVO.setNum(BigDecimal.ZERO.subtract(item.getInventory()));
                if(null != item.getPrice()){
                    flowVO.setTaxPrice(item.getPrice());
                    flowVO.setTaxMny(item.getPrice().multiply(flowVO.getNum()));
                }
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(item.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getCheckDate());
                flowVOS.add(flowVO);
            });
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> commonResponse = storeManageService.surplusMaterialPrice(storeManageVO);
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
            List<UseMaterialPriceVO> useMaterialPriceVOList = new ArrayList<>();
            if(null != commonResponse.getData()){
                useMaterialPriceVOList = commonResponse.getData().getUseMaterialPriceVOList();
            }
            Map<Long, UseMaterialPriceVO> priceMap = useMaterialPriceVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), (k) -> k));

            // 获取价格后再更新子表信息
            if(null != entity.getId()) {
                checkDetailMapper.delByCheckId(entity.getId());
            }
            BigDecimal costMny = BigDecimal.ZERO;
            BigDecimal costTaxMny = BigDecimal.ZERO;
            entity.getCheckSubList().forEach(item->{
                if(null != priceMap.get(item.getMaterialId())){
                    item.setPrice(ComputeUtil.scaleTwo(priceMap.get(item.getMaterialId()).getPrice()));
                    item.setTaxPrice(ComputeUtil.scaleTwo(priceMap.get(item.getMaterialId()).getTaxPrice()));
                    BigDecimal taxMny = ComputeUtil.scaleTwo(BigDecimal.ZERO.subtract(priceMap.get(item.getMaterialId()).getTaxMny()));
                    BigDecimal mny = ComputeUtil.scaleTwo(BigDecimal.ZERO.subtract(priceMap.get(item.getMaterialId()).getMny()));
                    item.setCostTaxMny(BigDecimal.ZERO.subtract(taxMny));
                    item.setCostMny(BigDecimal.ZERO.subtract(mny));
                }
            });

            for (CheckDetailEntity item:entity.getCheckSubList()
                 ) {
                if(item.getCostMny() != null){
                    costMny = costMny.add(item.getCostMny());
                }
                if(item.getCostTaxMny() != null){
                    costTaxMny = costTaxMny.add(item.getCostTaxMny());
                }
            }
            entity.setCostMny(costMny);
            entity.setCostTaxMny(costTaxMny);
            super.saveOrUpdate(entity, false);
            checkSubList = entity.getCheckSubList();
            subList.clear();
            checkSubList.forEach(item->{
                if(item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0){
                    subList.add(item);
                }
            });

            flowVOS.forEach(item->{
                item.setTaxPrice(priceMap.get(item.getMaterialId()).getTaxPrice());
                item.setTaxMny(priceMap.get(item.getMaterialId()).getTaxMny());
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!storeManageVOCommonResponse.isSuccess()){
                return storeManageVOCommonResponse;
            }
        }
        return CommonResponse.success(entity);
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = checkRollback(ids);
        if(!commonResponse.isSuccess()){
            return commonResponse;
        }
        super.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    @Override
    public CommonResponse checkRollback(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
             ) {
            CheckEntity entity = super.selectById(item);
            List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
            Boolean checkFalg = false;
            for (CheckDetailEntity t:checkSubList) {
                if(t.getInventory().compareTo(BigDecimal.ZERO) < 0){
                    checkFalg = true;
                    break;
                }
            }
            // 包含出库单，才需要此操作。
            if(checkFalg){
                SourceIds.clear();
                SourceIds.add(item);
                storeManageVO.setSourceId(item);
                storeManageVO.setStoreId(entity.getStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
                storeManageVO.setSourceIdsForRollBack(SourceIds);
                CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
                if(!rollbackCommonResponse.isSuccess()){
                    return rollbackCommonResponse;
                }
            }
        }
        return CommonResponse.success();
    };
    @Override
    public CommonResponse checkOut(List<Long> ids){
        StoreManageVO storeManageVO = new StoreManageVO();
        List<Long> SourceIds = new ArrayList<>();
        for (Long item:ids
        ) {
            CheckEntity entity = super.selectById(item);
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.盘亏出库);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setSourceId(item);
            storeManageVO.setOutEffectiveON(true);
            CommonResponse<StoreManageVO> rollbackCommonResponse = storeManageService.inOutStore(storeManageVO);
            if(!rollbackCommonResponse.isSuccess()){
                return rollbackCommonResponse;
            }
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse checkByDate(Long storeId, String checkDate) {
        List<CheckEntity> checkEntities = checkMapper.queryByDate(storeId, checkDate);
        if(checkEntities.size()>0){
            return CommonResponse.error("该时间点后已发生仓库盘点单");
        }
        return CommonResponse.success();
    }


    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = baseMapper.selectById(checkVO.getId());
        if (CollectionUtils.isNotEmpty(checkVO.getCheckSubList())) {
            List<CheckDetailEntity> checkDetailEntities = BeanMapper.mapList(checkVO.getCheckSubList(), CheckDetailEntity.class);
            checkEntity.setCheckSubList(checkDetailEntities);
        }
        super.saveOrUpdate(checkEntity, false);
        //推送数据
        this.costPush(checkEntity);
        return CommonResponse.success(BeanMapper.map(checkEntity, CheckVO.class));
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        logger.info("开始costPush");
        List<CheckDetailEntity> checkDetailEntities = checkEntity.getCheckSubList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailEntities)) {
            for (CheckDetailEntity entity : checkDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(checkDetailEntities)) {
            newRelationFlag = "0";
        }

        //更新是否关联
        LambdaUpdateWrapper<CheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(CheckEntity::getId, checkEntity.getId());
        updateWrapper.set(CheckEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = checkEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(checkEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-仓库盘点Id---{}",checkEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(checkEntity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(checkEntity);
            }
        }
    }

    private void saveCost(CheckEntity checkEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<CheckDetailEntity> checkSubList = checkEntity.getCheckSubList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkSubList)) {
            //根据物资id查询物资编码
            List<Long> materialIds = checkSubList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));
            for (CheckDetailEntity entity : checkSubList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getCheckId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getCostTaxMny());
                costDetailVO.setHappenMny(entity.getCostMny());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("STORE_CHECK");
                costDetailVO.setSourceTabType("STORE_CHECK_SUB");
                //新加的
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.仓库盘点.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/storeCheck/card?id="+checkEntity.getId());
                costDetailVO.setProjectId(checkEntity.getProjectId());
                //2022-8-16新增传输字段
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getUnit());
                costDetailVO.setUnit(entity.getUnitName());
                costDetailVO.setSpec(entity.getSpec());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

}
