package com.ejianc.business.store.service;

import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.StoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.store.bean.StoreEntity;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 仓库表
 * 
 * @author generator
 * 
 */
public interface IStoreService extends IBaseService<StoreEntity> {
    /**
     *  根据项目id 查询是否存在 低值易耗品仓库 不存在插入一条
     *
     * @param projectId
     */
    StoreEntity autoByProjectId(Long projectId,Integer attrFlag);

    List<StoreEntity> queryStoreList(QueryParam param);
    StoreManageVO  setStoreAttr(StoreManageVO storeManageVO);

    /**
     * 校验仓库能否删除
     * @param id
     * @return
     */
    CommonResponse<String> checkStoreMaterialList(Long id);
}
