/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.bean.InOutEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.IInOutService;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.service.handler.IStoreManageHandler;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.SurplusUpdateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StraightInOutStoreHandler
implements IStoreManageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IFlowService flowService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        storeManageVO = this.storeService.setStoreAttr(storeManageVO);
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        if (sourceId != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            int count = this.flowService.count((Wrapper)queryWrapper);
            if (count > 0) {
                InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
                String billTypeName = inOutTypeEnum != null ? inOutTypeEnum.getInOutTypeName() : "\u65e0";
                this.logger.error("---start---------\u91cd\u590d\u6821\u9a8cERROR---------------------------------");
                this.logger.error("\u4ed3\u5e93\u5165\u5e93\u6d41\u6c34\u91cd\u590d\u6821\u9a8c\uff1a\u5df2\u5b58\u5728\u8be5\u5355\u636e\u5165\u5e93\u6d41\u6c34\uff01\u6765\u6e90\u5355\u636e\u7c7b\u578b\uff1a{}\uff0c\u5355\u636eID\uff1a{}", (Object)billTypeName, (Object)sourceId);
                this.logger.error("---end-----------\u91cd\u590d\u6821\u9a8cERROR---------------------------------");
                return CommonResponse.success((String)("\u4ed3\u5e93\u5165\u5e93\u6d41\u6c34\u91cd\u590d\u6821\u9a8c\uff1a\u5df2\u5b58\u5728\u8be5\u5355\u636e\u5165\u5e93\u6d41\u6c34\uff01\u6765\u6e90\u5355\u636eID\uff1a" + sourceId), (Object)storeManageVO);
            }
        }
        List inFlowVOList = storeManageVO.getFlowVOList();
        inFlowVOList.forEach(flowVO -> {
            flowVO.setId(Long.valueOf(IdWorker.getId()));
            flowVO.setOutNum(flowVO.getNum());
            flowVO.setOutLockNum(BigDecimal.ZERO);
            flowVO.setSurplusNum(BigDecimal.ZERO);
            flowVO.setSurplusMny(BigDecimal.ZERO);
            flowVO.setSurplusTaxMny(BigDecimal.ZERO);
            flowVO.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
            flowVO.setEffectiveDate(new Date());
            flowVO.setEffectiveState(StoreCommonConsts.YES);
            flowVO.setEstimatePrice(flowVO.getPrice());
            flowVO.setEstimateTaxPrice(flowVO.getTaxPrice());
        });
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)inFlowVOList, (boolean)false);
        List outFlowVOList = storeManageVO.getStraightOutFlowVOList();
        outFlowVOList.forEach(t -> {
            t.setId(Long.valueOf(IdWorker.getId()));
            t.setEffectiveState(StoreCommonConsts.YES);
        });
        List inOutVOList = StoreManageUtil.getInOutVOsByInAndOutFlowVOList((List)inFlowVOList, (List)outFlowVOList);
        List inOutEntities = BeanMapper.mapList((Iterable)inOutVOList, InOutEntity.class);
        this.inOutService.saveOrUpdateBatch(inOutEntities);
        inFlowVOList.addAll(outFlowVOList);
        List flowEntities = BeanMapper.mapList((Iterable)inFlowVOList, FlowEntity.class);
        boolean b = this.flowService.saveOrUpdateBatch(flowEntities);
        if (b) {
            SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, false);
            storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
        }
        return CommonResponse.success((Object)storeManageVO);
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        CommonResponse<List<FlowEntity>> res = this.flowService.validateIsUse(sourceId, storeId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)instoreList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5165\u5e93\u5355\u6d41\u6c34\u4fe1\u606f\uff01");
        }
        List flowVOList = BeanMapper.mapList((Iterable)instoreList, FlowVO.class);
        List instoreFlowVOList = flowVOList.stream().filter(s -> s.getInOutFlag() == InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93.getInOutFlag()).collect(Collectors.toList());
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, instoreFlowVOList, (boolean)true);
        List delListIds = flowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.flowService.removeByIds(delListIds);
        QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
        inOutEntityQueryWrapper.eq((Object)"in_bill_id", (Object)sourceId);
        boolean b = this.inOutService.remove((Wrapper)inOutEntityQueryWrapper);
        if (b) {
            SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, false);
            storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
        }
        return CommonResponse.success((Object)storeManageVO);
    }
}

