/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.handler;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.bean.InOutEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.IInOutService;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.service.handler.IStoreManageHandler;
import com.ejianc.business.store.util.StoreLockUtil;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.SurplusUpdateVO;
import com.ejianc.business.store.vo.SurplusVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackStoreHandler
implements IStoreManageHandler {
    @Autowired
    IFlowService flowService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IInOutService inOutService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        storeManageVO = this.storeService.setStoreAttr(storeManageVO);
        Long storeId = storeManageVO.getStoreId();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            List inOutIds = flowVOList.stream().map(FlowVO::getInOutId).collect(Collectors.toList());
            QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
            inOutEntityQueryWrapper.in((Object)"id", inOutIds);
            List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
            Map inOutMap = inOutEntities.stream().collect(Collectors.groupingBy(i -> i.getId(), Collectors.toList()));
            List inFlowIds = inOutEntities.stream().map(InOutEntity::getInFlowId).collect(Collectors.toList());
            QueryWrapper inFlowQueryWrapper = new QueryWrapper();
            inFlowQueryWrapper.in((Object)"id", inFlowIds);
            List inFlowList = this.flowService.list((Wrapper)inFlowQueryWrapper);
            Map<Long, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            ArrayList updateInOutVOList = new ArrayList();
            ArrayList updateFlowVOList = new ArrayList();
            flowVOList.forEach(t -> {
                Long inOutId = t.getInOutId();
                List inOutEntities1 = (List)inOutMap.get(inOutId);
                InOutEntity inOutEntity = (InOutEntity)((Object)((Object)inOutEntities1.get(0)));
                List flowEntities = (List)inFlowMap.get(inOutEntity.getInFlowId());
                FlowEntity flowEntity = (FlowEntity)((Object)((Object)flowEntities.get(0)));
                BigDecimal returnStoreNum = t.getNum();
                inOutEntity.setReturnStoreNum(ComputeUtil.safeAdd((BigDecimal)inOutEntity.getReturnStoreNum(), (BigDecimal)returnStoreNum));
                updateInOutVOList.add(inOutEntity);
                flowEntity.setReturnStoreFlag(StoreCommonConsts.YES);
                flowEntity.setOutNum(ComputeUtil.safeSub((BigDecimal)flowEntity.getOutNum(), (BigDecimal)returnStoreNum));
                flowEntity.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)returnStoreNum));
                flowEntity.setSurplusMny(ComputeUtil.safeMultiply((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)flowEntity.getPrice()));
                flowEntity.setSurplusTaxMny(ComputeUtil.safeMultiply((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)flowEntity.getTaxPrice()));
                flowEntity.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                updateFlowVOList.add(flowEntity);
            });
            flowVOList.forEach(t -> {
                t.setNum(ComputeUtil.convertToMinusNumber((BigDecimal)t.getNum()));
                t.setMny(ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getPrice()));
                t.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)t.getNum(), (BigDecimal)t.getTaxPrice()));
            });
            updateFlowVOList.addAll(BeanMapper.mapList((Iterable)flowVOList, FlowEntity.class));
            boolean b = this.flowService.saveOrUpdateBatch(updateFlowVOList);
            if (b) {
                this.inOutService.saveOrUpdateBatch(updateInOutVOList);
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, false, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.success((Object)storeManageVO);
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long sourceId = storeManageVO.getSourceId();
        Long storeId = storeManageVO.getStoreId();
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            QueryWrapper backFlowQueryWrapper = new QueryWrapper();
            backFlowQueryWrapper.eq((Object)"source_id", (Object)sourceId);
            backFlowQueryWrapper.in((Object)"store_id", new Object[]{storeId});
            List backFlowList = this.flowService.list((Wrapper)backFlowQueryWrapper);
            List backFlowVOList = BeanMapper.mapList((Iterable)backFlowList, FlowVO.class);
            SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)backFlowVOList, (boolean)true);
            List inOutIds = backFlowVOList.stream().map(FlowVO::getInOutId).collect(Collectors.toList());
            QueryWrapper inOutEntityQueryWrapper = new QueryWrapper();
            inOutEntityQueryWrapper.in((Object)"id", inOutIds);
            List inOutEntities = this.inOutService.list((Wrapper)inOutEntityQueryWrapper);
            Map inOutMap = inOutEntities.stream().collect(Collectors.groupingBy(i -> i.getId(), Collectors.toList()));
            List inFlowIds = inOutEntities.stream().map(InOutEntity::getInFlowId).collect(Collectors.toList());
            QueryWrapper inFlowQueryWrapper = new QueryWrapper();
            inFlowQueryWrapper.in((Object)"id", inFlowIds);
            List inFlowList = this.flowService.list((Wrapper)inFlowQueryWrapper);
            Map<Long, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(BaseEntity::getId));
            ArrayList<InOutEntity> updateInOutVOList = new ArrayList<InOutEntity>();
            ArrayList<FlowEntity> updateFlowVOList = new ArrayList<FlowEntity>();
            HashMap<Long, SurplusVO> surplusMap = new HashMap<Long, SurplusVO>();
            for (FlowEntity t : backFlowList) {
                BigDecimal returnStoreNumZS;
                Long inOutId = t.getInOutId();
                List inOutEntities1 = inOutMap.get(inOutId);
                InOutEntity inOutEntity = (InOutEntity)((Object)inOutEntities1.get(0));
                List<FlowEntity> flowEntities = inFlowMap.get(inOutEntity.getInFlowId());
                FlowEntity flowEntity = flowEntities.get(0);
                BigDecimal surplusNum = flowEntity.getSurplusNum();
                if (ComputeUtil.isLessThan((BigDecimal)surplusNum, (BigDecimal)(returnStoreNumZS = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)t.getNum())))) {
                    CommonResponse commonResponse = CommonResponse.error((String)("\u7269\u8d44[\u540d\u79f0:" + t.getMaterialName() + ",\u89c4\u683c:" + StrUtil.emptyToDefault((CharSequence)t.getMaterialSpec(), (String)"\u65e0") + "]\u5e93\u5b58\u4e0d\u8db3,\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c!"));
                    return commonResponse;
                }
                inOutEntity.setReturnStoreNum(ComputeUtil.safeSub((BigDecimal)inOutEntity.getReturnStoreNum(), (BigDecimal)returnStoreNumZS));
                updateInOutVOList.add(inOutEntity);
                flowEntity.setReturnStoreFlag(ComputeUtil.isEmpty((BigDecimal)inOutEntity.getReturnStoreNum()) != false ? StoreCommonConsts.NO : StoreCommonConsts.YES);
                flowEntity.setOutNum(ComputeUtil.safeAdd((BigDecimal)flowEntity.getOutNum(), (BigDecimal)returnStoreNumZS));
                flowEntity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)returnStoreNumZS));
                flowEntity.setSurplusMny(ComputeUtil.safeMultiply((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)flowEntity.getPrice()));
                flowEntity.setSurplusTaxMny(ComputeUtil.safeMultiply((BigDecimal)flowEntity.getSurplusNum(), (BigDecimal)flowEntity.getTaxPrice()));
                flowEntity.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                updateFlowVOList.add(flowEntity);
                Long materialId = t.getMaterialId();
                SurplusVO vo = (SurplusVO)surplusMap.get(materialId);
                BigDecimal munusNum = ComputeUtil.convertToMinusNumber((BigDecimal)returnStoreNumZS);
                BigDecimal munusMny = ComputeUtil.safeMultiply((BigDecimal)munusNum, (BigDecimal)flowEntity.getPrice());
                BigDecimal munusTaxMny = ComputeUtil.safeMultiply((BigDecimal)munusNum, (BigDecimal)flowEntity.getTaxPrice());
                if (vo == null) {
                    vo = new SurplusVO();
                    vo.setStoreId(storeId);
                    vo.setMaterialId(materialId);
                    vo.setSurplusNum(munusNum);
                    vo.setSurplusMny(munusMny);
                    vo.setSurplusTaxMny(munusTaxMny);
                } else {
                    vo.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)vo.getSurplusNum(), (BigDecimal)munusNum));
                    vo.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)vo.getSurplusMny(), (BigDecimal)munusMny));
                    vo.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)vo.getSurplusTaxMny(), (BigDecimal)munusTaxMny));
                }
                surplusMap.put(materialId, vo);
            }
            boolean b = this.flowService.saveOrUpdateBatch(updateFlowVOList);
            if (b) {
                List backFlowIds = backFlowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                this.flowService.removeByIds(backFlowIds);
                this.inOutService.saveOrUpdateBatch(updateInOutVOList);
                surplusUpdateVO.setMaterialIds(new ArrayList(surplusMap.keySet()));
                surplusUpdateVO.setSurplusVOList(new ArrayList(surplusMap.values()));
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, false, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.success((Object)storeManageVO);
    }
}

