package com.ejianc.business.store.service;

import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.SurplusUpdateVO;
import com.ejianc.business.store.vo.UseCalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 仓库库存表
 *
 * @author generator
 */
public interface ISurplusService extends IBaseService<SurplusEntity> {

    /**
     * @param surplusUpdateVO
     * @param updateInstoreFlag 更新入库量标志
     * @param updateSurplusFlag 更新余量标志
     * @description: 更新库存
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/1/25
     */
    SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag);

    /**
     * @param surplusUpdateVO
     * @param updateInstoreFlag     更新入库量标志
     * @param updateSurplusFlag     更新余量标志
     * @param updateReturnGoodsFlag 更新退货标志
     * @description: 更新库存
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/1/25
     */
    SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag, boolean updateReturnGoodsFlag);

    /**
     * @param surplusUpdateVO
     * @description: 校验库存量是否够用-- 出库
     * @return: com.ejianc.framework.core.response.CommonResponse<cn.hutool.json.JSONObject>
     * @author songlx
     * @date: 2022/1/25
     */
    CommonResponse<SurplusUpdateVO> validateSurplus(SurplusUpdateVO surplusUpdateVO);

    /**
     * @param storeManageVO
     * @description: 先进先出算法计算
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/1/26
     */
    UseCalculateVO useCalculate(StoreManageVO storeManageVO);

    /**
     * @param storeManageVO
     * @param outEffectiveON
     * @description: 根据出入库关系回滚
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/2/14
     */
    UseCalculateVO outRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON);

    /**
     * @param storeManageVO
     * @description: 周转材先进先出算法
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/3/2
     */
    UseCalculateVO useTurnCalculate(StoreManageVO storeManageVO);

    /**
     * @param storeManageVO
     * @param outEffectiveON
     * @description: 周转材先进先出回滚算法
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/3/3
     */
    UseCalculateVO turnOutRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON);

    /**
     * @param storeManageVO
     * @description: 出库校验仓库余量，主要用于有锁定数量的校验
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.SurplusUpdateVO>
     * @author songlx
     * @date: 2022/3/10
     */
    CommonResponse<SurplusUpdateVO> validateStoreSurplusByOutLock(StoreManageVO storeManageVO);
}
