/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.StoreMapper;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeService")
public class StoreServiceImpl
extends BaseServiceImpl<StoreMapper, StoreEntity>
implements IStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISurplusService surplusService;
    @Autowired
    private IProjectApi projectApi;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = StoreServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"s.dr", (Object)StoreCommonConsts.NO);
        wrapper.groupBy(new Object[]{"s.id"});
        return this.storeMapper.queryStoreList(wrapper);
    }

    @Override
    public StoreManageVO setStoreAttr(StoreManageVO storeManageVO) {
        Object projectId;
        String storeTypeName;
        String storeType;
        Long storeId = storeManageVO.getStoreId();
        StoreEntity storeEntity = (StoreEntity)((Object)this.storeMapper.selectById(storeId));
        if (StoreAttrEnum.SELFPURCHASE.getCode().equals(storeEntity.getAttrFlag().toString())) {
            storeType = StoreAttrEnum.SELFPURCHASE.getCode();
            storeTypeName = StoreAttrEnum.SELFPURCHASE.getDescription();
        } else {
            storeType = StoreAttrEnum.ASUPPLY.getCode();
            storeTypeName = StoreAttrEnum.ASUPPLY.getDescription();
        }
        StoreEntity consumableStore = new StoreEntity();
        List flowVOList = storeManageVO.getFlowVOList();
        this.logger.info("flowVOList:" + JSONObject.toJSONString((Object)flowVOList));
        List<Object> consumableList = new ArrayList();
        if (!flowVOList.isEmpty()) {
            consumableList = flowVOList.stream().filter(e -> null != e.getConsumableFlag() && "1".equals(e.getConsumableFlag())).collect(Collectors.toList());
        }
        if (!consumableList.isEmpty() && null != (projectId = ((FlowVO)consumableList.get(0)).getProjectId())) {
            consumableStore = this.autoByProjectId((Long)projectId, 3);
        }
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
                if (null == flowVO.getConsumableFlag() || !"1".equals(flowVO.getConsumableFlag()) || null == consumableStore) continue;
                flowVO.setStoreId(consumableStore.getId());
                flowVO.setStoreType(StoreAttrEnum.CONSUMABLE.getCode());
                flowVO.setStoreType(StoreAttrEnum.CONSUMABLE.getDescription());
            }
        }
        storeManageVO.setFlowVOList(flowVOList);
        List straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)straightOutFlowVOList)) {
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
                if (null == straightOut.getConsumableFlag() || !"1".equals(straightOut.getConsumableFlag()) || null == consumableStore) continue;
                straightOut.setStoreId(consumableStore.getId());
                straightOut.setStoreType(StoreAttrEnum.CONSUMABLE.getCode());
                straightOut.setStoreType(StoreAttrEnum.CONSUMABLE.getDescription());
            }
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)id);
        queryWrapper.gt((Object)"surplus_num", (Object)0);
        List list = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed3\u5e93\u6709\u7269\u8d44");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @Override
    public StoreEntity autoByProjectId(Long projectId, Integer attrFlag) {
        int count;
        StoreEntity storeEntity = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"attr_flag", (Object)attrFlag);
        queryWrapper.eq((Object)"dr", (Object)StoreCommonConsts.NO);
        if (StoreCommonConsts.ONE.equals(attrFlag)) {
            queryWrapper.eq((Object)"state", (Object)StoreCommonConsts.YES);
        }
        if ((count = this.count((Wrapper)queryWrapper)) == 0) {
            CommonResponse projectResponse = this.projectApi.queryProjectDetail(projectId);
            if (!projectResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25, {}", (Object)projectResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            storeEntity = new StoreEntity();
            ProjectSetVO project = (ProjectSetVO)projectResponse.getData();
            storeEntity.setId(IdWorker.getId());
            storeEntity.setProjectId(project.getId());
            storeEntity.setProjectName(project.getName());
            storeEntity.setProjectCode(project.getCode());
            storeEntity.setOrgId(project.getProjectDepartmentId());
            CommonResponse orgResponse = this.iOrgApi.getOneById(project.getProjectDepartmentId());
            if (!orgResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            storeEntity.setOrgName(orgVO.getName());
            storeEntity.setOrgCode(orgVO.getCode());
            storeEntity.setParentOrgId(orgVO.getParentId());
            storeEntity.setParentOrgName(orgVO.getpFName());
            storeEntity.setParentOrgCode(orgVO.getpCode());
            storeEntity.setProjectType(StoreCommonConsts.YES);
            storeEntity.setState(StoreCommonConsts.YES);
            storeEntity.setName(project.getName() + "\u6613\u8017\u54c1");
            storeEntity.setAttrFlag(attrFlag);
            if (StoreCommonConsts.ONE.equals(attrFlag)) {
                storeEntity.setDefaultFlag(StoreCommonConsts.YES);
            } else {
                storeEntity.setDefaultFlag(StoreCommonConsts.NO);
            }
            storeEntity.setTotalMny(BigDecimal.ZERO);
            storeEntity.setMemo("\u81ea\u589e");
            this.saveOrUpdate((Object)storeEntity);
        } else {
            List storeEntities = this.list((Wrapper)queryWrapper);
            if (!storeEntities.isEmpty()) {
                storeEntity = (StoreEntity)((Object)storeEntities.get(0));
            }
        }
        return storeEntity;
    }
}

