package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 仓库材料处置表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_handle")
public class HandleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="handle_date")
    private Date handleDate; // 处置日期
    @TableField(value="handle_out_store_id")
    private Long handleOutStoreId; // 处置单对应出库单据Id
    @TableField(value="handle_type")
    private Integer handleType; // 处置类型 1消耗材 2周转材
    @TableField(value="material_types")
    private String materialTypes; // 物料分类
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="handle_reason")
    private String handleReason; // 处置原因
    @TableField(value="handle_mny")
    private BigDecimal handleMny; // 处置金额
    @TableField(value="in_store_mny")
    private BigDecimal inStoreMny; // 入库金额
    @TableField(value="handle_sub_mny")
    private BigDecimal handleSubMny; // 处置差额
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称

    @TableField(value="handle_tax_mny")
    private BigDecimal handleTaxMny; // 处置金额(含税)
    @TableField(value="in_store_tax_mny")
    private BigDecimal inStoreTaxMny; // 入库金额(含税)
    @TableField(value="handle_sub_tax_mny")
    private BigDecimal handleSubTaxMny; // 处置差额(含税)

    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态

    @TableField(value="org_code")
    private String orgCode; // 项目组织编码


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }

    public BigDecimal getInStoreTaxMny() {
        return inStoreTaxMny;
    }

    public void setInStoreTaxMny(BigDecimal inStoreTaxMny) {
        this.inStoreTaxMny = inStoreTaxMny;
    }

    public BigDecimal getHandleSubTaxMny() {
        return handleSubTaxMny;
    }

    public void setHandleSubTaxMny(BigDecimal handleSubTaxMny) {
        this.handleSubTaxMny = handleSubTaxMny;
    }

    @TableField(exist = false)
    @SubEntity(serviceName = "handleDetailService", pidName = "handleId")
    private List<HandleDetailEntity> handleSubList;

    public List<HandleDetailEntity> getHandleSubList() {
        return handleSubList;
    }

    public void setHandleSubList(List<HandleDetailEntity> handleSubList) {
        this.handleSubList = handleSubList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public Long getHandleOutStoreId() {
        return handleOutStoreId;
    }

    public void setHandleOutStoreId(Long handleOutStoreId) {
        this.handleOutStoreId = handleOutStoreId;
    }
    public Integer getHandleType() {
        return handleType;
    }

    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }
    public String getMaterialTypes() {
        return materialTypes;
    }

    public void setMaterialTypes(String materialTypes) {
        this.materialTypes = materialTypes;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getHandleReason() {
        return handleReason;
    }

    public void setHandleReason(String handleReason) {
        this.handleReason = handleReason;
    }
    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    public BigDecimal getInStoreMny() {
        return inStoreMny;
    }

    public void setInStoreMny(BigDecimal inStoreMny) {
        this.inStoreMny = inStoreMny;
    }
    public BigDecimal getHandleSubMny() {
        return handleSubMny;
    }

    public void setHandleSubMny(BigDecimal handleSubMny) {
        this.handleSubMny = handleSubMny;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    
}
