package com.ejianc.business.store.controller.api;

import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.bean.InOutEntity;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.IInOutService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.InOutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/storeFlow/")
@Api(value = "仓库流水公共API接口", tags = {"仓库流水公共API接口"})
public class StoreFlowApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IFlowService flowService;
    @Autowired
    private IInOutService inOutService;

    /**
     * @param queryParam 参数
     * @description: 查询流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/1/18
     */
    @ApiOperation("查询流水")
    @RequestMapping(value = "/getFlowList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowList(@RequestBody QueryParam queryParam) {
        List<FlowEntity> flowEntityList = flowService.queryList(queryParam);
        List<FlowVO> flowVOS = BeanMapper.mapList(flowEntityList, FlowVO.class);
        return CommonResponse.success(flowVOS);
    }

    /**
     * @param queryParam
     * @description: 查询出入库关系
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.InOutVO>
     * @author 姜轶凯
     * @date: 2022/3/15
     */
    @RequestMapping(value = "/getInOutVOList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<InOutVO>> getInOutVOList(@RequestBody QueryParam queryParam){
        List<InOutEntity> inOutEntities = inOutService.queryList(queryParam);
        List<InOutVO> inOutVOS = BeanMapper.mapList(inOutEntities, InOutVO.class);
        return CommonResponse.success(inOutVOS);
    }


}
