/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.store.bean.HandleDetailEntity;
import com.ejianc.business.store.bean.HandleEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IHandleService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IHandleService handleService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(billId);
        this.handleService.handleInOut(longs, true);
        this.logger.info("\u63a8\u9001\u6210\u672c---");
        HandleEntity entity = (HandleEntity)((Object)this.handleService.selectById(billId));
        this.handleService.costPush(entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.handleService.selectById(billId));
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, handleEntity.getId());
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        if (handleEntity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(handleEntity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)handleEntity.getHandleDate()));
            return commonResponse;
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        HandleEntity entity = (HandleEntity)((Object)this.handleService.selectById(billId));
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        Boolean checkFlag = false;
        for (HandleDetailEntity item : handleSubList) {
            if (item.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag.booleanValue()) {
            SourceIds.add(billId);
            storeManageVO.setSourceId(billId);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = this.storeManageService.inOutStoreRollback(storeManageVO);
            if (!storeManageVOCommonResponse.isSuccess()) {
                return CommonResponse.error((String)storeManageVOCommonResponse.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.handleService.selectById(billId));
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u5904\u7f6eId---{}", (Object)handleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.updateCostDetail(handleEntity.getId(), Integer.valueOf(0));
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{handleEntity.getId()});
        updateWrapper.set(HandleEntity::getRelationFlag, (Object)0);
        this.handleService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

