package com.ejianc.business.store.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.bean.InOutEntity;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.SurplusMapper;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.service.IInOutService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 仓库库存表
 *
 * @author generator
 */
@Service("surplusService")
public class SurplusServiceImpl extends BaseServiceImpl<SurplusMapper, SurplusEntity> implements ISurplusService {

    @Autowired
    IFlowService flowService;

    @Autowired
    IInOutService inOutService;

    @Autowired
    ISurplusService surplusService;

    /**
     * @param surplusUpdateVO
     * @param updateInstoreFlag 更新入库量标志
     * @param updateSurplusFlag 更新余量标志
     * @description: 更新库存
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/1/25
     */
    @Override
    public SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag) {
        return this.updateStoreSurplus(surplusUpdateVO, updateInstoreFlag, updateSurplusFlag, false);
    }

    /**
     * @param surplusUpdateVO
     * @description: 更新库存
     * @return: java.util.List<com.ejianc.business.store.vo.SurplusVO>
     * @author songlx
     * @date: 2022/1/25
     */
    @Override
    public SurplusUpdateVO updateStoreSurplus(SurplusUpdateVO surplusUpdateVO, boolean updateInstoreFlag, boolean updateSurplusFlag, boolean updateReturnGoodsFlag) {
        Long storeId = surplusUpdateVO.getStoreId();
        List<Long> materialIds = surplusUpdateVO.getMaterialIds();
        List<SurplusVO> surplusVOList = surplusUpdateVO.getSurplusVOList();
        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id", storeId);
        queryWrapper.in("material_id", materialIds);
        List<SurplusEntity> list = this.list(queryWrapper);

        //传入的物资有可能会重复
        Map<Long, List<SurplusVO>> surplusVOMap = surplusVOList.stream().collect(Collectors.groupingBy(SurplusVO::getMaterialId));
        ArrayList<SurplusVO> surplusVOS = new ArrayList<>();

        surplusVOMap.forEach((materialId, value) -> {
            List<SurplusVO> surplusll = surplusVOMap.get(materialId);
            SurplusVO surplusVO_0 = surplusll.get(0);
            if (surplusll.size() > 1) {
                SurplusVO surplusVO = BeanMapper.map(surplusVO_0, SurplusVO.class);
                surplusVO.setOutLockMny(BigDecimal.ZERO);
                surplusVO.setOutLockTaxMny(BigDecimal.ZERO);
                surplusVO.setSurplusMny(BigDecimal.ZERO);
                surplusVO.setSurplusTaxMny(BigDecimal.ZERO);
                surplusVO.setSurplusNum(BigDecimal.ZERO);
                surplusVO.setInstoreMny(BigDecimal.ZERO);
                surplusVO.setInstoreTaxMny(BigDecimal.ZERO);
                surplusVO.setInstoreNum(BigDecimal.ZERO);
                surplusVO.setOutLockNum(BigDecimal.ZERO);
                surplusVO.setReturnGoodsNum(BigDecimal.ZERO);
                surplusll.forEach(t -> {
                    surplusVO.setOutLockMny(ComputeUtil.safeAdd(surplusVO.getOutLockMny(), t.getOutLockMny()));
                    surplusVO.setOutLockTaxMny(ComputeUtil.safeAdd(surplusVO.getOutLockTaxMny(), t.getOutLockTaxMny()));
                    surplusVO.setSurplusMny(ComputeUtil.safeAdd(surplusVO.getSurplusMny(), t.getSurplusMny()));
                    surplusVO.setSurplusTaxMny(ComputeUtil.safeAdd(surplusVO.getSurplusTaxMny(), t.getSurplusTaxMny()));
                    surplusVO.setSurplusNum(ComputeUtil.safeAdd(surplusVO.getSurplusNum(), t.getSurplusNum()));
                    surplusVO.setInstoreMny(ComputeUtil.safeAdd(surplusVO.getInstoreMny(), t.getInstoreMny()));
                    surplusVO.setInstoreTaxMny(ComputeUtil.safeAdd(surplusVO.getInstoreTaxMny(), t.getInstoreTaxMny()));
                    surplusVO.setInstoreNum(ComputeUtil.safeAdd(surplusVO.getInstoreNum(), t.getInstoreNum()));
                    surplusVO.setOutLockNum(ComputeUtil.safeAdd(surplusVO.getOutLockNum(), t.getOutLockNum()));
                    surplusVO.setReturnGoodsNum(ComputeUtil.safeAdd(surplusVO.getReturnGoodsNum(), t.getReturnGoodsNum()));
                });
                surplusVOS.add(surplusVO);
            } else {
                surplusVOS.add(surplusVO_0);
            }

        });

        //无则全部增量库存, 说明是新入库物资,由于更新库存VO默认放有退货量,这里重置下退货数量
        if (CollectionUtils.isEmpty(list)) {
            surplusVOS.forEach(t -> {
                t.setOutLockMny(BigDecimal.ZERO);
                t.setOutLockTaxMny(BigDecimal.ZERO);
                t.setReturnGoodsNum(BigDecimal.ZERO);
                t.setOutLockNum(BigDecimal.ZERO);
                if (!updateSurplusFlag) {
                    t.setSurplusMny(BigDecimal.ZERO);
                    t.setSurplusTaxMny(BigDecimal.ZERO);
                    t.setSurplusNum(BigDecimal.ZERO);
                }
            });
            List<SurplusEntity> surplusEntities = BeanMapper.mapList(surplusVOS, SurplusEntity.class);
            this.saveOrUpdateBatch(surplusEntities);
            return surplusUpdateVO;
        }
        Map<Long, SurplusEntity> surplusEntityMap = list.stream().collect(Collectors.toMap(k -> k.getMaterialId(), (k) -> k));

        ArrayList<SurplusEntity> newSurplusList = new ArrayList<>();
        surplusVOS.forEach(
                t -> {
                    Long materialId = t.getMaterialId();
                    SurplusEntity surplusEntity = surplusEntityMap.get(materialId);
                    if (null == surplusEntity) {
                        //仓库没有该物资记录,就初始化下数据
                        t.setOutLockMny(BigDecimal.ZERO);
                        t.setOutLockTaxMny(BigDecimal.ZERO);
                        t.setReturnGoodsNum(BigDecimal.ZERO);
                        t.setOutLockNum(BigDecimal.ZERO);
                        if (!updateSurplusFlag) {
                            t.setSurplusMny(BigDecimal.ZERO);
                            t.setSurplusTaxMny(BigDecimal.ZERO);
                            t.setSurplusNum(BigDecimal.ZERO);
                        }
                        newSurplusList.add(BeanMapper.map(t, SurplusEntity.class));
                    } else {
                        //如果有则吧新入库的量和金额增量上去
                        if (updateSurplusFlag) {
                            surplusEntity.setSurplusMny(ComputeUtil.safeAdd(surplusEntity.getSurplusMny(), t.getSurplusMny()));
                            surplusEntity.setSurplusTaxMny(ComputeUtil.safeAdd(surplusEntity.getSurplusTaxMny(), t.getSurplusTaxMny()));
                            surplusEntity.setSurplusNum(ComputeUtil.safeAdd(surplusEntity.getSurplusNum(), t.getSurplusNum()));
                        }
                        // 更新锁定金额增加
                        surplusEntity.setOutLockMny(ComputeUtil.safeAdd(surplusEntity.getOutLockMny(), t.getOutLockTaxMny()));
                        surplusEntity.setOutLockTaxMny(ComputeUtil.safeAdd(surplusEntity.getOutLockMny(), t.getOutLockTaxMny()));

                        //更新入库量
                        if (updateInstoreFlag) {
                            surplusEntity.setInstoreMny(ComputeUtil.safeAdd(surplusEntity.getInstoreMny(), t.getSurplusMny()));
                            surplusEntity.setInstoreTaxMny(ComputeUtil.safeAdd(surplusEntity.getInstoreTaxMny(), t.getSurplusTaxMny()));
                            surplusEntity.setInstoreNum(ComputeUtil.safeAdd(surplusEntity.getInstoreNum(), t.getSurplusNum()));
                        }
                        //更新退库量
                        if (updateReturnGoodsFlag) {
                            surplusEntity.setReturnGoodsNum(ComputeUtil.safeAdd(surplusEntity.getReturnGoodsNum(), t.getReturnGoodsNum()));
                        }
                        newSurplusList.add(surplusEntity);
                    }
                }
        );
        this.saveOrUpdateBatch(newSurplusList);
        surplusUpdateVO.setSurplusVOList(BeanMapper.mapList(newSurplusList, SurplusVO.class));
        return surplusUpdateVO;
    }

    /**
     * @param surplusUpdateVO
     * @description: 校验库存量是否够用-- 出库
     * @return: com.ejianc.framework.core.response.CommonResponse<cn.hutool.json.JSONObject>
     * @author songlx
     * @date: 2022/1/25
     */
    @Override
    public CommonResponse<SurplusUpdateVO> validateSurplus(SurplusUpdateVO surplusUpdateVO) {
        Long storeId = surplusUpdateVO.getStoreId();
        List<Long> materialIds = surplusUpdateVO.getMaterialIds();
        List<SurplusVO> surplusVOList = surplusUpdateVO.getSurplusVOList();
        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id", storeId);
        queryWrapper.in("material_id", materialIds);
        List<SurplusEntity> surplusEntityList = this.list(queryWrapper);
        Map<Long, SurplusEntity> surplusNumMap = surplusEntityList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), Function.identity(), (key1, key2) -> key1));
        for (SurplusVO t : surplusVOList) {
            Long materialId = t.getMaterialId();
            //相对出库量，即追加出货量，由于退货（负数入库，本质是出库）传进来的是负数num这里做了转正数处理
            BigDecimal outChangeNum = ComputeUtil.isLessThan(t.getSurplusNum(), BigDecimal.ZERO) ? ComputeUtil.safeSub(BigDecimal.ZERO, t.getSurplusNum()) : t.getSurplusNum();
            //仓库剩余量
            BigDecimal surplusNum = ComputeUtil.safeSub(surplusNumMap.get(materialId).getSurplusNum(), surplusNumMap.get(materialId).getIdleNum());
            //原占用锁定量
            BigDecimal outLockNum = t.getOutLockNum();
            //物资本次实际可出数量 = outLockNum + surplusNum
            if (ComputeUtil.isGreaterThan(outChangeNum, surplusNum)) {
                return CommonResponse.error("物资[名称：" + t.getMaterialName() + "，规格：" + StrUtil.emptyToDefault(t.getMaterialSpec(), "无") + "]，库存余量：" + ComputeUtil.scaleTwo(ComputeUtil.nullToZero(surplusNum)) + "，库存不足!");
            }
        }
        return CommonResponse.success(surplusUpdateVO);
    }

    /**
     * @param storeManageVO
     * @description: 先进先出算法计算
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/1/26
     */
    @Override
    public UseCalculateVO useCalculate(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO(storeId, flowVOList, false);

        Long sourceId = storeManageVO.getSourceId();

        //得到的结果集
        // 1 占用入库
        List<FlowVO> flowUpdateList = new ArrayList<>();
        // 2 出入关系 默认放原有占用关系
        Map<String, InOutVO> inOutUpdateMap = new HashMap<>();
        // 3 库存
        Map<Long, SurplusVO> surplusUpdateMap = new HashMap<>();
        QueryWrapper<SurplusEntity> surplusEntityQueryWrapper = new QueryWrapper<>();
        surplusEntityQueryWrapper.eq("store_id", storeId);
        surplusEntityQueryWrapper.in("material_id", surplusUpdateVO.getMaterialIds());
        List<SurplusEntity> surplusEntities = surplusService.list(surplusEntityQueryWrapper);
        List<SurplusVO> surplusVOS = BeanMapper.mapList(surplusEntities, SurplusVO.class);
        //原来的库存
        surplusVOS.forEach(t -> surplusUpdateMap.put(t.getMaterialId(), t));
        List<InOutVO> inOutVOs = null;
        Map<Long, BigDecimal> lockNum = new HashMap<>();
        if (sourceId != null) {
            QueryWrapper<InOutEntity> inOutEntityQueryWrapper = new QueryWrapper<>();
            inOutEntityQueryWrapper.eq("out_bill_id", sourceId);
            List<InOutEntity> inOutEntities = inOutService.list(inOutEntityQueryWrapper);
            inOutVOs = BeanMapper.mapList(inOutEntities, InOutVO.class);
            //原有占用的数量
            inOutVOs.forEach(t -> {
                inOutUpdateMap.put(t.getMaterialId() + String.valueOf(t.getInFlowId()), t);
                Long materialId = t.getMaterialId();
                BigDecimal lock = lockNum.get(materialId);
                lockNum.put(materialId, ComputeUtil.safeAdd(lock, t.getOutLockNum()));
            });
        }

        //物资合计出货量
        HashMap<Long, InOutVO> materialNumMap = new HashMap<>();
        for (FlowVO flowVO : flowVOList) {
            String rowState = flowVO.getRowState();
            Long materialId = flowVO.getMaterialId();
            BigDecimal itemNum = flowVO.getNum();
            if ("del".equals(rowState)) {
                itemNum = BigDecimal.ZERO;
            }
            InOutVO inOutVO = materialNumMap.get(materialId);
            if (null == inOutVO) {
                inOutVO = new InOutVO();
                inOutVO.setInOutType(flowVO.getInOutType());
                inOutVO.setInOutTypeName(flowVO.getInOutTypeName());
                inOutVO.setOutStoreId(flowVO.getStoreId());
                inOutVO.setOutStoreName(flowVO.getStoreName());
                inOutVO.setOutProjectId(flowVO.getProjectId());
                inOutVO.setOutProjectName(flowVO.getProjectName());
                if (flowVO.getId() == null) {
                    flowVO.setId(IdWorker.getId());
                }
                inOutVO.setOutFlowId(flowVO.getId());
                inOutVO.setOutLockNum(itemNum);
                inOutVO.setOutBillDetailId(flowVO.getSourceDetailId());
                inOutVO.setOutBillId(flowVO.getSourceId());
                inOutVO.setOutBillCode(flowVO.getSourceBillCode());
                inOutVO.setMaterialId(flowVO.getMaterialId());
                inOutVO.setOutDate(flowVO.getSourceBillDate());
                inOutVO.setPickUnitId(flowVO.getPickUnitId());
                inOutVO.setPickUnitName(flowVO.getPickUnitName());
                inOutVO.setPickContractId(flowVO.getPickContractId());
                inOutVO.setPickContractName(flowVO.getPickContractName());
            } else {
                BigDecimal sumNum = ComputeUtil.safeAdd(inOutVO.getOutLockNum(), itemNum);
                inOutVO.setOutLockNum(sumNum);
            }
            materialNumMap.put(materialId, inOutVO);
        }

        //2 依据先进先出 出库
        QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id", storeId);
        queryWrapper.in("material_id", surplusUpdateVO.getMaterialIds());
        //生效态
        queryWrapper.eq("effective_state", StoreCommonConsts.YES);
        //入库单 可以使用的 未用完的
        queryWrapper.in("out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEABLE, StoreCommonConsts.UseOutFlag.USEING));
        queryWrapper.orderByAsc("material_id", "source_bill_date");
        List<FlowEntity> instoreList = flowService.list(queryWrapper);
        //入库余量
        Map<Long, List<FlowEntity>> instoreNumMap = instoreList.stream().collect(Collectors.groupingBy(FlowEntity::getMaterialId));

        //出库占用
        Iterator<Long> it = materialNumMap.keySet().iterator();
        while (it.hasNext()) {
            Long materialId = it.next();
            InOutVO outInOut = materialNumMap.get(materialId);
            BigDecimal outLockNum = outInOut.getOutLockNum();
            //TODO  获取相对变化量
            BigDecimal changOutNum = ComputeUtil.safeSub(outLockNum, lockNum.get(materialId));
            BigDecimal changOutMny = BigDecimal.ZERO;
            BigDecimal changOutTaxMny = BigDecimal.ZERO;
            // 新的物资出库数量与原占用数量相同则不处理
            if (!ComputeUtil.equals(changOutNum, BigDecimal.ZERO)) {
            /*    it.remove();
                //相对数量都为0的话则没有发生变化,不需要做任何处理
                if (materialNumMap.isEmpty()) {
                    return null;
                }
                continue;
            }*/
                // 3 更新库存 当前物资的变化量 changOutNum
                // 更新库存量
                SurplusVO surplusVO = surplusUpdateMap.get(materialId);
                BigDecimal surplusNumStore = ComputeUtil.safeSub(surplusVO.getSurplusNum(), changOutNum);
                surplusVO.setSurplusNum(surplusNumStore);
                BigDecimal newOutLockNum = ComputeUtil.safeAdd(surplusVO.getOutLockNum(), changOutNum);
                surplusVO.setOutLockNum(newOutLockNum);
                // 相对变更值 > 0, 正向占用
                if (ComputeUtil.isGreaterThan(changOutNum, BigDecimal.ZERO)) {
                    List<FlowEntity> flowEntities = instoreNumMap.get(materialId);
                    flowEntities.sort(Comparator.comparingLong((FlowEntity o) -> o.getSourceBillDate().getTime()).thenComparingLong(n -> n.getEffectiveDate().getTime()));
                    boolean breakFlag = false;
                    for (FlowEntity flowEntity : flowEntities) {
                        InOutVO newInOutVO = new InOutVO();
                        FlowVO flow = BeanMapper.map(flowEntity, FlowVO.class);
                        BigDecimal surplusNum = flow.getSurplusNum();
                        // 本次入库占用值
                        BigDecimal thisLockNum = BigDecimal.ZERO;

                        // 出库量大于等于 当前入库 余量 则入库余量清零
                        if (ComputeUtil.isGreaterOrEqual(changOutNum, surplusNum)) {
                            thisLockNum = surplusNum;
                            flow.setSurplusNum(BigDecimal.ZERO);
                            flow.setSurplusMny(BigDecimal.ZERO);
                            flow.setSurplusTaxMny(BigDecimal.ZERO);
                            flow.setOutLockNum(ComputeUtil.safeAdd(flow.getOutLockNum(), thisLockNum));
                            flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                            changOutNum = ComputeUtil.safeSub(changOutNum, thisLockNum);
                        } else {
                            thisLockNum = changOutNum;
                            surplusNum = ComputeUtil.safeSub(surplusNum, changOutNum);
                            BigDecimal mny = ComputeUtil.safeMultiply(surplusNum, flow.getPrice());
                            BigDecimal taxMny = ComputeUtil.safeMultiply(surplusNum, flow.getTaxPrice());
                            flow.setSurplusNum(surplusNum);
                            flow.setSurplusMny(mny);
                            flow.setSurplusTaxMny(taxMny);
                            flow.setOutLockNum(ComputeUtil.safeAdd(flow.getOutLockNum(), thisLockNum));
                            flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                            changOutNum = BigDecimal.ZERO;
                        }
                        //根据changOutNum是否抵扣完,设置继续占用入库中断标志
                        breakFlag = ComputeUtil.isEmpty(changOutNum);
                        FlowVO flowVO = BeanMapper.map(flow, FlowVO.class);
                        // 1 加入更新入库
                        flowUpdateList.add(flowVO);
                        // 2 加入占用关系
                        String inOutKey = materialId + String.valueOf(flow.getId());
                        InOutVO inOutVO = inOutUpdateMap.get(inOutKey);
                        if (inOutVO != null) {
                            BigDecimal newThisLockNum = ComputeUtil.safeAdd(thisLockNum, inOutVO.getOutLockNum());
                            inOutVO.setOutLockNum(newThisLockNum);
                            newInOutVO = BeanMapper.map(inOutVO, InOutVO.class);
                        } else {
                            newInOutVO = StoreManageUtil.getInOutVO(flow, outInOut, thisLockNum);
                        }
                        inOutUpdateMap.put(inOutKey, newInOutVO);
                        // 3 计算仓库变化价格
                        BigDecimal addMny = ComputeUtil.safeMultiply(thisLockNum, flow.getPrice());
                        changOutMny = ComputeUtil.safeAdd(changOutMny, addMny);
                        BigDecimal addTaxMny = ComputeUtil.safeMultiply(thisLockNum, flow.getTaxPrice());
                        changOutTaxMny = ComputeUtil.safeAdd(changOutTaxMny, addTaxMny);
                        if (breakFlag) break;
                    }
                } else {
                    //出库数量 changOutNum 如果是负数 ,那就是要释放库存了
                    // 获取到占用的入库单
                    List<Long> inFlowIds = inOutVOs.stream().map(InOutVO::getInFlowId).collect(Collectors.toList());
                    QueryWrapper<FlowEntity> inFlowQueryWrapper = new QueryWrapper<>();
                    inFlowQueryWrapper.in("id", inFlowIds);
                    inFlowQueryWrapper.eq("material_id", materialId);
                    // 倒序扣除
                    inFlowQueryWrapper.orderByDesc("material_id", "effective_date");
                    List<FlowEntity> inFlowList = flowService.list(inFlowQueryWrapper);
                    //入库余量
                    Map<Long, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(FlowEntity::getMaterialId));
                    List<FlowEntity> flowEntities = inFlowMap.get(materialId);
                    boolean useBreakFlag = false;
                    //转化为正数去抵扣
                    BigDecimal changOutNumZS = ComputeUtil.safeSub(BigDecimal.ZERO, changOutNum);
                    for (FlowEntity flowEntity : flowEntities) {
                        FlowVO useFlow = BeanMapper.map(flowEntity, FlowVO.class);
                        BigDecimal surplusNum = useFlow.getSurplusNum();
                        BigDecimal useLockNum = useFlow.getOutLockNum();
                        //本次释放占用
                        BigDecimal thisUnUseLockNum = null;
                        boolean isBackUseAll = ComputeUtil.isGreaterOrEqual(changOutNumZS, useLockNum);
                        if (isBackUseAll) {
                            thisUnUseLockNum = useLockNum;
                            //useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                            changOutNumZS = ComputeUtil.safeSub(changOutNumZS, useLockNum);
                        } else {
                            useBreakFlag = true;
                            thisUnUseLockNum = changOutNumZS;
                            //useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        }
                        BigDecimal surLockNum = ComputeUtil.safeSub(useLockNum, thisUnUseLockNum);
                        useFlow.setOutLockNum(surLockNum);
                        //更新库存余量和余额
                        BigDecimal surNum = ComputeUtil.safeAdd(surplusNum, thisUnUseLockNum);
                        useFlow.setSurplusNum(surNum);
                        useFlow.setSurplusMny(ComputeUtil.safeMultiply(surNum, useFlow.getPrice()));
                        useFlow.setSurplusTaxMny(ComputeUtil.safeMultiply(surNum, useFlow.getTaxPrice()));
                        //未被占用,或者未出库,则恢复成可用状态.其他是占用状态
                        if (ComputeUtil.isEmpty(useFlow.getOutNum()) && ComputeUtil.isEmpty(useFlow.getOutLockNum())) {
                            useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                        } else {
                            useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        }
                        //1 更新入库
                        flowUpdateList.add(useFlow);
                        //2 更新出入库占用
                        String inOutKey = materialId + String.valueOf(useFlow.getId());
                        InOutVO inOutVO = inOutUpdateMap.get(inOutKey);
                        if (inOutVO != null) {
                            BigDecimal newThisLockNum = ComputeUtil.safeSub(inOutVO.getOutLockNum(), thisUnUseLockNum);
                            //占用关系归于0,那么删此关系
                            if (ComputeUtil.isEmpty(newThisLockNum)) {
                                //如果退回完毕直接置为删除态
                                inOutVO.setDr(1);
                            } else {
                                inOutVO.setOutLockNum(newThisLockNum);
                            }
                        }
                        // 转化成负数去冲抵库存
                        BigDecimal thisUnUseLockNum_FS = ComputeUtil.convertToMinusNumber(thisUnUseLockNum);
                        // 3 计算仓库变化价格
                        BigDecimal addMny = ComputeUtil.safeMultiply(thisUnUseLockNum_FS, useFlow.getPrice());
                        changOutMny = ComputeUtil.safeAdd(changOutMny, addMny);
                        BigDecimal addTaxMny = ComputeUtil.safeMultiply(thisUnUseLockNum_FS, useFlow.getTaxPrice());
                        changOutTaxMny = ComputeUtil.safeAdd(changOutTaxMny, addTaxMny);
                        if (useBreakFlag) break;
                    }
                }
                // 3 更新库存 当前物资的变化量 changOutNum
                // 更新库存金额
                surplusVO.setOutLockMny(changOutMny);
                surplusVO.setOutLockTaxMny(changOutTaxMny);
                surplusVO.setSurplusMny(ComputeUtil.safeSub(surplusVO.getSurplusMny(), changOutMny));
                surplusVO.setSurplusTaxMny(ComputeUtil.safeSub(surplusVO.getSurplusTaxMny(), changOutTaxMny));
            }
        }
        // 4 占用物资价格计算 根据出入库关系 inOutUpdateMap计算占用均价
        List<UseMaterialPriceVO> useMaterialPriceVOList = BeanMapper.mapList(flowVOList, UseMaterialPriceVO.class);

        ArrayList<InOutVO> newInOutVOList = new ArrayList<>(inOutUpdateMap.values());
        Map<Long, List<InOutVO>> newInOutMap = newInOutVOList.stream().collect(Collectors.groupingBy(InOutVO::getMaterialId));
        useMaterialPriceVOList.forEach(t -> {
            List<InOutVO> inOutVOS = newInOutMap.get(t.getMaterialId());
            if (CollectionUtils.isNotEmpty(inOutVOS)) {
                BigDecimal mny = null;
                BigDecimal taxMny = null;
                BigDecimal tax = null;
                for (InOutVO in : inOutVOS) {
                    BigDecimal outLockNum = in.getOutLockNum();
                    BigDecimal price = in.getPrice();
                    BigDecimal taxPrice = in.getTaxPrice();
                    BigDecimal addMny = ComputeUtil.safeMultiply(outLockNum, price);
                    BigDecimal addTaxMny = ComputeUtil.safeMultiply(outLockNum, taxPrice);
                    if (in.getDr() != 1) {
                        mny = ComputeUtil.safeAdd(addMny, mny);
                        taxMny = ComputeUtil.safeAdd(addTaxMny, taxMny);
                        tax = ComputeUtil.safeSub(taxMny, mny);
                    }

                }
                t.setTax(tax);
                t.setMny(mny);
                t.setTaxMny(taxMny);
                BigDecimal price = ComputeUtil.safeDiv(t.getMny(), t.getNum());
                BigDecimal taxPrice = ComputeUtil.safeDiv(t.getTaxMny(), t.getNum());
                t.setPrice(price);
                t.setTaxPrice(taxPrice);
            }
        });

        UseCalculateVO calculateVO = new UseCalculateVO();
        calculateVO.setStoreManageVO(storeManageVO);
        calculateVO.setUpdateFlowVOList(flowUpdateList);
        calculateVO.setUpdateInOutVOList(newInOutVOList);
        calculateVO.setUpdateSurplusVOList(new ArrayList<>(surplusUpdateMap.values()));
        calculateVO.setUseMaterialPriceVOList(useMaterialPriceVOList);
        return calculateVO;
    }

    /**
     * @param storeManageVO
     * @param outEffectiveON
     * @description: 根据出入库关系回滚入库和仓库余量
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/2/14
     */
    @Override
    public UseCalculateVO outRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON) {

        UseCalculateVO calculateVO = new UseCalculateVO();
        List<Long> sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        QueryWrapper<InOutEntity> inOutEntityQueryWrapper = new QueryWrapper<>();
        inOutEntityQueryWrapper.in("out_bill_id", sourceIdsForRollBack);
        List<InOutEntity> inOutEntities = inOutService.list(inOutEntityQueryWrapper);
        List<InOutVO> inOutVOs = BeanMapper.mapList(inOutEntities, InOutVO.class);
        // 占用入库单,多少量
        Map<Long, BigDecimal> flowNum = new HashMap<>();
        // 占用仓库物资维度,占用库存量
        Map<String, SurplusVO> surplusNum = new HashMap<>();
        ArrayList<Long> storeIds = new ArrayList<>();
        ArrayList<Long> materialIds = new ArrayList<>();
        for (InOutVO t : inOutVOs) {
            Long inFlowId = t.getInFlowId();
            BigDecimal _num = flowNum.get(inFlowId);
            Long storeId = t.getInStoreId();
            Long materialId = t.getMaterialId();
            String surplusKey = String.valueOf(storeId) + materialId;
            storeIds.add(storeId);
            materialIds.add(materialId);

            SurplusVO surplusUpdateVO = surplusNum.get(surplusKey);
            if (surplusUpdateVO == null) {
                surplusUpdateVO = new SurplusVO();
            }
            BigDecimal surNum = surplusUpdateVO.getSurplusNum();
            BigDecimal surMny = surplusUpdateVO.getSurplusMny();
            BigDecimal surTaxMny = surplusUpdateVO.getSurplusTaxMny();

            //生效回滚,拿出库数量回滚
            if (outEffectiveON) {
                BigDecimal returnStoreNum = t.getReturnStoreNum();
                //生效校验是否退库,退库不能弃审
                if (ComputeUtil.isNotEmpty(returnStoreNum)) {
                    calculateVO.setErrorMsg("单据已发生退库业务,不允许弃审!");
                    return calculateVO;
                }
                BigDecimal outNum = t.getOutNum();
                _num = ComputeUtil.safeAdd(_num, outNum);
                surNum = ComputeUtil.safeAdd(surNum, outNum);
                BigDecimal addMny = ComputeUtil.safeMultiply(outNum, t.getPrice());
                surMny = ComputeUtil.safeAdd(surMny, addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply(outNum, t.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd(surTaxMny, addTaxMny);

                t.setOutLockNum(outNum);
                t.setOutNum(BigDecimal.ZERO);
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            } else {
                _num = ComputeUtil.safeAdd(_num, t.getOutLockNum());
                surNum = ComputeUtil.safeAdd(surNum, t.getOutLockNum());

                BigDecimal addMny = ComputeUtil.safeMultiply(t.getOutLockNum(), t.getPrice());
                surMny = ComputeUtil.safeAdd(surMny, addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply(t.getOutLockNum(), t.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd(surTaxMny, addTaxMny);
            }
            flowNum.put(inFlowId, _num);

            surplusUpdateVO.setSurplusNum(surNum);
            surplusUpdateVO.setSurplusMny(surMny);
            surplusUpdateVO.setSurplusTaxMny(surTaxMny);
            surplusNum.put(surplusKey, surplusUpdateVO);
        }
        calculateVO.setUpdateInOutVOList(inOutVOs);

        List<FlowEntity> flowEntities = (List<FlowEntity>) flowService.listByIds(flowNum.keySet());
        List<FlowVO> flowVOS = BeanMapper.mapList(flowEntities, FlowVO.class);
        flowVOS.forEach(t -> {
                    Long id = t.getId();
                    BigDecimal num = flowNum.get(id);
                    //生效回滚,拿出库数量回滚
                    if (outEffectiveON) {
                        BigDecimal outLockNum = ComputeUtil.safeAdd(t.getOutLockNum(), num);
                        t.setOutLockNum(outLockNum);
                        BigDecimal outNum = ComputeUtil.safeSub(t.getOutNum(), num);
                        t.setOutNum(outNum);
                    } else {
                        BigDecimal outLockNum = ComputeUtil.safeSub(t.getOutLockNum(), num);
                        t.setOutLockNum(outLockNum);
                        BigDecimal surplusNumNew = ComputeUtil.safeAdd(t.getSurplusNum(), num);
                        t.setSurplusNum(surplusNumNew);
                        BigDecimal taxMny = ComputeUtil.safeMultiply(surplusNumNew, t.getTaxPrice());
                        t.setSurplusTaxMny(taxMny);
                        BigDecimal mny = ComputeUtil.safeMultiply(surplusNumNew, t.getPrice());
                        t.setSurplusMny(mny);
                    }
                    //未被占用,或者未出库,则恢复成可用状态.其他是占用状态
                    if (ComputeUtil.equals(t.getSurplusNum(), t.getNum())) {
                        t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                    } else {
                        if (ComputeUtil.isEmpty(t.getSurplusNum())) {
                            t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                        } else {
                            t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        }
                    }


                }
        );
        calculateVO.setUpdateFlowVOList(flowVOS);

        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("store_id", storeIds);
        queryWrapper.in("material_id", materialIds);
        List<SurplusEntity> list = this.list(queryWrapper);

        List<SurplusVO> surplusVOS = BeanMapper.mapList(list, SurplusVO.class);
        surplusVOS.forEach(t -> {
                    String key = String.valueOf(t.getStoreId()) + t.getMaterialId();
                    SurplusVO surplusVO = surplusNum.get(key);
                    BigDecimal _surplusNum = surplusVO.getSurplusNum();
                    if (outEffectiveON) {
                        //生效回滚,仓库锁定数量增加,余量不变,锁定金额增加
                        BigDecimal outLockNum = ComputeUtil.safeAdd(t.getOutLockNum(), _surplusNum);
                        t.setOutLockNum(outLockNum);
                        t.setOutLockMny(ComputeUtil.safeAdd(t.getOutLockMny(), surplusVO.getSurplusMny()));
                        t.setOutLockTaxMny(ComputeUtil.safeAdd(t.getOutLockTaxMny(), surplusVO.getSurplusTaxMny()));

                    } else {
                        //删除回滚,仓库锁定数量减少,余量增加,锁定金额减少
                        BigDecimal outLockNum = ComputeUtil.safeSub(t.getOutLockNum(), _surplusNum);
                        t.setOutLockNum(outLockNum);
                        BigDecimal surplusNumNew = ComputeUtil.safeAdd(t.getSurplusNum(), _surplusNum);
                        t.setSurplusNum(surplusNumNew);
                        BigDecimal taxMny = ComputeUtil.safeAdd(surplusVO.getSurplusTaxMny(), t.getSurplusTaxMny());
                        t.setSurplusTaxMny(taxMny);
                        BigDecimal mny = ComputeUtil.safeAdd(surplusVO.getSurplusMny(), t.getSurplusMny());
                        t.setSurplusMny(mny);
                        t.setOutLockMny(ComputeUtil.safeSub(t.getOutLockMny(), surplusVO.getSurplusMny()));
                        t.setOutLockTaxMny(ComputeUtil.safeSub(t.getOutLockTaxMny(), surplusVO.getSurplusTaxMny()));
                    }

                }
        );
        calculateVO.setUpdateSurplusVOList(surplusVOS);

        return calculateVO;
    }

    /**
     * @param storeManageVO
     * @description: 周转材先进先出算法
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/3/2
     */
    @Override
    public UseCalculateVO useTurnCalculate(StoreManageVO storeManageVO) {

        Long storeId = storeManageVO.getStoreId();
        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO(storeId, flowVOList, false);

        Long sourceId = storeManageVO.getSourceId();

        //得到的结果集
        // 1 占用入库
        List<FlowVO> flowUpdateList = new ArrayList<>();
        // 2 出入关系 默认放原有占用关系
        Map<String, InOutVO> inOutUpdateMap = new HashMap<>();
        // 3 库存
        Map<Long, SurplusVO> surplusUpdateMap = new HashMap<>();
        QueryWrapper<SurplusEntity> surplusEntityQueryWrapper = new QueryWrapper<>();
        surplusEntityQueryWrapper.eq("store_id", storeId);
        surplusEntityQueryWrapper.in("material_id", surplusUpdateVO.getMaterialIds());
        List<SurplusEntity> surplusEntities = surplusService.list(surplusEntityQueryWrapper);
        List<SurplusVO> surplusVOS = BeanMapper.mapList(surplusEntities, SurplusVO.class);
        //原来的库存
        surplusVOS.forEach(t -> surplusUpdateMap.put(t.getMaterialId(), t));
        List<InOutVO> inOutVOs = null;
        //原有占用的数量
        Map<Long, BigDecimal> lockNum = new HashMap<>();
        if (sourceId != null) {
            QueryWrapper<InOutEntity> inOutEntityQueryWrapper = new QueryWrapper<>();
            inOutEntityQueryWrapper.eq("out_bill_id", sourceId);
            List<InOutEntity> inOutEntities = inOutService.list(inOutEntityQueryWrapper);
            inOutVOs = BeanMapper.mapList(inOutEntities, InOutVO.class);

            inOutVOs.forEach(t -> {
                inOutUpdateMap.put(t.getMaterialId() + String.valueOf(t.getInFlowId()), t);
                Long materialId = t.getMaterialId();
                BigDecimal lock = lockNum.get(materialId);
                lockNum.put(materialId, ComputeUtil.safeAdd(lock, t.getOutLockNum()));

            });
        }


        //物资合计出货量
        HashMap<Long, InOutVO> materialNumMap = new HashMap<>();
        for (FlowVO flowVO : flowVOList) {
            String rowState = flowVO.getRowState();
            Long materialId = flowVO.getMaterialId();
            BigDecimal itemNum = flowVO.getNum();
            if ("del".equals(rowState)) {
                itemNum = BigDecimal.ZERO;
            }
            InOutVO inOutVO = materialNumMap.get(materialId);
            if (null == inOutVO) {
                inOutVO = new InOutVO();
                inOutVO.setInOutType(flowVO.getInOutType());
                inOutVO.setInOutTypeName(flowVO.getInOutTypeName());
                inOutVO.setOutStoreId(flowVO.getStoreId());
                inOutVO.setOutStoreName(flowVO.getStoreName());
                inOutVO.setOutProjectId(flowVO.getProjectId());
                inOutVO.setOutProjectName(flowVO.getProjectName());
                if (flowVO.getId() == null) {
                    flowVO.setId(IdWorker.getId());
                }
                inOutVO.setOutFlowId(flowVO.getId());
                inOutVO.setOutLockNum(itemNum);
                inOutVO.setOutBillDetailId(flowVO.getSourceDetailId());
                inOutVO.setOutBillId(flowVO.getSourceId());
                inOutVO.setOutBillCode(flowVO.getSourceBillCode());
                inOutVO.setMaterialId(flowVO.getMaterialId());
                inOutVO.setOutDate(flowVO.getSourceBillDate());
                inOutVO.setPickUnitId(flowVO.getPickUnitId());
                inOutVO.setPickUnitName(flowVO.getPickUnitName());
                inOutVO.setPickContractId(flowVO.getPickContractId());
                inOutVO.setPickContractName(flowVO.getPickContractName());
            } else {
                BigDecimal sumNum = ComputeUtil.safeAdd(inOutVO.getOutLockNum(), itemNum);
                inOutVO.setOutLockNum(sumNum);
            }
            materialNumMap.put(materialId, inOutVO);
        }

        //2 依据先进先出 出库
        QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id", storeId);
        queryWrapper.in("material_id", surplusUpdateVO.getMaterialIds());
        //生效态
        queryWrapper.eq("effective_state", StoreCommonConsts.YES);
        //入库单 可以使用的 未用完的
        queryWrapper.in("out_use_flag", Arrays.asList(StoreCommonConsts.UseOutFlag.USEABLE, StoreCommonConsts.UseOutFlag.USEING));
        queryWrapper.orderByAsc("material_id", "source_bill_date");
        List<FlowEntity> instoreList = flowService.list(queryWrapper);
        //入库余量
        Map<Long, List<FlowEntity>> instoreNumMap = instoreList.stream().collect(Collectors.groupingBy(FlowEntity::getMaterialId));

        //出库占用
        Iterator<Long> it = materialNumMap.keySet().iterator();
        while (it.hasNext()) {
            Long materialId = it.next();
            InOutVO outInOut = materialNumMap.get(materialId);
            BigDecimal outLockNum = outInOut.getOutLockNum();
            //获取相对变化量
            BigDecimal changOutNum = ComputeUtil.safeSub(outLockNum, lockNum.get(materialId));
            BigDecimal changOutMny = BigDecimal.ZERO;
            BigDecimal changOutTaxMny = BigDecimal.ZERO;
            // 新的物资出库数量与原占用数量相同变化量部位0
            if (!ComputeUtil.equals(changOutNum, BigDecimal.ZERO)) {
              /*  it.remove();
                //相对数量都为0的话则没有发生变化,不需要做任何处理
                if (materialNumMap.isEmpty()) {
                    return null;
                }
                continue;
                String inOutKey = materialId + String.valueOf(flow.getId());
                InOutVO inOutVO = inOutUpdateMap.get(inOutKey);

            } else {*/

                // 3 更新库存 当前物资的变化量 changOutNum
                // 更新库存量
                SurplusVO surplusVO = surplusUpdateMap.get(materialId);
                BigDecimal surplusNumStore = ComputeUtil.safeSub(surplusVO.getSurplusNum(), changOutNum);
                surplusVO.setSurplusNum(surplusNumStore);
                BigDecimal newOutLockNum = ComputeUtil.safeAdd(surplusVO.getOutLockNum(), changOutNum);
                surplusVO.setOutLockNum(newOutLockNum);
                // 相对变更值 > 0, 正向占用
                if (ComputeUtil.isGreaterThan(changOutNum, BigDecimal.ZERO)) {
                    List<FlowEntity> flowEntities = instoreNumMap.get(materialId);
                    flowEntities.sort(Comparator.comparingLong((FlowEntity o) -> o.getSourceBillDate().getTime()).thenComparingLong(n -> n.getEffectiveDate().getTime()));
                    boolean breakFlag = false;
                    for (FlowEntity flowEntity : flowEntities) {
                        InOutVO newInOutVO = new InOutVO();
                        FlowVO flow = BeanMapper.map(flowEntity, FlowVO.class);
                        BigDecimal surplusNum = flow.getSurplusNum();
                        BigDecimal netMny = flow.getNetMny();
                        BigDecimal netTaxMny = flow.getNetTaxMny();
                        BigDecimal netPrice = ComputeUtil.safeDiv(netMny, surplusNum);
                        BigDecimal netTaxPrice = ComputeUtil.safeDiv(netTaxMny, surplusNum);
                        // 本次入库占用净值
                        BigDecimal thisLockNum = BigDecimal.ZERO;
                        BigDecimal thisLockNetMny = BigDecimal.ZERO;
                        BigDecimal thisLockNetTaxMny = BigDecimal.ZERO;
                        // 本次入库占用原值金额
                        BigDecimal thisLockPurchaseMny = BigDecimal.ZERO;
                        BigDecimal thisLockPurchaseTaxMny = BigDecimal.ZERO;

                        // 出库量大于等于 当前入库 余量 则入库余量清零
                        // 出完的话 出库净值 = 当前净值, 当前净值归于0
                        if (ComputeUtil.isGreaterOrEqual(changOutNum, surplusNum)) {
                            thisLockNum = surplusNum;
                            thisLockNetMny = netMny;
                            thisLockNetTaxMny = netTaxMny;

                            flow.setNetMny(BigDecimal.ZERO);
                            flow.setNetTaxMny(BigDecimal.ZERO);
                            flow.setSurplusNum(BigDecimal.ZERO);
                            flow.setOutLockNum(ComputeUtil.safeAdd(flow.getOutLockNum(), thisLockNum));
                            flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                            changOutNum = ComputeUtil.safeSub(changOutNum, thisLockNum);
                        } else {
                            thisLockNum = changOutNum;
                            surplusNum = ComputeUtil.safeSub(surplusNum, changOutNum);
                            thisLockNetMny = ComputeUtil.safeMultiply(thisLockNum, netPrice);
                            thisLockNetTaxMny = ComputeUtil.safeMultiply(thisLockNum, netTaxPrice);
                            flow.setSurplusNum(surplusNum);
                            flow.setOutLockNum(ComputeUtil.safeAdd(flow.getOutLockNum(), thisLockNum));
                            flow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                            changOutNum = BigDecimal.ZERO;
                        }

                        thisLockPurchaseMny = ComputeUtil.safeMultiply(thisLockNum, flowEntity.getPurchasePrice());
                        thisLockPurchaseTaxMny = ComputeUtil.safeMultiply(thisLockNum, flowEntity.getPurchaseTaxPrice());
                        // 当前净值减少,出库净值增加? 不增加,暂时不变吧
                        flow.setNetMny(ComputeUtil.safeSub(netMny, thisLockNetMny));
                        flow.setNetTaxMny(ComputeUtil.safeSub(netTaxMny, thisLockNetTaxMny));

                        //根据changOutNum是否抵扣完,设置继续占用入库中断标志
                        breakFlag = ComputeUtil.isEmpty(changOutNum);
                        FlowVO flowVO = BeanMapper.map(flow, FlowVO.class);
                        // 1 加入更新入库
                        flowUpdateList.add(flowVO);
                        // 2 加入占用关系
                        String inOutKey = materialId + String.valueOf(flow.getId());
                        InOutVO inOutVO = inOutUpdateMap.get(inOutKey);
                        if (inOutVO != null) {
                            BigDecimal newThisLockNum = ComputeUtil.safeAdd(thisLockNum, inOutVO.getOutLockNum());
                            inOutVO.setOutLockNum(newThisLockNum);
                            BigDecimal newThisLockNetMny = ComputeUtil.safeAdd(thisLockNetMny, inOutVO.getOutNetMny());
                            inOutVO.setOutNetMny(newThisLockNetMny);
                            BigDecimal newThisLockNetTaxMny = ComputeUtil.safeAdd(thisLockNetTaxMny, inOutVO.getOutNetTaxMny());
                            inOutVO.setOutNetTaxMny(newThisLockNetTaxMny);

                            BigDecimal newThisLockPurchaseMny = ComputeUtil.safeAdd(thisLockPurchaseMny, inOutVO.getPurchaseMny());
                            inOutVO.setPurchaseMny(newThisLockPurchaseMny);
                            BigDecimal newThisLockPurchaseTaxMny = ComputeUtil.safeAdd(thisLockPurchaseTaxMny, inOutVO.getPurchaseTaxMny());
                            inOutVO.setPurchaseTaxMny(newThisLockPurchaseTaxMny);

                            // 重算净值单价
                            // 如果出库多次保存过程中,做了摊销,会导致此次占用同一单子的净值均价出现梯度误差,是否需要摊销时不允许出库单自由态存在校验? 业务需要做校验
                            inOutVO.setPrice(ComputeUtil.safeDiv(inOutVO.getOutNetMny(), inOutVO.getOutLockNum()));
                            inOutVO.setTaxPrice(ComputeUtil.safeDiv(inOutVO.getOutNetTaxMny(), inOutVO.getOutLockNum()));
                            newInOutVO = BeanMapper.map(inOutVO, InOutVO.class);
                        } else {
                            newInOutVO = StoreManageUtil.getTurnInOutVO(flow, outInOut, thisLockNum, thisLockNetMny, thisLockNetTaxMny, thisLockPurchaseMny, thisLockPurchaseTaxMny);
                        }
                        inOutUpdateMap.put(inOutKey, newInOutVO);
                        // 3 计算仓库变化价格
                        changOutMny = ComputeUtil.safeAdd(changOutMny, thisLockNetMny);
                        changOutTaxMny = ComputeUtil.safeAdd(changOutTaxMny, thisLockNetTaxMny);
                        if (breakFlag) break;
                    }
                } else {
                    //出库数量 changOutNum 如果是负数 ,那就是要释放库存了
                    // 获取到占用的入库单
                    List<Long> inFlowIds = inOutVOs.stream().map(InOutVO::getInFlowId).collect(Collectors.toList());
                    QueryWrapper<FlowEntity> inFlowQueryWrapper = new QueryWrapper<>();
                    inFlowQueryWrapper.in("id", inFlowIds);
                    inFlowQueryWrapper.eq("material_id", materialId);
                    // 倒序扣除
                    inFlowQueryWrapper.orderByDesc("material_id", "effective_date");
                    List<FlowEntity> inFlowList = flowService.list(inFlowQueryWrapper);
                    //入库余量
                    Map<Long, List<FlowEntity>> inFlowMap = inFlowList.stream().collect(Collectors.groupingBy(FlowEntity::getMaterialId));
                    List<FlowEntity> flowEntities = inFlowMap.get(materialId);
                    boolean useBreakFlag = false;
                    //转化为正数去抵扣
                    BigDecimal changOutNumZS = ComputeUtil.safeSub(BigDecimal.ZERO, changOutNum);
                    for (FlowEntity flowEntity : flowEntities) {
                        FlowVO useFlow = BeanMapper.map(flowEntity, FlowVO.class);
                        BigDecimal surplusNum = useFlow.getSurplusNum();
                        BigDecimal useLockNum = useFlow.getOutLockNum();

                        BigDecimal netMny = useFlow.getNetMny();
                        BigDecimal netTaxMny = useFlow.getNetTaxMny();
                        BigDecimal netPrice = ComputeUtil.safeDiv(netMny, surplusNum);
                        BigDecimal netTaxPrice = ComputeUtil.safeDiv(netTaxMny, surplusNum);
                        //本次释放占用
                        BigDecimal thisUnUseLockNum = null;
                        boolean isBackUseAll = ComputeUtil.isGreaterOrEqual(changOutNumZS, useLockNum);
                        if (isBackUseAll) {
                            thisUnUseLockNum = useLockNum;
                            changOutNumZS = ComputeUtil.safeSub(changOutNumZS, useLockNum);
                        } else {
                            useBreakFlag = true;
                            thisUnUseLockNum = changOutNumZS;
                        }

                        //1 更新入库
                        BigDecimal surLockNum = ComputeUtil.safeSub(useLockNum, thisUnUseLockNum);
                        useFlow.setOutLockNum(surLockNum);
                        //更新库存余量和当前净值
                        BigDecimal surNum = ComputeUtil.safeAdd(surplusNum, thisUnUseLockNum);
                        useFlow.setSurplusNum(surNum);

                        //2 更新出入库占用
                        String inOutKey = materialId + String.valueOf(useFlow.getId());
                        InOutVO inOutVO = inOutUpdateMap.get(inOutKey);
                        if (inOutVO != null) {
                            BigDecimal newThisLockNum = ComputeUtil.safeSub(inOutVO.getOutLockNum(), thisUnUseLockNum);
                            //占用关系归于0,name删此关系
                            if (ComputeUtil.isEmpty(newThisLockNum)) {
                                //如果退回完毕直接置为删除态
                                inOutVO.setDr(1);
                                // 当前净值全部返回到入库单
                                useFlow.setNetMny(ComputeUtil.safeAdd(useFlow.getNetMny(), inOutVO.getOutNetMny()));
                                useFlow.setNetTaxMny(ComputeUtil.safeAdd(useFlow.getNetTaxMny(), inOutVO.getOutNetTaxMny()));
                                // 3 计算仓库变化价格,转化成负数去冲抵库存
                                changOutMny = ComputeUtil.convertToMinusNumber(ComputeUtil.safeAdd(changOutMny, inOutVO.getOutNetMny()));
                                changOutTaxMny = ComputeUtil.convertToMinusNumber(ComputeUtil.safeAdd(changOutTaxMny, inOutVO.getOutNetTaxMny()));
                            } else {
                                //计算净值单价,重置占用净值金额 = 净值单价 * 占用数量
                                BigDecimal newNetMny = ComputeUtil.safeMultiply(newThisLockNum, netPrice);
                                BigDecimal newNetTaxMny = ComputeUtil.safeMultiply(newThisLockNum, netTaxPrice);
                                inOutVO.setOutLockNum(newThisLockNum);
                                inOutVO.setOutNetMny(newNetMny);
                                inOutVO.setOutNetTaxMny(newNetTaxMny);
                                inOutVO.setPurchaseTaxMny(ComputeUtil.safeMultiply(newThisLockNum, useFlow.getPurchaseTaxPrice()));
                                inOutVO.setPurchaseMny(ComputeUtil.safeMultiply(newThisLockNum, useFlow.getPurchasePrice()));
                                // 释放一部分,返回部分净值
                                useFlow.setNetMny(ComputeUtil.safeAdd(useFlow.getNetMny(), newNetMny));
                                useFlow.setNetTaxMny(ComputeUtil.safeAdd(useFlow.getNetTaxMny(), newNetTaxMny));

                                // 3 计算仓库变化价格,转化成负数去冲抵库存
                                changOutMny = ComputeUtil.convertToMinusNumber(ComputeUtil.safeAdd(changOutMny, newNetMny));
                                changOutTaxMny = ComputeUtil.convertToMinusNumber(ComputeUtil.safeAdd(changOutTaxMny, newNetTaxMny));
                            }
                        }

                        //未被占用,或者未出库,则恢复成可用状态.其他是占用状态
                        if (ComputeUtil.isEmpty(useFlow.getOutNum()) && ComputeUtil.isEmpty(useFlow.getOutLockNum())) {
                            useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                        } else {
                            useFlow.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        }
                        flowUpdateList.add(useFlow);
                        if (useBreakFlag) break;
                    }
                }
                // 3 更新库存 当前物资的变化量 changOutNum
                // 更新库存金额
                surplusVO.setOutLockMny(changOutMny);
                surplusVO.setOutLockTaxMny(changOutTaxMny);
                surplusVO.setSurplusMny(ComputeUtil.safeSub(surplusVO.getSurplusMny(), changOutMny));
                surplusVO.setSurplusTaxMny(ComputeUtil.safeSub(surplusVO.getSurplusTaxMny(), changOutTaxMny));
            }
        }
        // 4 占用物资价格计算 根据出入库关系 inOutUpdateMap计算占用均价
        List<UseMaterialPriceVO> useMaterialPriceVOList = BeanMapper.mapList(flowVOList, UseMaterialPriceVO.class);

        ArrayList<InOutVO> newInOutVOList = new ArrayList<>(inOutUpdateMap.values());
        Map<Long, List<InOutVO>> newInOutMap = newInOutVOList.stream().collect(Collectors.groupingBy(InOutVO::getMaterialId));
        useMaterialPriceVOList.forEach(t -> {
            List<InOutVO> inOutVOS = newInOutMap.get(t.getMaterialId());
            if (CollectionUtils.isNotEmpty(inOutVOS)) {
                //净值
                BigDecimal mny = null;
                BigDecimal taxMny = null;
                //原值税额
                BigDecimal tax = null;
                //原值
                BigDecimal purchaseMny = null;
                BigDecimal purchaseTaxMny = null;
                for (InOutVO in : inOutVOS) {
                    BigDecimal addMny = in.getOutNetMny();
                    BigDecimal addTaxMny = in.getOutNetTaxMny();
                    if (in.getDr() != 1) {
                        mny = ComputeUtil.safeAdd(addMny, mny);
                        taxMny = ComputeUtil.safeAdd(addTaxMny, taxMny);
                        purchaseMny = ComputeUtil.safeAdd(in.getPurchaseMny(), purchaseMny);
                        purchaseTaxMny = ComputeUtil.safeAdd(in.getPurchaseTaxMny(), purchaseTaxMny);
                        tax = ComputeUtil.safeSub(purchaseTaxMny, purchaseMny);
                    }
                }
                t.setTax(tax);
                t.setMny(mny);
                t.setTaxMny(taxMny);
                t.setPurchaseMny(purchaseMny);
                t.setPurchaseTaxMny(purchaseTaxMny);
                BigDecimal price = ComputeUtil.safeDiv(t.getMny(), t.getNum());
                BigDecimal taxPrice = ComputeUtil.safeDiv(t.getTaxMny(), t.getNum());
                t.setPrice(price);
                t.setTaxPrice(taxPrice);

                BigDecimal purchasePrice = ComputeUtil.safeDiv(t.getPurchaseMny(), t.getNum());
                BigDecimal purchaseTaxPrice = ComputeUtil.safeDiv(t.getPurchaseTaxMny(), t.getNum());
                t.setPurchasePrice(purchasePrice);
                t.setPurchaseTaxPrice(purchaseTaxPrice);
            }
        });

        UseCalculateVO calculateVO = new UseCalculateVO();
        calculateVO.setStoreManageVO(storeManageVO);
        calculateVO.setUpdateFlowVOList(flowUpdateList);
        calculateVO.setUpdateInOutVOList(newInOutVOList);
        calculateVO.setUpdateSurplusVOList(new ArrayList<>(surplusUpdateMap.values()));
        calculateVO.setUseMaterialPriceVOList(useMaterialPriceVOList);
        return calculateVO;
    }

    /**
     * @param storeManageVO
     * @param outEffectiveON
     * @description: 周转材先进先出回滚算法
     * @return: com.ejianc.business.store.vo.UseCalculateVO
     * @author songlx
     * @date: 2022/3/3
     */
    @Override
    public UseCalculateVO turnOutRollBackByInOut(StoreManageVO storeManageVO, Boolean outEffectiveON) {
        UseCalculateVO calculateVO = new UseCalculateVO();
        List<Long> sourceIdsForRollBack = storeManageVO.getSourceIdsForRollBack();
        QueryWrapper<InOutEntity> inOutEntityQueryWrapper = new QueryWrapper<>();
        inOutEntityQueryWrapper.in("out_bill_id", sourceIdsForRollBack);
        List<InOutEntity> inOutEntities = inOutService.list(inOutEntityQueryWrapper);
        List<InOutVO> inOutVOs = BeanMapper.mapList(inOutEntities, InOutVO.class);

        Map<Long, InOutVO> flowNum = new HashMap<>();

        Map<String, SurplusVO> surplusNum = new HashMap<>();
        ArrayList<Long> storeIds = new ArrayList<>();
        ArrayList<Long> materialIds = new ArrayList<>();
        for (InOutVO t : inOutVOs) {
            Long inFlowId = t.getInFlowId();
            InOutVO inOutVO = flowNum.get(inFlowId);
            if (inOutVO == null) inOutVO = new InOutVO();
            BigDecimal _num = inOutVO.getNum();
            Long storeId = t.getInStoreId();
            Long materialId = t.getMaterialId();
            String surplusKey = String.valueOf(storeId) + materialId;
            storeIds.add(storeId);
            materialIds.add(materialId);

            //生效回滚,拿出库数量回滚
            SurplusVO surplusUpdateVO = surplusNum.get(surplusKey);
            if (surplusUpdateVO == null) {
                surplusUpdateVO = new SurplusVO();
            }
            BigDecimal surNum = surplusUpdateVO.getSurplusNum();
            BigDecimal surMny = surplusUpdateVO.getSurplusMny();
            BigDecimal surTaxMny = surplusUpdateVO.getSurplusTaxMny();

            //生效回滚,拿出库数量回滚
            if (outEffectiveON) {
                BigDecimal returnStoreNum = t.getReturnStoreNum();
                //生效校验是否退库,退库不能弃审
                if (ComputeUtil.isNotEmpty(returnStoreNum)) {
                    calculateVO.setErrorMsg("单据已发生退库业务,不允许弃审!");
                    return calculateVO;
                }
                BigDecimal outNum = t.getOutNum();
                _num = ComputeUtil.safeAdd(_num, outNum);
                surNum = ComputeUtil.safeAdd(surNum, outNum);
                BigDecimal addMny = ComputeUtil.safeMultiply(outNum, t.getPrice());
                surMny = ComputeUtil.safeAdd(surMny, addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply(outNum, t.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd(surTaxMny, addTaxMny);

                t.setOutLockNum(outNum);
                t.setOutNum(BigDecimal.ZERO);
                t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
            } else {
                _num = ComputeUtil.safeAdd(_num, t.getOutLockNum());
                surNum = ComputeUtil.safeAdd(surNum, t.getOutLockNum());
                BigDecimal addMny = ComputeUtil.safeMultiply(t.getOutLockNum(), t.getPrice());
                surMny = ComputeUtil.safeAdd(surMny, addMny);
                BigDecimal addTaxMny = ComputeUtil.safeMultiply(t.getOutLockNum(), t.getTaxPrice());
                surTaxMny = ComputeUtil.safeAdd(surTaxMny, addTaxMny);
            }
            inOutVO.setNum(_num);
            inOutVO.setOutNetMny(ComputeUtil.safeAdd(inOutVO.getOutNetMny(), t.getOutNetMny()));
            inOutVO.setOutNetTaxMny(ComputeUtil.safeAdd(inOutVO.getOutNetTaxMny(), t.getOutNetTaxMny()));
            flowNum.put(inFlowId, inOutVO);

            surplusUpdateVO.setSurplusNum(surNum);
            surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusMny(), t.getOutNetMny()));
            surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusTaxMny(), t.getOutNetMny()));
            surplusNum.put(surplusKey, surplusUpdateVO);
        }
        calculateVO.setUpdateInOutVOList(inOutVOs);

        List<FlowEntity> flowEntities = (List<FlowEntity>) flowService.listByIds(flowNum.keySet());
        List<FlowVO> flowVOS = BeanMapper.mapList(flowEntities, FlowVO.class);
        flowVOS.forEach(t -> {
                    Long id = t.getId();
                    InOutVO inOutVO = flowNum.get(id);
                    BigDecimal num = inOutVO.getNum();
                    //生效回滚,拿出库数量回滚, 出库净值减少, 当前净值不变,因为还在占用
                    if (outEffectiveON) {
                        BigDecimal outLockNum = ComputeUtil.safeAdd(t.getOutLockNum(), num);
                        t.setOutLockNum(outLockNum);
                        BigDecimal outNum = ComputeUtil.safeSub(t.getOutNum(), num);
                        t.setOutNum(outNum);
                        t.setOutNetMny(ComputeUtil.safeSub(t.getOutNetMny(), inOutVO.getOutNetMny()));
                        t.setOutNetTaxMny(ComputeUtil.safeSub(t.getOutNetTaxMny(), inOutVO.getOutNetTaxMny()));
                    } else {
                        //删除回滚,拿锁定数量回滚, 出库不变, 当前净增加
                        BigDecimal outLockNum = ComputeUtil.safeSub(t.getOutLockNum(), num);
                        t.setOutLockNum(outLockNum);
                        BigDecimal surplusNumNew = ComputeUtil.safeAdd(t.getSurplusNum(), num);
                        t.setSurplusNum(surplusNumNew);
                        t.setNetMny(ComputeUtil.safeAdd(t.getNetMny(), inOutVO.getOutNetMny()));
                        t.setNetTaxMny(ComputeUtil.safeAdd(t.getNetTaxMny(), inOutVO.getOutNetTaxMny()));
                    }
                    //未被占用,或者未出库,则恢复成可用状态.其他是占用状态
                    if (ComputeUtil.equals(t.getSurplusNum(), t.getNum())) {
                        t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEABLE);
                    } else {
                        if (ComputeUtil.isEmpty(t.getSurplusNum())) {
                            t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
                        } else {
                            t.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
                        }
                    }


                }
        );
        calculateVO.setUpdateFlowVOList(flowVOS);

        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("store_id", storeIds);
        queryWrapper.in("material_id", materialIds);
        List<SurplusEntity> list = this.list(queryWrapper);

        List<SurplusVO> surplusVOS = BeanMapper.mapList(list, SurplusVO.class);
        surplusVOS.forEach(t -> {
                    String key = String.valueOf(t.getStoreId()) + t.getMaterialId();
                    SurplusVO surplusVO = surplusNum.get(key);
                    BigDecimal _surplusNum = surplusVO.getSurplusNum();
                    if (outEffectiveON) {
                        //生效回滚,仓库锁定数量增加,剩余净值不变
                        BigDecimal outLockNum = ComputeUtil.safeAdd(t.getOutLockNum(), _surplusNum);
                        t.setOutLockNum(outLockNum);
                        t.setOutLockMny(ComputeUtil.safeAdd(t.getOutLockMny(), surplusVO.getSurplusMny()));
                        t.setOutLockTaxMny(ComputeUtil.safeAdd(t.getOutLockTaxMny(), surplusVO.getSurplusTaxMny()));
                    } else {
                        //删除回滚,仓库锁定数量减少,余量增加, 剩余净值增加
                        BigDecimal outLockNum = ComputeUtil.safeSub(t.getOutLockNum(), _surplusNum);
                        t.setOutLockNum(outLockNum);
                        BigDecimal surplusNumNew = ComputeUtil.safeAdd(t.getSurplusNum(), _surplusNum);
                        t.setSurplusNum(surplusNumNew);
                        BigDecimal taxMny = ComputeUtil.safeAdd(surplusVO.getSurplusTaxMny(), t.getSurplusTaxMny());
                        t.setSurplusTaxMny(taxMny);
                        BigDecimal mny = ComputeUtil.safeAdd(surplusVO.getSurplusMny(), t.getSurplusMny());
                        t.setSurplusMny(mny);
                        t.setOutLockMny(ComputeUtil.safeSub(t.getOutLockMny(), surplusVO.getSurplusMny()));
                        t.setOutLockTaxMny(ComputeUtil.safeSub(t.getOutLockTaxMny(), surplusVO.getSurplusTaxMny()));
                    }

                }
        );
        calculateVO.setUpdateSurplusVOList(surplusVOS);

        return calculateVO;
    }

    /**
     * @param storeManageVO
     * @description: 出库校验仓库余量
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.SurplusUpdateVO>
     * @author songlx
     * @date: 2022/3/10
     */
    @Override
    public CommonResponse<SurplusUpdateVO> validateStoreSurplusByOutLock(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO(storeId, flowVOList, false);
        List<InOutEntity> inOutEntityList = null;
        if (sourceId != null) {
            QueryWrapper<InOutEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("out_bill_id", sourceId);
            //生效状态 未生效
            queryWrapper.eq("effective_state", StoreCommonConsts.NO);
            inOutEntityList = inOutService.list(queryWrapper);
        }

        //1 校验库存量 要依据正数的变化量来和库存余量校验
        if (CollectionUtils.isNotEmpty(inOutEntityList)) {
            Map<Long, List<InOutEntity>> inOutMap = inOutEntityList.stream().collect(Collectors.groupingBy(InOutEntity::getMaterialId));

            Map<Long, BigDecimal> inOutNumMap = new HashMap<>();
            inOutMap.forEach((k, v) -> inOutNumMap.put(k, v.stream().map(InOutEntity::getOutLockNum).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd)));

            HashMap<Long, SurplusVO> surplusValidateMap = new HashMap<>();
            for (FlowVO flowVO : flowVOList) {
                if (!"del".equals(flowVO.getRowState())) {
                    Long materialId = flowVO.getMaterialId();
                    SurplusVO surplusVO = surplusValidateMap.get(materialId);
                    BigDecimal oldNum = inOutNumMap.get(materialId);
                    BigDecimal num = flowVO.getNum();
                    BigDecimal _num = ComputeUtil.safeSub(num, oldNum);
                    if (null != surplusVO) {
                        BigDecimal surplusNum = surplusVO.getSurplusNum();
                        surplusNum = ComputeUtil.safeAdd(surplusNum, _num);
                        surplusVO.setSurplusNum(surplusNum);

                        BigDecimal outLockNum = surplusVO.getOutLockNum();
                        outLockNum = ComputeUtil.safeAdd(outLockNum, oldNum);
                        surplusVO.setOutLockNum(outLockNum);
                    } else {
                        surplusVO = BeanMapper.map(flowVO, SurplusVO.class);
                        surplusVO.setSurplusNum(_num);
                        surplusVO.setOutLockNum(oldNum);
                    }
                    if (ComputeUtil.isGreaterThan(surplusVO.getSurplusNum(), BigDecimal.ZERO)) {
                        surplusValidateMap.put(materialId, surplusVO);
                    }
                }
            }
            surplusUpdateVO.setSurplusVOList(new ArrayList<>(surplusValidateMap.values()));
        }

        return this.validateSurplus(surplusUpdateVO);
    }

}
