/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.StoreMapper;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeService")
public class StoreServiceImpl
extends BaseServiceImpl<StoreMapper, StoreEntity>
implements IStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private StoreMapper storeMapper;
    @Autowired
    private ISurplusService surplusService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = StoreServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"s.dr", (Object)StoreCommonConsts.NO);
        wrapper.groupBy(new Object[]{"s.id"});
        return this.storeMapper.queryStoreList(wrapper);
    }

    @Override
    public StoreManageVO setStoreAttr(StoreManageVO storeManageVO) {
        String storeTypeName;
        String storeType;
        Long storeId = storeManageVO.getStoreId();
        StoreEntity storeEntity = (StoreEntity)((Object)this.storeMapper.selectById(storeId));
        if (StoreAttrEnum.SELFPURCHASE.getCode().equals(storeEntity.getAttrFlag().toString())) {
            storeType = StoreAttrEnum.SELFPURCHASE.getCode();
            storeTypeName = StoreAttrEnum.SELFPURCHASE.getDescription();
        } else {
            storeType = StoreAttrEnum.ASUPPLY.getCode();
            storeTypeName = StoreAttrEnum.ASUPPLY.getDescription();
        }
        List flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)flowVOList)) {
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
            }
        }
        storeManageVO.setFlowVOList(flowVOList);
        List straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty((Collection)straightOutFlowVOList)) {
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
            }
        }
        return storeManageVO;
    }

    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)id);
        queryWrapper.gt((Object)"surplus_num", (Object)0);
        List list = this.surplusService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed3\u5e93\u6709\u7269\u8d44");
        }
        return CommonResponse.success();
    }

    @Override
    public StoreEntity autoByProjectId(Long projectId, Integer attrFlag) {
        StoreEntity storeEntity = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"attr_flag", (Object)attrFlag);
        queryWrapper.eq((Object)"dr", (Object)StoreCommonConsts.NO);
        int count = this.count((Wrapper)queryWrapper);
        if (count == 0) {
            CommonResponse projectResponse = this.projectPoolApi.queryDetailById(projectId);
            this.logger.error("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f, {}", (Object)JSONObject.toJSONString((Object)projectResponse.getData()));
            if (!projectResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25, {}", (Object)projectResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            storeEntity = new StoreEntity();
            ProjectVO project = (ProjectVO)projectResponse.getData();
            storeEntity.setId(IdWorker.getId());
            storeEntity.setProjectId(project.getId());
            storeEntity.setProjectName(project.getProjectName());
            storeEntity.setProjectCode(project.getBillCode());
            storeEntity.setOrgId(project.getProjectDepartmentId());
            CommonResponse orgResponse = this.iOrgApi.getOneById(project.getOrgId());
            this.logger.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)orgResponse.getData()));
            if (!orgResponse.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f, {}", (Object)orgResponse.getMsg());
                throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25 \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            storeEntity.setOrgName(orgVO.getName());
            storeEntity.setOrgCode(orgVO.getCode());
            storeEntity.setParentOrgId(orgVO.getParentId());
            storeEntity.setParentOrgName(orgVO.getpFName());
            storeEntity.setParentOrgCode(orgVO.getpCode());
            storeEntity.setProjectType(StoreCommonConsts.YES);
            storeEntity.setState(StoreCommonConsts.YES);
            if (attrFlag.equals(0)) {
                storeEntity.setName(project.getProjectName() + "\u4e3b\u6750\u5e93");
            } else if (attrFlag.equals(1)) {
                storeEntity.setName(project.getProjectName() + "\u4e34\u5efa\u6750\u6599");
            } else if (attrFlag.equals(2)) {
                storeEntity.setName(project.getProjectName() + "\u7532\u4f9b\u6750");
            }
            storeEntity.setAttrFlag(attrFlag);
            storeEntity.setTotalMny(BigDecimal.ZERO);
            storeEntity.setMemo("\u81ea\u589e");
            this.saveOrUpdate((Object)storeEntity);
        } else {
            List storeEntities = this.list((Wrapper)queryWrapper);
            if (!storeEntities.isEmpty()) {
                storeEntity = (StoreEntity)((Object)storeEntities.get(0));
            }
        }
        return storeEntity;
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

