package com.ejianc.business.store.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.store.bean.CheckDetailEntity;
import com.ejianc.business.store.mapper.SettleMapper;
import com.ejianc.business.store.utils.CommonUtils;
import com.ejianc.business.store.vo.MaterialCategoryTopVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.store.bean.SettleEntity;
import com.ejianc.business.store.service.ISettleService;
import com.ejianc.business.store.vo.SettleVO;

/**
 * 废旧物资对账结算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settle")
public class SettleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STORE_SETTLE";//此处需要根据实际修改

    @Autowired
    private ISettleService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SettleMapper settleMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {

        SettleVO vo =service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
    	SettleEntity entity = service.selectById(id);
    	SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询上期累计值
     */
    @RequestMapping(value = "/getlastMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> getlastMny(Long projectId) {
        LambdaQueryWrapper<SettleEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId,projectId);
        lambdaQueryWrapper.in(SettleEntity::getBillState,1,3);
        List<SettleEntity> settleEntityList = service.list(lambdaQueryWrapper);
        BigDecimal currentSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(settleEntityList)){
            currentSettleMny = settleEntityList.stream().map(SettleEntity::getCurrentSettleMny)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        SettleVO settleVO = new SettleVO();
        settleVO.setLastSumSettleMny(currentSettleMny);
        return CommonResponse.success("查询详情数据成功！",settleVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()),true);
        service.deleteDisposeId(vos.stream().map(SettleVO::getId).collect(Collectors.toList()));

        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettleEntity> page = service.queryPage(param,false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettleEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<SettleVO> listvo = BeanMapper.mapList(list, SettleVO.class);
        listvo.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });

        beans.put("records", listvo);
        ExcelExport.getInstance().export("Settle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param,false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @ApiOperation("各单位每月废旧物资处置情况")
    @RequestMapping(value = "/querySettleOrgList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryTopVO>> querySettleOrgList(@RequestParam(value = "dateIn", defaultValue = "all") String dateIn,@RequestParam(value = "month", required = false) String month,
                                                                         @RequestParam(value = "orgId", required = false) Long orgId
    ) {
        String startDate = null;
        if ("thisYear".equals(dateIn)) {
            startDate = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.beginOfYear(new Date()));
        }
        //查询当前登录组织的innerCode
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(_orgId);
        if (!oneById.isSuccess()){
            throw new BusinessException("查询组织失败!");
        }
        OrgVO oneByIdData = oneById.getData();
        String innerCode = oneByIdData.getInnerCode(); // 查找第一个 "|" 的位置
        int index = innerCode.indexOf("|");

        String result;
        if (index != -1) {
            // 截取从开头到 "|" 之前的内容
            result = innerCode.substring(0, index);
        } else {
            // 如果没有找到 "|"，返回整个字符串（此处不会执行）
            result = innerCode;
        }

        CommonResponse<List<OrgVO>> directChildrenByPid = iOrgApi.getDirectChildrenByPid(Long.parseLong(result), null);
        CommonResponse<List<OrgVO>> orgListAll = iOrgApi.findChildrenByParentId(Long.parseLong(result));
        if (!orgListAll.isSuccess()){
            throw new BusinessException("获取本下组织数据失败!");
        }
        List<OrgVO> orgListAllData = orgListAll.getData();
        Map<Long, OrgVO> allOrgMap = orgListAllData.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

        if (!directChildrenByPid.isSuccess()){
            throw new BusinessException("查询直接下级失败!");
        }

        List<OrgVO> twoOrgList = directChildrenByPid.getData();
        //获取材料验收数据
        List<SettleVO> checkList = settleMapper.getSettleData(orgIdList,startDate,month);
        for (SettleVO checkVO : checkList){
            if (allOrgMap.containsKey(checkVO.getOrgId())){
                OrgVO orgVO = allOrgMap.get(checkVO.getOrgId());
                String innerCodeTwo =  orgVO.getInnerCode();
                String[] split = innerCodeTwo.split("\\|");
                String s = split[1];
                checkVO.setTwoOrgId(Long.parseLong(s));
            }
        }
        Map<Long, BigDecimal> mnyCheckMap = checkList.stream().collect(Collectors.groupingBy(SettleVO::getTwoOrgId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getCurrentSettleMny ()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal checkAllMny = checkList.stream().map(SettleVO::getCurrentSettleMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        List<MaterialCategoryTopVO> categoryTopVOList = new ArrayList<>();
        for (OrgVO orgVO : twoOrgList){
            MaterialCategoryTopVO materialCategoryTopVO = new MaterialCategoryTopVO();
            if (mnyCheckMap.containsKey(orgVO.getId())){
                BigDecimal bigDecimal = mnyCheckMap.get(orgVO.getId());
                materialCategoryTopVO.setAmount(bigDecimal);
                materialCategoryTopVO.setWeight(CommonUtils.calculateRate2(bigDecimal,checkAllMny));
            }
            materialCategoryTopVO.setMaterialCategoryName(orgVO.getName());
            categoryTopVOList.add(materialCategoryTopVO);
        }

        return CommonResponse.success("查询各类物资采购情况统计成功！", categoryTopVOList);
    }
    @ApiOperation("各项目本年度废旧物资处置情况")
    @RequestMapping(value = "/querySettleProjectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SettleVO>> querySettleProjectList(@RequestParam(value = "dateIn", defaultValue = "all") String dateIn,
                                                                         @RequestParam(value = "orgId", required = false) Long orgId
    ) {
        String startDate = null;
        if ("thisYear".equals(dateIn)) {
            startDate = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.beginOfYear(new Date()));
        }
        //查询当前登录组织的innerCode
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = iOrgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(_orgId);
        if (!oneById.isSuccess()){
            throw new BusinessException("查询组织失败!");
        }
        OrgVO oneByIdData = oneById.getData();
        String innerCode = oneByIdData.getInnerCode(); // 查找第一个 "|" 的位置
        int index = innerCode.indexOf("|");

        String result;
        if (index != -1) {
            // 截取从开头到 "|" 之前的内容
            result = innerCode.substring(0, index);
        } else {
            // 如果没有找到 "|"，返回整个字符串（此处不会执行）
            result = innerCode;
        }

        CommonResponse<List<OrgVO>> directChildrenByPid = iOrgApi.getDirectChildrenByPid(Long.parseLong(result), null);
        CommonResponse<List<OrgVO>> orgListAll = iOrgApi.findChildrenByParentId(Long.parseLong(result));
        if (!orgListAll.isSuccess()){
            throw new BusinessException("获取本下组织数据失败!");
        }
        if (!directChildrenByPid.isSuccess()){
            throw new BusinessException("查询直接下级失败!");
        }

        //获取材料验收数据
        List<SettleVO> checkList = settleMapper.getSettleProjectData(orgIdList,startDate);
        BigDecimal settleAllMny = checkList.stream().map(SettleVO::getSumSettleMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        for (SettleVO settleVO : checkList){
            settleVO.setWeight(CommonUtils.calculateRate2(settleVO.getSumSettleMny(),settleAllMny));
            }

        return CommonResponse.success("查询各类物资采购情况统计成功！", checkList);
    }
}
