package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.PickReturnDetailEntity;
import com.ejianc.business.store.bean.PickReturnEntity;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.controller.InOutController;
import com.ejianc.business.store.mapper.PickReturnMapper;
import com.ejianc.business.store.service.IPickReturnService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.utils.CommonUtils;
import com.ejianc.business.store.vo.InOutVO;
import com.ejianc.business.store.vo.PickReturnDetailVO;
import com.ejianc.business.store.vo.PickReturnVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料退库表
 * 
 * @author generator
 * 
 */
@Service("pickReturnService")
public class PickReturnServiceImpl extends BaseServiceImpl<PickReturnMapper, PickReturnEntity> implements IPickReturnService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PickReturnMapper pickReturnMapper;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_PICK_RETURN_CODE";//此处需要根据实际修改


    @Autowired
    private StoreManageService storeManageService;

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPickReturnService service;
    @Autowired
    private InOutController inOutController;

    /**
     * 根据合同id 查询当前合同是否有未生效单据
     * @param contractId
     * @return
     */
    @Override
    public PickReturnVO queryByContractId(Long contractId) {
        PickReturnVO resp = null;
        QueryWrapper<PickReturnEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PickReturnEntity entity = pickReturnMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PickReturnVO.class);
        }
        return resp;
    }

    @Override
    public void removeByPickReturnIds(List<Long> ids) {

        this.removeByIds(ids,true);
    }

    @Override
    public CommonResponse<PickReturnVO> pushCost(PickReturnVO pickReturnVO) {
        PickReturnEntity pickReturnEntity = baseMapper.selectById(pickReturnVO.getId());
        if(CollectionUtils.isNotEmpty(pickReturnVO.getPickReturnDetailList())){
            List<PickReturnDetailEntity> pickReturnDetailEntities = BeanMapper.mapList(pickReturnVO.getPickReturnDetailList(), PickReturnDetailEntity.class);
            pickReturnEntity.setPickReturnDetailList(pickReturnDetailEntities);
        }
        super.saveOrUpdate(pickReturnEntity, false);
        //推送数据
        this.costPush(pickReturnEntity);
        return CommonResponse.success(BeanMapper.map(pickReturnEntity,PickReturnVO.class));
    }

    @Override
    public void costPush(PickReturnEntity pickReturnEntity) {
        logger.info("开始costPush");
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        String newRelationFlag = "1";
        if(CollectionUtils.isNotEmpty(pickReturnDetailList)){
            for (PickReturnDetailEntity entity : pickReturnDetailList){
//                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                if (null == entity.getSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(pickReturnDetailList)) {
            newRelationFlag = "0";
        }
        // 全部挂接成本科目才推送实际成本
        if("1".equals(newRelationFlag)){
            //实际成本先删后增
            saveCost(pickReturnEntity,1);
        }
        //更新是否关联
        LambdaUpdateWrapper<PickReturnEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PickReturnEntity::getId,pickReturnEntity.getId());
        updateWrapper.set(PickReturnEntity::getRelationFlag, newRelationFlag);
        super.update(updateWrapper);



    }

    @Override
    public PickReturnVO saveOrUpdate(PickReturnVO saveOrUpdateVO) {
        PickReturnVO voByContract = service.queryByContractId(saveOrUpdateVO.getContractId());
        if(null != voByContract && (null == saveOrUpdateVO.getId() || !voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该合同下存在未生效单据，请勿重复添加！");
        }
        List<Long> inOutIds = saveOrUpdateVO.getPickReturnDetailList().stream().map(x->x.getInOutId()).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(inOutIds)){
            JSONObject condition = new JSONObject();
            condition.put("inOutIds", inOutIds);
            CommonResponse<IPage<InOutVO>> resp = inOutController.refInOutData(1, 1000, condition.toJSONString(), "", "");
            if(!resp.isSuccess() || null == resp.getData()){
                throw new BusinessException("获取最新数量失败！");
            }
            List<InOutVO> records = resp.getData().getRecords();
            Map<Long, InOutVO> inOutMap = records.stream().collect(Collectors.toMap(x->x.getId(), x->x, (v1, v2)->v2));
            for (PickReturnDetailVO detail : saveOrUpdateVO.getPickReturnDetailList()) {
                BigDecimal surplusNum = BigDecimal.ZERO;
                if(inOutMap.containsKey(detail.getInOutId())){
                    surplusNum = inOutMap.get(detail.getInOutId()).getSurplusReturnStoreNum();
                }
                if (ComputeUtil.isGreaterThan(detail.getReturnNum(), surplusNum)){
                    throw new BusinessException("物资[名称：" + detail.getMaterialName() + "，规格：" + detail.getMaterialSpec() + "]，库存余量：" + ComputeUtil.scaleStripTrailingZeros(surplusNum, 4) + "，库存不足!");
                }
            }
        }
        PickReturnEntity entity = BeanMapper.map(saveOrUpdateVO, PickReturnEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PickReturnVO vo = BeanMapper.map(entity, PickReturnVO.class);

//        //推送实际成本
//        saveCost(entity,0);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(PickReturnVO pickReturnVO) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        //--成本科目-目标成本控制
        CostCtrlVO costCtrlVO = this.sjCost(pickReturnVO);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }

        //------end有合同预警域
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    /**
     *成本科目目标成本控制
     *
     */
    public CostCtrlVO sjCost(PickReturnVO vo){


        List<PickReturnDetailVO> pickReturnDetailList = vo.getPickReturnDetailList();
        if(CollectionUtils.isNotEmpty(pickReturnDetailList)){
            Map<Long,CostCtrlDetailVO> map = new HashMap<>();
            for(PickReturnDetailVO pickReturnDetailVO:pickReturnDetailList){
                if(null!=pickReturnDetailVO.getSubjectId()&&!"del".equals(pickReturnDetailVO.getRowState())){
                    BigDecimal detailMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getMny());
                    BigDecimal detailTaxMny = CommonUtils.setBigDecimalDefaultValue(pickReturnDetailVO.getTaxMny());
                    if(map.containsKey(pickReturnDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(pickReturnDetailVO.getSubjectId());
                        BigDecimal mny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getMny());
                        BigDecimal taxMny = CommonUtils.setBigDecimalDefaultValue(costCtrlDetailVO.getTaxMny());
                        costCtrlDetailVO.setMny(mny.add(detailMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(detailTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(pickReturnDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(detailMny);
                        costCtrlDetailVO.setTaxMny(detailTaxMny);
                        map.put(pickReturnDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }

            if(null!=map && !map.isEmpty()){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }

    private void saveCost(PickReturnEntity pickReturnEntity,Integer effectiveStatus){
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<PickReturnDetailEntity> pickReturnDetailList = pickReturnEntity.getPickReturnDetailList();
        if(CollectionUtils.isNotEmpty(pickReturnDetailList)){
            //根据物资id查询物资编码
            List<Long> materialIds = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));

            for (PickReturnDetailEntity entity : pickReturnDetailList) {
                //推送成本 过滤掉甲供材
                if(StoreAttrEnum.SELFPURCHASE.getCode().equals(String.valueOf(entity.getAttrFlag()))){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(entity.getSubjectId());
                    costDetailVO.setSubjectCode(entity.getSubjectCode());
                    costDetailVO.setSubjectName(entity.getSubjectName());
                    costDetailVO.setWbsId(entity.getWbsId());
                    costDetailVO.setWbsCode(entity.getWbsCode());
                    costDetailVO.setWbsName(entity.getWbsName());
                    costDetailVO.setSourceId(entity.getInstoreId());
                    costDetailVO.setSourceDetailId(entity.getId());
                    costDetailVO.setHappenTaxMny(ComputeUtil.convertToMinusNumber(entity.getTaxMny()));
                    costDetailVO.setHappenMny(ComputeUtil.convertToMinusNumber(entity.getMny()));
                    costDetailVO.setNum(ComputeUtil.convertToMinusNumber(entity.getReturnNum()));//退库数量
                    costDetailVO.setHappenDate(pickReturnEntity.getInstoreDate());
                    costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                    costDetailVO.setSourceType("STORE_PICKRETURN");
                    costDetailVO.setSourceTabType("STORE_PICKRETURN_SUB");
                    costDetailVO.setProjectId(pickReturnEntity.getProjectId());
                    costDetailVO.setSourceBillCode(pickReturnEntity.getBillCode()); //填充自己的单据编号
                    costDetailVO.setSourceBillName(SourceTypeEnum.材料退库.getTypeName());//填充枚举里  自己的单据名称
                    costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/pickReturn/card?id="+pickReturnEntity.getId());//需要跳转路径与参数组成的全路径
                    //2022-8-16新增传输字段
                    costDetailVO.setMaterialId(entity.getMaterialId());
                    costDetailVO.setMaterialName(entity.getMaterialName());
                    costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                    costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                    costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                    costDetailVO.setUnitId(entity.getMaterialUnitId());
                    costDetailVO.setUnit(entity.getMaterialUnitName());
                    costDetailVO.setSpec(entity.getMaterialSpec());
                    costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                    costDetailVOList.add(costDetailVO);
                }
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
                //推送前汇总子表自购材物资的含税无税金额到主表
                /*BigDecimal totalSelfTaxMny = pickReturnDetailList.stream().map(PickReturnDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalSelfMny = pickReturnDetailList.stream().map(PickReturnDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                UpdateWrapper<PickReturnEntity> wrapper = new UpdateWrapper<>();
                wrapper.set("total_self_tax_mny",totalSelfTaxMny);
                wrapper.set("total_self_mny",totalSelfMny);
                wrapper.eq("id",pickReturnEntity.getId());
                this.update(wrapper);*/
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }


    }


}
