/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.SettleEntity;
import com.ejianc.business.store.mapper.SettleMapper;
import com.ejianc.business.store.service.ISettleService;
import com.ejianc.business.store.utils.CommonUtils;
import com.ejianc.business.store.vo.MaterialCategoryTopVO;
import com.ejianc.business.store.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_SETTLE";
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private SettleMapper settleMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getlastMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> getlastMny(Long projectId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.in(SettleEntity::getBillState, new Object[]{1, 3});
        List settleEntityList = this.service.list((Wrapper)lambdaQueryWrapper);
        BigDecimal currentSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)settleEntityList)) {
            currentSettleMny = settleEntityList.stream().map(SettleEntity::getCurrentSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        SettleVO settleVO = new SettleVO();
        settleVO.setLastSumSettleMny(currentSettleMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)settleVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO settleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.service.deleteDisposeId(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Object orgVOList = null;
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List listvo = BeanMapper.mapList((Iterable)list, SettleVO.class);
        listvo.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", listvo);
        ExcelExport.getInstance().export("Settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5404\u5355\u4f4d\u6bcf\u6708\u5e9f\u65e7\u7269\u8d44\u5904\u7f6e\u60c5\u51b5")
    @RequestMapping(value={"/querySettleOrgList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryTopVO>> querySettleOrgList(@RequestParam(value="dateIn", defaultValue="all") String dateIn, @RequestParam(value="month", required=false) String month, @RequestParam(value="orgId", required=false) Long orgId) {
        String startDate = null;
        if ("thisYear".equals(dateIn)) {
            startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        }
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = ((List)this.iOrgApi.findChildrenByParentId(_orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse oneById = this.iOrgApi.getOneById(_orgId);
        if (!oneById.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25!");
        }
        OrgVO oneByIdData = (OrgVO)oneById.getData();
        String innerCode = oneByIdData.getInnerCode();
        int index = innerCode.indexOf("|");
        String result = index != -1 ? innerCode.substring(0, index) : innerCode;
        CommonResponse directChildrenByPid = this.iOrgApi.getDirectChildrenByPid(Long.valueOf(Long.parseLong(result)), null);
        CommonResponse orgListAll = this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(result)));
        if (!orgListAll.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u672c\u4e0b\u7ec4\u7ec7\u6570\u636e\u5931\u8d25!");
        }
        List orgListAllData = (List)orgListAll.getData();
        Map allOrgMap = orgListAllData.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        if (!directChildrenByPid.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u76f4\u63a5\u4e0b\u7ea7\u5931\u8d25!");
        }
        List twoOrgList = (List)directChildrenByPid.getData();
        List<SettleVO> checkList = this.settleMapper.getSettleData(orgIdList, startDate, month);
        for (SettleVO checkVO : checkList) {
            if (!allOrgMap.containsKey(checkVO.getOrgId())) continue;
            OrgVO orgVO = (OrgVO)allOrgMap.get(checkVO.getOrgId());
            String innerCodeTwo = orgVO.getInnerCode();
            String[] split = innerCodeTwo.split("\\|");
            String s = split[1];
            checkVO.setTwoOrgId(Long.valueOf(Long.parseLong(s)));
        }
        Map<Long, BigDecimal> mnyCheckMap = checkList.stream().collect(Collectors.groupingBy(SettleVO::getTwoOrgId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getCurrentSettleMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal checkAllMny = checkList.stream().map(SettleVO::getCurrentSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<MaterialCategoryTopVO> categoryTopVOList = new ArrayList<MaterialCategoryTopVO>();
        for (OrgVO orgVO : twoOrgList) {
            MaterialCategoryTopVO materialCategoryTopVO = new MaterialCategoryTopVO();
            if (mnyCheckMap.containsKey(orgVO.getId())) {
                BigDecimal bigDecimal = mnyCheckMap.get(orgVO.getId());
                materialCategoryTopVO.setAmount(bigDecimal);
                materialCategoryTopVO.setWeight(CommonUtils.calculateRate2(bigDecimal, checkAllMny));
            }
            materialCategoryTopVO.setMaterialCategoryName(orgVO.getName());
            categoryTopVOList.add(materialCategoryTopVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5404\u7c7b\u7269\u8d44\u91c7\u8d2d\u60c5\u51b5\u7edf\u8ba1\u6210\u529f\uff01", categoryTopVOList);
    }

    @ApiOperation(value="\u5404\u9879\u76ee\u672c\u5e74\u5ea6\u5e9f\u65e7\u7269\u8d44\u5904\u7f6e\u60c5\u51b5")
    @RequestMapping(value={"/querySettleProjectList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SettleVO>> querySettleProjectList(@RequestParam(value="dateIn", defaultValue="all") String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        String startDate = null;
        if ("thisYear".equals(dateIn)) {
            startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        }
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = ((List)this.iOrgApi.findChildrenByParentId(_orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse oneById = this.iOrgApi.getOneById(_orgId);
        if (!oneById.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25!");
        }
        OrgVO oneByIdData = (OrgVO)oneById.getData();
        String innerCode = oneByIdData.getInnerCode();
        int index = innerCode.indexOf("|");
        String result = index != -1 ? innerCode.substring(0, index) : innerCode;
        CommonResponse directChildrenByPid = this.iOrgApi.getDirectChildrenByPid(Long.valueOf(Long.parseLong(result)), null);
        CommonResponse orgListAll = this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(result)));
        if (!orgListAll.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u672c\u4e0b\u7ec4\u7ec7\u6570\u636e\u5931\u8d25!");
        }
        if (!directChildrenByPid.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u76f4\u63a5\u4e0b\u7ea7\u5931\u8d25!");
        }
        List<SettleVO> checkList = this.settleMapper.getSettleProjectData(orgIdList, startDate);
        BigDecimal settleAllMny = checkList.stream().map(SettleVO::getSumSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (SettleVO settleVO : checkList) {
            settleVO.setWeight(CommonUtils.calculateRate2(settleVO.getSumSettleMny(), settleAllMny));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5404\u7c7b\u7269\u8d44\u91c7\u8d2d\u60c5\u51b5\u7edf\u8ba1\u6210\u529f\uff01", checkList);
    }
}

