package com.ejianc.business.store.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.store.bean.AllotOutEntity;
import com.ejianc.business.store.service.IAllotOutService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.store.bean.AllotSettleEntity;
import com.ejianc.business.store.service.IAllotSettleService;
import com.ejianc.business.store.vo.AllotSettleVO;

/**
 * 调拨结算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("allotSettle")
public class AllotSettleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DBJS_CODE";//此处需要根据实际修改

    @Autowired
    private IAllotSettleService service;

    @Autowired
    private IAllotOutService allotOutService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotSettleVO> saveOrUpdate(@RequestBody AllotSettleVO saveOrUpdateVO) {
    	AllotSettleEntity entity = BeanMapper.map(saveOrUpdateVO, AllotSettleEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
        //占用对应的 调拨出库单
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotSettleDetailList())){
            Set<Long> delIds = new HashSet<>();
            Set<Long> addIds = new HashSet<>();
            saveOrUpdateVO.getAllotSettleDetailList().forEach(e->{
                if("del".equals(e.getRowState())){
                    delIds.add(e.getSourceId());
                }else{
                    addIds.add(e.getSourceId());
                }
            });
            if(CollectionUtils.isNotEmpty(addIds)){
                LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(AllotOutEntity::getId, addIds);
                updateWrapper.set(AllotOutEntity::getSettleFlag, 1);//结算状态改为已结算
                allotOutService.update(updateWrapper);
            }
            if(CollectionUtils.isNotEmpty(delIds)){
                LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(AllotOutEntity::getId, delIds);
                updateWrapper.set(AllotOutEntity::getSettleFlag, 0);//结算状态改为未结算
                allotOutService.update(updateWrapper);
            }

        }
    	AllotSettleVO vo = BeanMapper.map(entity, AllotSettleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotSettleVO> queryDetail(Long id) {
    	AllotSettleEntity entity = service.selectById(id);
    	AllotSettleVO vo = BeanMapper.map(entity, AllotSettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotSettleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AllotSettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                //释放对应的 调拨出库单
                AllotSettleEntity entity = service.selectById(vo.getId());
                if(CollectionUtils.isNotEmpty(entity.getAllotSettleDetailList())){
                    Set<Long> ids = new HashSet<>();
                    entity.getAllotSettleDetailList().forEach(e->{
                        ids.add(e.getSourceId());
                    });
                    LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(AllotOutEntity::getId,ids);
                    updateWrapper.set(AllotOutEntity::getSettleFlag, 0);//结算状态改为未结算
                    allotOutService.update(updateWrapper);
                }
            }
        }
        service.removeByIds(vos.stream().map(AllotSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AllotSettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("inParentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<AllotSettleEntity> page = service.queryPage(param,false);
        IPage<AllotSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotSettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("inParentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotSettleEntity> list = service.queryList(param);
        List<AllotSettleVO> listvo = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            listvo = BeanMapper.mapList(list, AllotSettleVO.class);
            listvo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listvo);
        ExcelExport.getInstance().export("AllotSettle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refAllotSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AllotSettleVO>> refAllotSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AllotSettleEntity> page = service.queryPage(param,false);
        IPage<AllotSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotSettleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
