/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.bean.SettleEntity;
import com.ejianc.business.store.mapper.SettleMapper;
import com.ejianc.business.store.service.IDisposeService;
import com.ejianc.business.store.service.ISettleService;
import com.ejianc.business.store.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IDisposeService disposeService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_SETTLE";

    @Override
    public void updateDispose(Long settleId, List<Long> disposeIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(DisposeEntity::getSettleId, (Object)settleId);
        wrapper.set(DisposeEntity::getSettleId, null);
        wrapper.set(DisposeEntity::getUseFlag, (Object)0);
        this.disposeService.update((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(disposeIds)) {
            disposeIds.forEach(e -> {
                LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                lambda.eq(BaseEntity::getId, e);
                lambda.set(DisposeEntity::getSettleId, (Object)settleId);
                lambda.set(DisposeEntity::getUseFlag, (Object)1);
                this.disposeService.update((Wrapper)lambda);
            });
        }
    }

    @Override
    @Transactional
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        this.updateDispose(entity.getId(), saveOrUpdateVO.getDisposeIds());
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return vo;
    }

    @Override
    public void deleteDisposeId(List<Long> settleIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(DisposeEntity::getSettleId, settleIds);
        wrapper.set(DisposeEntity::getSettleId, null);
        wrapper.set(DisposeEntity::getUseFlag, (Object)0);
        this.disposeService.update((Wrapper)wrapper);
    }
}

