package com.ejianc.business.store.controller.desktop;

import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.vo.MaterialCategoryTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 统计
 * @date 2022/4/26
 */
@Api(value = "仓库桌面", tags = {"仓库桌面"})
@RestController
@RequestMapping("storeDesktop")
public class StoreDesktopController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IFlowService flowService;


    @ApiOperation("消耗材TOP5")
    @RequestMapping(value = "/queryMaterialCategoryTopN", method = RequestMethod.GET)
    public CommonResponse<List<MaterialCategoryTopVO>> queryMaterialCategoryTopN(@RequestParam(value = "topN", defaultValue = "5") Integer topN,
                                                                                 @RequestParam(value = "dateIn", defaultValue = "all") String dateIn,
                                                                                 @RequestParam(value = "orgId", required = false) Long orgId
    ) {

        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List<Long> orgIdList = orgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        List<MaterialCategoryTopVO> top5List = flowService.queryMaterialCategoryTopN(topN, dateIn, orgIdList);
        return CommonResponse.success("查询消耗材TOP5成功！", top5List);
    }


}
