package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.store.bean.ProcurementDetailEntoryEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 废旧物资采购申请主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_material_procurement")
public class ProcurementEntoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="check_member_id")
    private Long checkMemberId; // 采购员ID
    @TableField(value="plan_name")
    private String planName; // 计划名称
    @TableField(value="check_member")
    private String checkMember; // 采购员
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="check_date")
    private Date checkDate; // 计划需求日期
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="handle_comment")
    private String handleComment; // 备注

    public String getHandleComment() {
        return handleComment;
    }

    public void setHandleComment(String handleComment) {
        this.handleComment = handleComment;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="procurementDetailEntoryService", pidName="mid")
    private List<ProcurementDetailEntoryEntity> procurementDetailEntoryList = new ArrayList<>(); // 废旧物资采购申请子表
    

    public Long getCheckMemberId() {
        return checkMemberId;
    }

    public void setCheckMemberId(Long checkMemberId) {
        this.checkMemberId = checkMemberId;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getCheckMember() {
        return checkMember;
    }

    public void setCheckMember(String checkMember) {
        this.checkMember = checkMember;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    

    public List<ProcurementDetailEntoryEntity> getProcurementDetailEntoryList() {
        return procurementDetailEntoryList;
    }

    public void setProcurementDetailEntoryList(List<ProcurementDetailEntoryEntity> procurementDetailEntoryList) {
        this.procurementDetailEntoryList = procurementDetailEntoryList;
    }
}
