/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.ApplyDetailEntity;
import com.ejianc.business.store.bean.ApplyEntity;
import com.ejianc.business.store.bean.DisposeDetailEntity;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.mapper.DisposeMapper;
import com.ejianc.business.store.service.IApplyDetailService;
import com.ejianc.business.store.service.IApplyService;
import com.ejianc.business.store.service.IDisposeDetailService;
import com.ejianc.business.store.service.IDisposeService;
import com.ejianc.business.store.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="disposeService")
public class DisposeServiceImpl
extends BaseServiceImpl<DisposeMapper, DisposeEntity>
implements IDisposeService {
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IApplyService applyService;
    @Autowired
    private IDisposeDetailService detailService;
    @Autowired
    private IApplyDetailService applyDetailService;

    @Override
    public void updateApply(Long disposeId, List<Long> applyIds) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ApplyEntity::getDisposeId, (Object)disposeId);
        wrapper.set(ApplyEntity::getDisposeId, null);
        wrapper.set(ApplyEntity::getUseFlag, (Object)0);
        this.applyService.update((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty(applyIds)) {
            LambdaUpdateWrapper lw = new LambdaUpdateWrapper();
            lw.in(BaseEntity::getId, applyIds);
            lw.set(ApplyEntity::getDisposeId, (Object)disposeId);
            lw.set(ApplyEntity::getUseFlag, (Object)1);
            this.applyService.update((Wrapper)lw);
        }
    }

    @Override
    public JSONObject disposeReport(QueryParam param) {
        JSONObject page = new JSONObject();
        page.put("current", (Object)("" + param.getPageIndex()));
        page.put("size", (Object)("" + param.getPageSize()));
        page.put("records", new ArrayList());
        page.put("total", (Object)"0");
        page.put("pages", (Object)"0");
        LinkedHashMap orderMap = param.getOrderMap();
        String order = "desc";
        if (orderMap.containsKey("applyDate")) {
            order = (String)orderMap.get("applyDate");
            orderMap.remove("applyDate");
        }
        QueryParam queryParam = new QueryParam();
        Map<String, Parameter> params = DisposeServiceImpl.transferParams(param.getParams(), "applyDate", "orgName", "projectName", "supplierName", "employeeName");
        queryParam.setParams(params);
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return page;
        }
        Map<Long, DisposeEntity> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        param.getParams().put("mid", new Parameter("in", new ArrayList<Long>(map.keySet())));
        IPage pageData = this.detailService.queryPage(param);
        List detailList = pageData.getRecords();
        page.put("current", (Object)("" + pageData.getCurrent()));
        page.put("size", (Object)("" + pageData.getSize()));
        page.put("records", (Object)pageData.getRecords());
        page.put("total", (Object)("" + pageData.getTotal()));
        page.put("pages", (Object)("" + pageData.getPages()));
        Map<Object, Object> applyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List ids = detailList.stream().map(x -> x.getApplyDetailId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            QueryParam dParam = new QueryParam();
            dParam.getParams().put("id", new Parameter("in", ids));
            List applyList = this.applyDetailService.queryList(dParam);
            applyMap = applyList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        }
        JSONArray array = new JSONArray();
        for (DisposeDetailEntity detail : detailList) {
            DisposeEntity entity = map.get(detail.getMid());
            JSONObject obj = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)detail)));
            obj.put("orgName", (Object)entity.getOrgName());
            obj.put("projectName", (Object)entity.getProjectName());
            obj.put("supplierName", (Object)entity.getSupplierName());
            obj.put("applyDate", (Object)DateUtil.formatDate(entity.getApplyDate()));
            obj.put("employeeName", (Object)entity.getEmployeeName());
            obj.put("mobilePhone", (Object)this.getMobileByUserId(entity.getEmployeeId()));
            if (applyMap.containsKey(detail.getApplyDetailId())) {
                obj.put("definitionType", (Object)((ApplyDetailEntity)((Object)applyMap.get(detail.getApplyDetailId()))).getDefinitionType());
                obj.put("applyNum", (Object)((ApplyDetailEntity)((Object)applyMap.get(detail.getApplyDetailId()))).getCheckNum());
            }
            array.add((Object)obj);
        }
        array = "asc".equals(order) ? array.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getString("applyDate"))).collect(Collectors.toCollection(JSONArray::new)) : array.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getString("applyDate")).reversed()).collect(Collectors.toCollection(JSONArray::new));
        page.put("records", (Object)array);
        return page;
    }

    private static Map<String, Parameter> transferParams(Map<String, Parameter> params, String ... fields) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        if (null == params) {
            return map;
        }
        for (String field : fields) {
            if (!params.containsKey(field)) continue;
            map.put(field, params.get(field));
            params.remove(field);
        }
        return map;
    }

    private String getMobileByUserId(Long userId) {
        try {
            MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
            if (userId != null && StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) {
                String cacheKey = "refer_cache_key:idm-employee:" + userId;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                if (cacheValue != null) {
                    JSONArray jsonArray = JSONArray.parseArray((String)cacheValue.toString());
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonArray.get(0).toString());
                    return jsonObject.getString("mobilePhone");
                }
                CommonResponse resp = this.employeeApi.queryEmployeByUserId(userId);
                if (resp.isSuccess()) {
                    return ((EmployeeVO)resp.getData()).getMobilePhone();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

