package com.ejianc.business.sub.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 分包签证单
 * 
 * @author generator
 * 
 */
public class CertificateVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long contractId; // 分包合同名称id
    private String contractName; // 分包合同名称
    private Long supplierId; // 分包供应商id
    private String supplierName; // 分包供应商
    private Long projectId; // 项目名称id
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long projectManagerId; // 项目经理id
    private String projectManagerName; // 项目经理
    private Long costResponsibleId; // 成本中心项目负责人id
    private String costResponsibleName; // 成本中心项目负责人
    private Long businessResponsibleId; // 商务部负责人id
    private String businessResponsibleName; // 商务部负责人
    private Long projectDirectorId; // 项目总监id
    private String projectDirectorName; // 项目总监
    private Long middlebrowId; // 中台
    private String middlebrowName; // 中台
    private Long subResponsibleId; // 分包单位负责人id
    private String subResponsibleName; // 分包单位负责人
    private Long applyUserId; // 申请人id
    private String applyUserName; // 申请人
    private Long applyDepartId; // 申请部门id
    private String applyDepartName; // 申请部门
    private String title; // 主题
    private String applyMemo; // 申请说明
    private String opinionMemo; // 申请说明
    private String visaNumber; // 签证编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate; // 根据项目部
    private String cause; // 原因
    private String area; // 区域
    private String matter; // 事项
    private BigDecimal mny; // 签证金额
    private BigDecimal affirmMny; // 确认金额
    private Integer incomeFlag; // 是否有收入：0、否； 1、是
    private Integer certificateStatus; // 对外是否有签证 0:已办理,1:待办理,2:无法办理
    private String sunkCost; // 0：设计、1：成本、2：采购、3：项目部
    private String adjustmentCause; // 调整原因
    private Integer imgFlag; // 影像资料是否上传：0、否； 1、是
    private String imgFlagStr; // 影像资料是否上传：0、否； 1、是
    private String billStateName;
    private Long certificateId; //  对外签证id
    private String certificateName; //  对外签证name
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completeDate; // 完成时间
    private Integer settleFlag; // 是否被结算引用：0、否； 1、是
    private Long majorId; // 专业  自定义档案：sub-major	分包专业
    private String majorName; // 专业名称
    private BigDecimal contractMny; // 合同金额
    private String purchaseType;
    private BigDecimal certificateMny;//对外签证金额
    private String certificateStatusStr;

    @TableField(value="certificate_type_id")
    private Long certificateTypeId;//签证类别
    @TableField(value="certificate_type_name")
    private String certificateTypeName;//签证类别

    private String projectCode; // 项目编码

    // 2025-03-06 添加字段 设计负责人 成本负责人 采购负责人 项目部负责人
    private String designPerson; // 设计责任人
    private String costPerson; // 成本负责人
    private String purchasePerson; // 采购负责人
    private String projectPerson; // 项目部负责人
    private BigDecimal designMny; // 设计确认金额
    private BigDecimal costMny; // 成本确认金额
    private BigDecimal purchaseMny; // 采购确认金额
    private BigDecimal projectMny; // 项目部 确认金额
    private String designReason; // 设计调整原因
    private String costReason; // 成本调整原因
    private String purchaseReason; // 采购调整原因
    private String projectReason; // 项目部调整原因

    // 2025-03-31 添加字段
    private String sunkCostNew;
    private String laborSubOmissionReason;
    private String laborSubOmissionPerson;
    private BigDecimal laborSubOmissionMny;
    private String drawingOmissionReason;
    private String drawingOmissionPerson;
    private BigDecimal drawingOmissionMny;
    private String withoutProceduresReason;
    private String withoutProceduresPerson;
    private BigDecimal withoutProceduresMny;
    private String instructionImpactReason;
    private String instructionImpactPerson;
    private BigDecimal instructionImpactMny;
    private String mgtIssuesReason;
    private String mgtIssuesPerson;
    private BigDecimal mgtIssuesMny;

    // 2025-8-12 新增
    private String projectManagerIsDeduction; // 是否扣款项目经理
    private String projectManagerMemo; // 备注项目经理
    private String projectLeaderIsDeduction; // 是否扣款项目负责人
    private String projectLeaderMemo; // 备注项目负责人

    private List<CertificateDeductionVO> certificateDeductionList = new ArrayList<>(); // 分包签证单-扣款详情


    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }


    public String getCertificateTypeName() {
        return certificateTypeName;
    }

    public void setCertificateTypeName(String certificateTypeName) {
        this.certificateTypeName = certificateTypeName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCertificateTypeId() {
        return certificateTypeId;
    }
    @ReferDeserialTransfer
    public void setCertificateTypeId(Long certificateTypeId) {
        this.certificateTypeId = certificateTypeId;
    }

    public String getCertificateStatusStr() {
        return certificateStatusStr;
    }

    public void setCertificateStatusStr(String certificateStatusStr) {
        this.certificateStatusStr = certificateStatusStr;
    }

    public BigDecimal getCertificateMny() {
        return certificateMny;
    }

    public void setCertificateMny(BigDecimal certificateMny) {
        this.certificateMny = certificateMny;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getMajorId() {
        return majorId;
    }
    @ReferDeserialTransfer
    public void setMajorId(Long majorId) {
        this.majorId = majorId;
    }

    public String getMajorName() {
        return majorName;
    }

    public void setMajorName(String majorName) {
        this.majorName = majorName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Date getCompleteDate() {
        return completeDate;
    }

    public void setCompleteDate(Date completeDate) {
        this.completeDate = completeDate;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }
    @ReferSerialTransfer(referCode="cost-claim")
    public Long getCertificateId() {
        return certificateId;
    }
    @ReferDeserialTransfer
    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getImgFlagStr() {
        return imgFlagStr;
    }

    public void setImgFlagStr(String imgFlagStr) {
        this.imgFlagStr = imgFlagStr;
    }

    public Integer getImgFlag() {
        return imgFlag;
    }

    public void setImgFlag(Integer imgFlag) {
        this.imgFlag = imgFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCostResponsibleId() {
        return costResponsibleId;
    }
    @ReferDeserialTransfer
    public void setCostResponsibleId(Long costResponsibleId) {
        this.costResponsibleId = costResponsibleId;
    }
    public String getCostResponsibleName() {
        return costResponsibleName;
    }
    public void setCostResponsibleName(String costResponsibleName) {
        this.costResponsibleName = costResponsibleName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getBusinessResponsibleId() {
        return businessResponsibleId;
    }
    @ReferDeserialTransfer
    public void setBusinessResponsibleId(Long businessResponsibleId) {
        this.businessResponsibleId = businessResponsibleId;
    }

    public String getBusinessResponsibleName() {
        return businessResponsibleName;
    }

    public void setBusinessResponsibleName(String businessResponsibleName) {
        this.businessResponsibleName = businessResponsibleName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectDirectorId() {
        return projectDirectorId;
    }
    @ReferDeserialTransfer
    public void setProjectDirectorId(Long projectDirectorId) {
        this.projectDirectorId = projectDirectorId;
    }
    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMiddlebrowId() {
        return middlebrowId;
    }
    @ReferDeserialTransfer
    public void setMiddlebrowId(Long middlebrowId) {
        this.middlebrowId = middlebrowId;
    }
    public String getMiddlebrowName() {
        return middlebrowName;
    }

    public void setMiddlebrowName(String middlebrowName) {
        this.middlebrowName = middlebrowName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSubResponsibleId() {
        return subResponsibleId;
    }
    @ReferDeserialTransfer
    public void setSubResponsibleId(Long subResponsibleId) {
        this.subResponsibleId = subResponsibleId;
    }
    public String getSubResponsibleName() {
        return subResponsibleName;
    }

    public void setSubResponsibleName(String subResponsibleName) {
        this.subResponsibleName = subResponsibleName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }
    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Long getApplyDepartId() {
        return applyDepartId;
    }

    public void setApplyDepartId(Long applyDepartId) {
        this.applyDepartId = applyDepartId;
    }
    public String getApplyDepartName() {
        return applyDepartName;
    }

    public void setApplyDepartName(String applyDepartName) {
        this.applyDepartName = applyDepartName;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getApplyMemo() {
        return applyMemo;
    }

    public void setApplyMemo(String applyMemo) {
        this.applyMemo = applyMemo;
    }
    public String getOpinionMemo() {
        return opinionMemo;
    }

    public void setOpinionMemo(String opinionMemo) {
        this.opinionMemo = opinionMemo;
    }
    public Date getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }
    public String getCause() {
        return cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getMatter() {
        return matter;
    }

    public void setMatter(String matter) {
        this.matter = matter;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getAffirmMny() {
        return affirmMny;
    }

    public void setAffirmMny(BigDecimal affirmMny) {
        this.affirmMny = affirmMny;
    }
    public Integer getIncomeFlag() {
        return incomeFlag;
    }

    public void setIncomeFlag(Integer incomeFlag) {
        this.incomeFlag = incomeFlag;
    }
    public Integer getCertificateStatus() {
        return certificateStatus;
    }

    public void setCertificateStatus(Integer certificateStatus) {
        this.certificateStatus = certificateStatus;
    }
    public String getSunkCost() {
        return sunkCost;
    }

    public void setSunkCost(String sunkCost) {
        this.sunkCost = sunkCost;
    }
    public String getAdjustmentCause() {
        return adjustmentCause;
    }

    public void setAdjustmentCause(String adjustmentCause) {
        this.adjustmentCause = adjustmentCause;
    }

    public String getDesignPerson() {
        return designPerson;
    }

    public void setDesignPerson(String designPerson) {
        this.designPerson = designPerson;
    }

    public String getCostPerson() {
        return costPerson;
    }

    public void setCostPerson(String costPerson) {
        this.costPerson = costPerson;
    }

    public String getPurchasePerson() {
        return purchasePerson;
    }

    public void setPurchasePerson(String purchasePerson) {
        this.purchasePerson = purchasePerson;
    }

    public String getProjectPerson() {
        return projectPerson;
    }

    public void setProjectPerson(String projectPerson) {
        this.projectPerson = projectPerson;
    }

    public BigDecimal getDesignMny() {
        return designMny;
    }

    public void setDesignMny(BigDecimal designMny) {
        this.designMny = designMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }

    public BigDecimal getProjectMny() {
        return projectMny;
    }

    public void setProjectMny(BigDecimal projectMny) {
        this.projectMny = projectMny;
    }

    public String getDesignReason() {
        return designReason;
    }

    public void setDesignReason(String designReason) {
        this.designReason = designReason;
    }

    public String getCostReason() {
        return costReason;
    }

    public void setCostReason(String costReason) {
        this.costReason = costReason;
    }

    public String getPurchaseReason() {
        return purchaseReason;
    }

    public void setPurchaseReason(String purchaseReason) {
        this.purchaseReason = purchaseReason;
    }

    public String getProjectReason() {
        return projectReason;
    }

    public void setProjectReason(String projectReason) {
        this.projectReason = projectReason;
    }

    public String getVisaNumber() {
        return visaNumber;
    }

    public void setVisaNumber(String visaNumber) {
        this.visaNumber = visaNumber;
    }

    public String getSunkCostNew() {
        return sunkCostNew;
    }

    public void setSunkCostNew(String sunkCostNew) {
        this.sunkCostNew = sunkCostNew;
    }

    public String getLaborSubOmissionReason() {
        return laborSubOmissionReason;
    }

    public void setLaborSubOmissionReason(String laborSubOmissionReason) {
        this.laborSubOmissionReason = laborSubOmissionReason;
    }

    public String getLaborSubOmissionPerson() {
        return laborSubOmissionPerson;
    }

    public void setLaborSubOmissionPerson(String laborSubOmissionPerson) {
        this.laborSubOmissionPerson = laborSubOmissionPerson;
    }

    public BigDecimal getLaborSubOmissionMny() {
        return laborSubOmissionMny;
    }

    public void setLaborSubOmissionMny(BigDecimal laborSubOmissionMny) {
        this.laborSubOmissionMny = laborSubOmissionMny;
    }

    public String getDrawingOmissionReason() {
        return drawingOmissionReason;
    }

    public void setDrawingOmissionReason(String drawingOmissionReason) {
        this.drawingOmissionReason = drawingOmissionReason;
    }

    public String getDrawingOmissionPerson() {
        return drawingOmissionPerson;
    }

    public void setDrawingOmissionPerson(String drawingOmissionPerson) {
        this.drawingOmissionPerson = drawingOmissionPerson;
    }

    public BigDecimal getDrawingOmissionMny() {
        return drawingOmissionMny;
    }

    public void setDrawingOmissionMny(BigDecimal drawingOmissionMny) {
        this.drawingOmissionMny = drawingOmissionMny;
    }

    public String getWithoutProceduresReason() {
        return withoutProceduresReason;
    }

    public void setWithoutProceduresReason(String withoutProceduresReason) {
        this.withoutProceduresReason = withoutProceduresReason;
    }

    public String getWithoutProceduresPerson() {
        return withoutProceduresPerson;
    }

    public void setWithoutProceduresPerson(String withoutProceduresPerson) {
        this.withoutProceduresPerson = withoutProceduresPerson;
    }

    public BigDecimal getWithoutProceduresMny() {
        return withoutProceduresMny;
    }

    public void setWithoutProceduresMny(BigDecimal withoutProceduresMny) {
        this.withoutProceduresMny = withoutProceduresMny;
    }

    public String getInstructionImpactReason() {
        return instructionImpactReason;
    }

    public void setInstructionImpactReason(String instructionImpactReason) {
        this.instructionImpactReason = instructionImpactReason;
    }

    public String getInstructionImpactPerson() {
        return instructionImpactPerson;
    }

    public void setInstructionImpactPerson(String instructionImpactPerson) {
        this.instructionImpactPerson = instructionImpactPerson;
    }

    public BigDecimal getInstructionImpactMny() {
        return instructionImpactMny;
    }

    public void setInstructionImpactMny(BigDecimal instructionImpactMny) {
        this.instructionImpactMny = instructionImpactMny;
    }

    public String getMgtIssuesReason() {
        return mgtIssuesReason;
    }

    public void setMgtIssuesReason(String mgtIssuesReason) {
        this.mgtIssuesReason = mgtIssuesReason;
    }

    public String getMgtIssuesPerson() {
        return mgtIssuesPerson;
    }

    public void setMgtIssuesPerson(String mgtIssuesPerson) {
        this.mgtIssuesPerson = mgtIssuesPerson;
    }

    public BigDecimal getMgtIssuesMny() {
        return mgtIssuesMny;
    }

    public void setMgtIssuesMny(BigDecimal mgtIssuesMny) {
        this.mgtIssuesMny = mgtIssuesMny;
    }

    public String getProjectManagerIsDeduction() {
        return projectManagerIsDeduction;
    }

    public void setProjectManagerIsDeduction(String projectManagerIsDeduction) {
        this.projectManagerIsDeduction = projectManagerIsDeduction;
    }

    public String getProjectManagerMemo() {
        return projectManagerMemo;
    }

    public void setProjectManagerMemo(String projectManagerMemo) {
        this.projectManagerMemo = projectManagerMemo;
    }

    public String getProjectLeaderIsDeduction() {
        return projectLeaderIsDeduction;
    }

    public void setProjectLeaderIsDeduction(String projectLeaderIsDeduction) {
        this.projectLeaderIsDeduction = projectLeaderIsDeduction;
    }

    public String getProjectLeaderMemo() {
        return projectLeaderMemo;
    }

    public void setProjectLeaderMemo(String projectLeaderMemo) {
        this.projectLeaderMemo = projectLeaderMemo;
    }

    public List<CertificateDeductionVO> getCertificateDeductionList() {
        return certificateDeductionList;
    }

    public void setCertificateDeductionList(List<CertificateDeductionVO> certificateDeductionList) {
        this.certificateDeductionList = certificateDeductionList;
    }

}
