package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包变更记录表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class ChangeRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同编号
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 变更前合同名称
     */
    private String beforeContractName;

    /**
     * 分包类型
     */
    private Long contractType;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private String contractStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 总包企业ID
     */
    private Long customerId;

    /**
     * 总包企业名称
     */
    private String customerName;

    /**
     * 分包企业ID
     */
    private Long supplierId;

    /**
     * 分包企业名称
     */
    private String supplierName;

    /**
     * 签约日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 变更日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 初始版本金额（含税）
     */
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    private BigDecimal beforeChangeMny;

    /**
     * 累计变更金额
     */
    private BigDecimal sumChangeMny;

    /**
     * 累计变更率
     */
    private BigDecimal sumScale;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 采购方式(1:项目自采，2：公司集采)
     */
    private String purchaseType;

    /**
     * 分包内容
     */
    private String memo;

    /**
     * 变更原因
     */
    private String changeReason;

    /**
     * 生效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    /**
     * 变更版本
     */
    private Integer changeVersion;

    /**
     * 是否竣工(1:是，0：否)
     */
    private Boolean finishFlag;

    /**
     * 变更记录集合
     */
    private List<ChangeRecordDetailVO> detailList;

    private String purchaseTypeName;

    private Long invoiceType; // 发票类型

    private String invoiceTypeName;
    private Integer changeStatus;

    /**
     * 定标结果单id
     */
    private Long enquiryPriceBillId;

    /**
     * 定标结果单主题
     */
    private String enquiryPriceBillName;

    private Long contractCategoryId; // 合同类别   自定义档案：sub-contract-category	分包合同类型
    private String contractCategoryName; // 合同类别名称
    private Long majorId; // 专业  自定义档案：sub-major	分包专业
    private String majorName; // 专业名称
    private Long pricingModeId; // 计价方式 自定义档案：contract-valuation-type	合同计价方式
    private String pricingModeName; // 计价方式名称
    private BigDecimal guidePriceMny; // 指导价金额(无税)
    private BigDecimal competeFactor; // 竞聘系数

    /**
     * 合同文件id
     */
    private String contractFileId;

    /**
     * 合同pdfid
     */
    private Long contractPdfId;

    /**
     * 合同模板id
     */
    private Long contractTemplateId;

    /**
     * 归档状态,1:已归档
     */
    private String fileState;

    /**
     * 起草方式online线上upload上传
     */
    private String draftMethod;

    /**
     * 文档类型
     */
    private Long docCategoryId;

    private Long signChannel; // 合同签订渠道

    private String teamName; // 班组名称


    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }


    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSignChannel() {
        return signChannel;
    }
    @ReferDeserialTransfer
    public void setSignChannel(Long signChannel) {
        this.signChannel = signChannel;
    }

    @ReferSerialTransfer(referCode = "contractCategory")
    public Long getDocCategoryId() {
        return docCategoryId;
    }
    @ReferDeserialTransfer
    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }

    public String getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(String contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractPdfId() {
        return contractPdfId;
    }

    public void setContractPdfId(Long contractPdfId) {
        this.contractPdfId = contractPdfId;
    }

    @ReferSerialTransfer(referCode = "ejc-contractTemplate")
    public Long getContractTemplateId() {
        return contractTemplateId;
    }
    @ReferDeserialTransfer
    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }


    public String getFileState() {
        return fileState;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public String getDraftMethod() {
        return draftMethod;
    }

    public void setDraftMethod(String draftMethod) {
        this.draftMethod = draftMethod;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getMajorId() {
        return majorId;
    }

    @ReferDeserialTransfer
    public void setMajorId(Long majorId) {
        this.majorId = majorId;
    }

    public String getMajorName() {
        return majorName;
    }

    public void setMajorName(String majorName) {
        this.majorName = majorName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPricingModeId() {
        return pricingModeId;
    }

    @ReferDeserialTransfer
    public void setPricingModeId(Long pricingModeId) {
        this.pricingModeId = pricingModeId;
    }

    public String getPricingModeName() {
        return pricingModeName;
    }

    public void setPricingModeName(String pricingModeName) {
        this.pricingModeName = pricingModeName;
    }

    public BigDecimal getGuidePriceMny() {
        return guidePriceMny;
    }

    public void setGuidePriceMny(BigDecimal guidePriceMny) {
        this.guidePriceMny = guidePriceMny;
    }

    public BigDecimal getCompeteFactor() {
        return competeFactor;
    }

    public void setCompeteFactor(BigDecimal competeFactor) {
        this.competeFactor = competeFactor;
    }


    @ReferSerialTransfer(referCode = "othprice-result")
    public Long getEnquiryPriceBillId() {
        return enquiryPriceBillId;
    }

    @ReferDeserialTransfer
    public void setEnquiryPriceBillId(Long enquiryPriceBillId) {
        this.enquiryPriceBillId = enquiryPriceBillId;
    }

    public String getEnquiryPriceBillName() {
        return enquiryPriceBillName;
    }

    public void setEnquiryPriceBillName(String enquiryPriceBillName) {
        this.enquiryPriceBillName = enquiryPriceBillName;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }

    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public List<ChangeRecordDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ChangeRecordDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getSumChangeMny() {
        return sumChangeMny;
    }

    public void setSumChangeMny(BigDecimal sumChangeMny) {
        this.sumChangeMny = sumChangeMny;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }

    public Boolean getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Boolean finishFlag) {
        this.finishFlag = finishFlag;
    }
}
